import 'modules/commcellRegistration/js/factory/commcellRegistration.factory.js';
import 'modules/commcellRegistration/js/services/commcellRegistration.svc.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'modules/settings/js/factories/cvPermissions.factory.js';
import 'modules/settings/js/services/settings.svc.js';
import 'modules/commcellRegistration/js/directives/cv-fold-array.directive.js';
import * as columnDefinitions from 'modules/commcellRegistration/js/controllers/registerRouterCommcell.column.template.js';
import {
	serviceCommcellCallouts,
	commonMarkupUtils,
	syncStatusLabels
} from 'modules/commcellRegistration/js/factory/commcellCallout.template.js';

import { acAppSecurityModule } from 'common/js/modules';

var commcellRegistrationMod = acAppSecurityModule;

class commcellRegistrationController {
	constructor(
		$scope,
		cvUtil,
		cvLoc,
		cvToaster,
		$state,
		$dialogs,
		commcellRegistrationFactory,
		commcellRegistrationService,
		cvBreadcrumbsTabsFactory,
		ENTITY_TYPES,
		cvPermissionFactory,
		$compile,
		serviceCommcellConstants,
		multiCommcellFactory,
		commcellRole,
		$modal
	) {
		this.$scope = $scope;
		this.$state = $state;
		this.cvToaster = cvToaster;
		this.$dialogs = $dialogs;
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.commcellRegistrationFactory = commcellRegistrationFactory;
		this.commcellRegistrationService = commcellRegistrationService;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.cvPermissionFactory = cvPermissionFactory;
		this.$compile = $compile;
		this.serviceCommcellConstants = serviceCommcellConstants;
		this.multiCommcellFactory = multiCommcellFactory;
		this.commcellRole = commcellRole;
		this.$modal = $modal;

		this.showErrorMessage = this.showErrorMessage.bind(this);
		this.initializeGridOptions();
		this.initializeScopeFunctions();
		this._setupBreadCrumbs();
	}

	initializeGridOptions() {
		let self = this;
		this.gridOptions = {};
		this.$scope.gridOptions = this.gridOptions;
		this.gridOptions.columns = this._setupColumns();
		this.gridOptions.pageSize = 20;
		this.gridOptions.url = this._getData.bind(this);
		this.gridOptions.tableName = cv.isCometApp ? 'commCellList' : 'serviceCommCells';
		this.gridOptions.gridTitle = this.cvLoc('label.serviceCommcells');
		this.gridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
		this.gridOptions.gridToolbarMenu = [
			{
				id: 'addRouterCommCell',
				label: this.cvLoc('label.commcell.add'),
				hidden: !cv.isMspAdmin || this._isServiceCommcell(),
				onSelect: event => {
					self.commcellRegistrationFactory.registerRemoteCommCell();
				}
			},
			{
				id: 'synchronizeDynamicApps',
				label: this.cvLoc('label.commcell.synchronizeDynamicApps'),
				hidden: !cv.isMspAdmin || this._isServiceCommcell(),
				onSelect: event => {
					self.commcellRegistrationFactory.synchronizeDynamicApps();
				}
			}
		];

		if (!cvConfig.hideMultiCommcellForRouterCommcell) {
			this.gridOptions.gridToolbarMenu.push({
				id: 'addEditSecurity',
				label: this.cvLoc('label.associations'),
				hideOnGridEmpty: true,
				hidden: !cv.isMspAdmin,
				onSelect: event => {
					self.commcellRegistrationFactory.editAssociations(self.commcellRegistrationFactory.registeredCommcellList);
				}
			});
		}
		this.gridOptions.onGridDataBound = this._onGridDataBound.bind(this);
	}

	initializeScopeFunctions() {
		this.$scope.registerCommcell = this.commcellRegistrationFactory.registerRemoteCommCell;
	}

	_isServiceCommcell() {
		let currentRole = _.get(cvApp, 'commcellInfo.commcellRole', 0);
		return (
			this.multiCommcellFactory.checkRoleExist(currentRole, this.commcellRole.IDPCOMMCELL_SERVICECOMMCELL) ||
			this.multiCommcellFactory.checkRoleExist(currentRole, this.commcellRole.ROUTERCOMMCELL_SERVICECOMMCELL)
		);
	}

	_onGridDataBound(dataItem, row) {
		let permittedOptions = dataItem.permittedOptions;
		this.$scope[`permittedOptions${permittedOptions.entityId}`] = permittedOptions;
		let permittedOptionsTemplate = `<cv-permitted-actions cv-permitted-options="permittedOptions${permittedOptions.entityId}"></cv-permitted-actions>`;
		row.find('.permittedActions').html(this.$compile(permittedOptionsTemplate)(this.$scope));
	}

	showErrorMessage(errorMessage) {
		this.cvToaster.showErrorMessageWrapper(errorMessage, '5000');
		// Even if sync fails, need to get list of service commcells, so that we get updated sync status
		this.grid.refreshData();
	}

	unregisterCommcell(rowEntity) {
		let self = this;
		let modalInstance = self.$modal.open({
			templateUrl: appUtil.appRoot + 'modules/commcellRegistration/partials/deleteCommcell.jsp',
			windowClass: 'small-size',
			controllerAs: 'ctrl',
			controller: [
				'commcellRegistrationService',
				'rowEntity',
				'cvLoc',
				'$uibModalInstance',
				function(commcellRegistrationService, rowEntity, cvLoc, $uibModalInstance) {
					let ctrl = this;
					ctrl.confirmText = cvLoc('prompt.confirmUnregisterMessage', `<b>${rowEntity.commCell.commCellName}</b>`);
					ctrl.confirmTitle = cvLoc('label.confirmDelete');
					ctrl.forceUnregister = false;
					ctrl.submit = function() {
						commcellRegistrationService
							.unRegisterCommcell({
								commcell: {
									commCell: {
										commCellId: rowEntity.commCell.commCellId,
										csGUID: rowEntity.commCell.csGUID
									},
									ccClientId: rowEntity.ccClientId,
									ccClientName: rowEntity.ccClientName,
									interfaceName: rowEntity.interfaceName
								},
								forceUnregister: ctrl.forceUnregister
							})
							.then(result => {
								if (result && result.data && result.data.resultCode == 0) {
									$uibModalInstance.close(true);
								} else {
									$uibModalInstance.close(result.data.resultMessage);
								}
							})
							.catch(() => {
								$uibModalInstance.close(false);
							});
					};

					ctrl.cancel = function() {
						$uibModalInstance.dismiss();
					};
				}
			],
			resolve: {
				rowEntity: () => rowEntity
			}
		});
		modalInstance.result.then(result => {
			if (result == true) {
				self.cvToaster.showSuccessMessage(self.cvUtil.infoMsgLoc('label.serviceCommcellUnregisteredSuccess'));
				self.commcellRegistrationFactory.updateCvAppOnUnregister(self.$scope, rowEntity);
				self.grid.refreshData();
			} else {
				self.showErrorMessage(result);
			}
		});
	}

	syncUsers(commCell) {
		let self = this;
		let csGuid = commCell.csGUID;
		if (typeof csGuid !== 'undefined') {
			csGuid = csGuid.indexOf('*') !== -1 ? csGuid.split('*')[1] : csGuid;
			this.commcellRegistrationService
				.syncUsersFromServiceCommcell(csGuid)
				.success(data => {
					if (typeof data !== 'undefined' && typeof data.errorCode !== 'undefined' && data.errorCode == 0) {
						self.cvToaster.showSuccessMessage(
							self.cvUtil.infoMsg(self.cvLoc('label.usersSyncedSuccessfully', '<b>' + commCell.commCellName + '</b>'))
						);
						self.grid.refreshData();
					} else {
						//handle errorMessage.
						self.showErrorMessage(_.get(data, 'errorMessage'));
					}
				})
				.error(self.showErrorMessage);
		} else {
			self.showErrorMessage(self.cvLoc('label.syncFailure'));
		}
	}

	_computePermittedActions(entity) {
		let arrayOfActionsToOverride = [
			{
				DELETE: {
					show: entity.multiCommcellType !== this.serviceCommcellConstants.CLOUDSERVICECOMMCELL,
					onClick: this.unregisterCommcell.bind(this, entity)
				}
			}
		];

		let commcellActions = [
			{
				REFRESH: {
					show: entity.multiCommcellType !== this.serviceCommcellConstants.CLOUDSERVICECOMMCELL,
					onClick: this.syncUsers.bind(this, entity.commCell)
				}
			}
		];

		if (entity.isIdp) {
			arrayOfActionsToOverride = [];
			commcellActions = [];
		}

		let commcellSpecificActions = this.cvPermissionFactory.updateAndGetCommonActionsList(
			commcellActions,
			false,
			this.commcellRegistrationFactory.commcellSpecificActions()
		);

		return commcellSpecificActions.concat(
			this.cvPermissionFactory.updateAndGetCommonActionsList(
				arrayOfActionsToOverride,
				false,
				this.cvPermissionFactory.commonPermittedList
			)
		);
	}

	_getData(options) {
		let self = this;
		this.commcellRegistrationFactory
			.loadRegisteredCommcells()
			.success(data => {
				if (data.commcellsList) {
					self.commcellRegistrationFactory.registeredCommcellList = data.commcellsList;
					data.commcellsList.forEach(commcell => {
						commcell.permittedOptions = {
							entityType: self.ENTITY_TYPES.COMMCELL_ENTITY,
							entityId: commcell.commCell.commCellId,
							entityName: commcell.commCell.commCellName,
							appendToBody: true,
							permittedActionList: self._computePermittedActions(commcell)
						};

						commcell.commcellDetailUrl = self.cvUtil.modifyUrlForComet(
							'#/serviceCommcells/' + commcell.commCell.commCellId,
							'IDP'
						);

						commcell.target = cv.isCometApp ? '_blank' : '_self';

						commcell.syncStatusText = commonMarkupUtils.getLocalizedStatus(
							self.cvLoc,
							_.get(commcell, 'syncStatus.status'),
							this._isSyncApplicable(commcell)
						);

						// Initializing statusCalloutContent to empty string so that template is rendered in kendo grid
						// when status is unavailable
						commcell.statusCalloutContent = '';

						if (_.has(commcell, 'syncStatus.status') && commcell.syncStatus.status !== 0) {
							let syncTime = commcell.lastSyncWithIDP;
							let time = syncTime ? moment.unix(syncTime).calendar() : self.cvLoc('label.notSynced');

							commcell.syncStatusClass = commonMarkupUtils.getStatusClass(commcell.syncStatus.status) || '';
							commcell.statusCalloutContent = serviceCommcellCallouts.getSyncStatusTemplate(
								self.cvLoc,
								commcell.syncStatus,
								time
							);
						}

						if (
							(commcell.multiCommcellType === self.serviceCommcellConstants.SERVICECOMMCELL_FOR_ROUTER &&
								!cvConfig.showRouterForServiceCommcell) ||
							(cv.isCometApp && commcell.isIdp)
						) {
							// Commcell URL is not required in case when key is disabled and if its a router or if its a IdP in comet app
							commcell.commcellDetailUrl = undefined;
						}

						commcell.commcellRoleFormatted = self.multiCommcellFactory.getCommcellRole(commcell.commcellRoleInt);
						if (this._isCloudServiceCommcell(commcell)) {
							commcell.isCloudServiceCommcell = true;
							commcell.displayName = this.cvLoc('label.nav.Metallic');
						} else {
							commcell.isCloudServiceCommcell = false;
							commcell.displayName = commcell.commCell.commCellName;
						}
					});
					options.success(data.commcellsList);
				} else {
					options.success([]);
				}
			})
			.error(this.showErrorMessage);
	}

	_isCloudServiceCommcell(commcell) {
		let commcellRole = _.get(commcell, 'commcellRoleInt', 0);
		return this.multiCommcellFactory.checkRoleExist(commcellRole, this.commcellRole.CLOUDSERVICE);
	}

	_isSyncApplicable(commcell) {
		if (_.get(commcell, 'isIdp', false) || this._isCloudServiceCommcell(commcell)) {
			// For IDP and cloud service commcells, Sync is not applicable
			return false;
		}
		// Add support for roles (Loopy) later on
		return true;
	}

	_setupColumns() {
		return columnDefinitions.getColumnDefinitions(null, [], {
			cvLoc: this.cvLoc,
			syncStatusLabels
		});
	}

	_setupBreadCrumbs() {
		if (cv.isCometApp) {
			return;
		}
		let breadCrumbs = [];

		breadCrumbs.push({
			title: this.cvLoc('label.nav.system'),
			link: '#nav/settings'
		});

		this.cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
}

commcellRegistrationController.$inject = [
	'$scope',
	'cvUtil',
	'cvLoc',
	'cvToaster',
	'$state',
	'$dialogs',
	'commcellRegistrationFactory',
	'commcellRegistrationService',
	'cvBreadcrumbsTabsFactory',
	'ENTITY_TYPES',
	'cvPermissionFactory',
	'$compile',
	'serviceCommcellConstants',
	'multiCommcellFactory',
	'commcellRole',
	'$uibModal'
];

commcellRegistrationMod.controller('routerCommcellsController', commcellRegistrationController);

export default commcellRegistrationMod;
