import 'modules/commcellRegistration/js/services/commcellRegistration.svc.js';
import 'modules/commcellRegistration/js/factory/commcellRegistration.factory.js';
import 'modules/settings/js/services/settings.svc.js';

import { acAppSecurityModule } from 'common/js/modules';

var commcellRegistrationMod = acAppSecurityModule;

commcellRegistrationMod.controller('registerRouterCommcellController', [
	'cvLoc',
	'commcellRegistrationService',
	'$uibModalInstance',
	'$state',
	'cvToaster',
	'cvUtil',
	'$dialogs',
	'$scope',
	'commcellRegistrationFactory',
	'settingsService',
	'commcellFactory',
	'COMMCELL_ICONS',
	function(
		cvLoc,
		commcellRegistrationService,
		$modalInstance,
		$state,
		cvToaster,
		cvUtil,
		$dialogs,
		$scope,
		commcellRegistrationFactory,
		settingsService,
		commcellFactory,
		COMMCELL_ICONS
	) {
		var self = this;

		self.model = {
			commcellHostname: '',
			username: '',
			password: '',
			isGlobalIDPCommcell: false,
			enableRoutingFlag: true, //true by default.
			isGlobalWebConsoleConfigured: false
		};
		self.model.serverMessage = '';

		self.enabledCCForGlobalCC = [];
		self.routerCommcellIcon = COMMCELL_ICONS.ROUTER_COMMCELL;
		self.idpCommcellIcon = COMMCELL_ICONS.IDP_COMMCELL;
		let globalCCList = [];
		function fetchGlobalCCs() {
			settingsService
				.getGlobalCCConfig()
				.success(function(data) {
					if (data && data.webconsoles && data.webconsoles.length > 0) {
						globalCCList = data.webconsoles;
						self.enabledCCForGlobalCC = data.webconsoles.filter(function(wc) {
							return wc.isSupported;
						});
					}
				})
				.error(function(err) {
					self.model.serverMessage = cvUtil.errMsgLoc('error.globalCCLoadError');
				});
		}
		fetchGlobalCCs();

		self.openConfigureGlobalCCModal = function() {
			let globalCCModal = commcellFactory.openConfigureGlobalCCModal(globalCCList);
			globalCCModal.result.then(
				function(data) {
					globalCCList = data;
					self.enabledCCForGlobalCC = data.filter(function(wc) {
						return wc.isSupported;
					});
				},
				function(err) {}
			);
		};

		self.registerCommcell = function() {
			self.model.serverMessage = ''; //flushing
			self.model.isGlobalWebConsoleConfigured =
				self.model.isGlobalIDPCommcell && self.model.isGlobalWebConsoleConfigured;
			commcellRegistrationService
				.registerCommcell(self.model)
				.success(registrationSuccessCallBack)
				.error(registrationErrorCallBack);
		};

		self.globalIdpName = cv.commcellName;

		function registrationSuccessCallBack(data) {
			commcellRegistrationFactory.updateCvAppOnRegistration($scope, self.model.isGlobalIDPCommcell);

			if (data.resultCode === 1014 && data.resultMessage && angular.isString(data.resultMessage)) {
				//alert(data.resultMessage)
				var yesOrNoFunction = function() {
					$modalInstance.close();
					$state.forceReload();
					cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('label.serviceCommcellRegistrationSuccess'));
				};
				var callBackFunctions = {
					yesFunction: yesOrNoFunction,
					noFunction: yesOrNoFunction
				};
				$dialogs.confirm(cvLoc('OK'), data.resultMessage, callBackFunctions);
			} else {
				$modalInstance.close();
				$state.forceReload();
				cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('label.serviceCommcellRegistrationSuccess'));
			}
		}

		function registrationErrorCallBack(errorMessage) {
			var message = '';
			if (errorMessage && angular.isString(errorMessage)) {
				message = cvUtil.errMsg(errorMessage);
			} else {
				message = cvUtil.errMsgLoc('generic_error');
			}
			self.model.serverMessage = message;
		}

		self.close = function() {
			$modalInstance.dismiss();
		};

		self.registerForRoutingToggle = function() {
			self.model.enableRoutingFlag = !self.model.enableRoutingFlag;
		};

		self.registerAsGlobalIdP = shouldRegisterAsIdP => {
			self.model.isGlobalIDPCommcell = shouldRegisterAsIdP;
		};
	}
]);

export default commcellRegistrationMod;
