let getInterfaceColumn = cvLoc => ({
	interfaceName: {
		title: cvLoc('label.serviceCommcellHostName'),
		type: 'string',
		template: interfaceTemplate(),
		width: '20%',
		sortable: true
	}
});

let getCommCellNameColumn = cvLoc => ({
	'commCell.commCellName': {
		title: cvLoc('label.commcellName'),
		type: 'string',
		template: commCellNameTemplate(cvLoc),
		width: '30%',
		sortable: true
	}
});

let getConfigureAsCCColumn = cvLoc => ({
	isGlobalWebConsoleConfigured: {
		title: cvLoc('label.serviceCommcellUseGlobalCC'),
		type: 'boolean',
		template: globalCCTickTemplate(),
		width: '10%'
	}
});

let getSyncStatus = (cvLoc, syncStatusLabels) => {
	let filters = [];

	if (syncStatusLabels) {
		filters = [
			{ label: cvLoc(syncStatusLabels.SUCCESS_SHORT), value: cvLoc(syncStatusLabels.SUCCESS_SHORT) },
			{ label: cvLoc(syncStatusLabels.FAILED_SHORT), value: cvLoc(syncStatusLabels.FAILED_SHORT) },
			{ label: cvLoc(syncStatusLabels.NOT_SYNCED), value: cvLoc(syncStatusLabels.NOT_SYNCED) },
			{ label: cvLoc(syncStatusLabels.NOT_APPLICABLE), value: cvLoc(syncStatusLabels.NOT_APPLICABLE) }
		];
	}

	return {
		syncStatusText: {
			title: cvLoc('header.syncStatus'),
			type: 'string',
			template: getSyncStatusTemplate(),
			with: '20%',
			searchable: false,
			data: filters,
			filterType: 'checkboxmultiselect',
			attributes: {
				class: 'no-tooltip'
			}
		}
	};
};

let getActionsColumn = cvLoc => ({
	actions: {
		title: cvLoc('label.actions'),
		sortable: false,
		template: actionsTemplate(),
		attributes: {
			class: 'permitted-actions'
		},
		width: '10%',
		disableColumnFilter: true,
		disableViewFiltering: true
	}
});

let getCommcellRolesColumn = cvLoc => ({
	commcellRoleFormatted: {
		title: cvLoc('label.roleColumn'),
		type: 'string',
		width: '20%',
		searchable: true
	}
});

let interfaceTemplate = () =>
	`#if(!isCloudServiceCommcell){#
		<span class="crop">#=interfaceName#</span>
	#}#`;

let commCellNameTemplate = cvLoc =>
	`#if(commcellDetailUrl){#
					<a href="#:commcellDetailUrl#" target="#:target#" class="crop">#:displayName#</a>
			#} else {#
				<span class="crop">#:displayName#</span>
			#}#`;

let globalCCTickTemplate = () =>
	`<div class="k-icon margin-x-auto">#if(isGlobalWebConsoleConfigured){#<span class="k-i-check"></span>#}else{#<span class="k-i-close"></span>#}#</div>`;

let getSyncStatusTemplate = () =>
	`#if(statusCalloutContent){#
		<span cv-toggle="callout" class="text-center" data-content="#:statusCalloutContent#" data-trigger="click">
			<cv-help-text><span class="help-label #:syncStatusClass#">#:syncStatusText#</span></cv-help-text>
		</span>
	#}else{#
		<span class="crop text-center">#:syncStatusText#</span>
	#}#`;

let actionsTemplate = () => `<div class="permittedActions"></div>`;

export const getColumnDefinitions = (onActionClick, filterLists, angularLibs) => {
	let columnList = {
		...getCommCellNameColumn(angularLibs.cvLoc),
		...getInterfaceColumn(angularLibs.cvLoc),
		...getSyncStatus(angularLibs.cvLoc, angularLibs.syncStatusLabels),
		...getCommcellRolesColumn(angularLibs.cvLoc),
		...getConfigureAsCCColumn(angularLibs.cvLoc),
		...getActionsColumn(angularLibs.cvLoc)
	};
	return columnList;
};
