import { acAppSecurityModule } from 'common/js/modules';

class EditCommcellPropertiesController {
	constructor(
		cvLoc,
		commcellProperties,
		commcellRegistrationService,
		$uibModalInstance,
		cvUtil,
		commcellId,
		cvToaster
	) {
		this.cvLoc = cvLoc;
		this.commcellProperties = commcellProperties;
		this.commcellRegistrationService = commcellRegistrationService;
		this.$modalInstance = $uibModalInstance;
		this.cvUtil = cvUtil;
		this.commcellId = commcellId;
		this.cvToaster = cvToaster;

		this.serverMessage = this.cvUtil.emptyMsg();

		this._initModels();
	}

	_showErrorMessage(error) {
		this.serverMessage = this.cvUtil.errMsgWrapper(_.get(error, 'data.errorString') || error);
	}

	_initModels() {
		this.model = { ...this.commcellProperties, commCellId: this.commcellId };
	}

	saveCommcellProperties() {
		this.serverMessage = this.cvUtil.emptyMsg();

		this.commcellRegistrationService.saveCommcellProperties({ properties: this.model }).then(
			response => {
				if (_.has(response, 'data.errorCode') && response.data.errorCode !== 0) {
					this._showErrorMessage(response);
					return;
				}

				this.cvToaster.showSuccessMessage({
					message: this.cvLoc('label.success.commcellProperties'),
					ttl: '5000'
				});

				this.$modalInstance.close(this.model);
			},
			error => {
				this._showErrorMessage(error);
			}
		);
	}

	closeModal() {
		this.$modalInstance.dismiss();
	}
}

EditCommcellPropertiesController.$inject = [
	'cvLoc',
	'commcellProperties',
	'commcellRegistrationService',
	'$uibModalInstance',
	'cvUtil',
	'commcellId',
	'cvToaster'
];

acAppSecurityModule.controller('editCommcellPropertiesController', EditCommcellPropertiesController);

export default acAppSecurityModule;
