import { cloudSubscriptionsSetupModule } from 'common/js/modules';
import 'modules/cloud/js/services/manageSubscriptions.svc';

cloudSubscriptionsSetupModule.controller('manageSubscriptionsController', [
	'cvLoc',
	'CLOUD_CONSTANTS',
	'cvToaster',
	'cloudSubscriptionsService',
	function(cvLoc, CLOUD_CONSTANTS, cvToaster, cloudSubscriptionsService) {
		var self = this;

		self.subscriptionTypes = [
			{
				type: CLOUD_CONSTANTS.SUBSCRIPTION_TYPE.O365,
				localizeTypeKey: CLOUD_CONSTANTS.SUBSCRIPTION_TYPE.O365.localizeTypeKey, //name to be displayed in UI
				subscriptionID: 2,
				isDefault: false,
				isSubscribed: false,
				description: cvLoc('label.subscription.O365.desc'),
				statusDesc: cvLoc('label.subscription.request')
			},
			{
				type: CLOUD_CONSTANTS.SUBSCRIPTION_TYPE.ENDPOINT,
				localizeTypeKey: CLOUD_CONSTANTS.SUBSCRIPTION_TYPE.ENDPOINT.localizeTypeKey, //name to be displayed in UI
				subscriptionID: 1,
				isDefault: false,
				isSubscribed: false,
				description: cvLoc('label.subscription.endpoint.desc'),
				statusDesc: cvLoc('label.subscription.request')
			}
		];

		self.handleTileClick = function(appType) {
			if (appType != null && appType.subscriptionID > 0) {
				cloudSubscriptionsService
					.requestSaaSSusbcription(appType.subscriptionID)
					.success(function(data) {
						if (data == 0) {
							cvToaster.showSuccessMessage({
								ttl: '5000',
								message: cvLoc('label.subscription.thanks')
							});
							appType.statusDesc = cvLoc('label.subscription.processing');
							appType.isSubscribed = true;
							self.processingMsg = cvLoc('label.subscription.processingTime');
							appType.status = 2;
						} else {
							cvToaster.showErrorMessage({
								ttl: '5000',
								message: cvLoc('label.subscription.error') //"Error requesting subscription."
							});
						}
					})
					.error(function() {
						cvToaster.showErrorMessage({
							ttl: '5000',
							message: cvLoc('label.subscription.error')
						});
					});
			}
		};

		self.initialize = function() {
			angular.forEach(self.subscriptionTypes, function(appType) {
				appType.svgPath = appUtil.appRoot + appType.type.svg;
				appType.localizedType = cvLoc(appType.type.localizeTypeKey);
				cloudSubscriptionsService
					.isSubscribed(appType.subscriptionID)
					.success(function(data) {
						if (data) {
							if (data.erCode == 0 && data.userSubscription == appType.subscriptionID) {
								if (data.subscriptionStatus == 1) {
									appType.statusDesc = cvLoc('label.subscription.subscribed'); //"You are already subscribed.";
									appType.isSubscribed = true;
									self.processingMsg = '';
									appType.status = 1;
								} else if (data.subscriptionStatus == 2) {
									appType.statusDesc = cvLoc('label.subscription.processing'); //"Your subscription request is being processed";
									appType.isSubscribed = true;
									self.processingMsg = cvLoc('label.subscription.processingTime');
									appType.status = 2;
								} else if (data.subscriptionStatus == 3) {
									appType.statusDesc = cvLoc('label.subscription.request'); //"Your subscription request is expired";
									appType.isSubscribed = false;
									appType.status = 3;
								} else {
									// You are not subscribed yet
									appType.statusDesc = cvLoc('label.subscription.request'); //"Your can request subscription.";
									appType.isSubscribed = false;
									appType.status = 0;
								}
							}
						} else {
							cvToaster.showErrorMessage({
								ttl: '5000',
								message: cvLoc('label.subscription.errorInfo')
							});
						}
					})
					.error(function() {
						cvToaster.showErrorMessage({
							ttl: '5000',
							message: cvLoc('label.subscription.errorInfo')
						});
					});
			});
		};
		self.initialize();
	}
]);

export default cloudSubscriptionsSetupModule;
