<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
 	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
 	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
 	<cv:cvMessages bundle="localization.anomaly"></cv:cvMessages>
 	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>

<div>
	<div class="flex-detail-header">
		<h3>
			<span data-ng-bind="fileAnomalyDetailsCtrl.displayName"/>
		</h3>
		<span class="flex-page-actions">
			<a class="margin-right-20" data-ng-if="fileAnomalyDetailsCtrl.isVMeSupported" data-ng-click="fileAnomalyDetailsCtrl.recoverAsVM()">
				<cv:msg key="label.recoverAsVM" bundle="anomaly"/>
			</a>
			<a class="margin-right-20" data-ng-click="fileAnomalyDetailsCtrl.browseAndRestore()">
				<cv:msg key="label.recoverFiles" bundle="anomaly"/>
			</a>
			<a class="margin-right-20" data-ng-if="fileAnomalyDetailsCtrl.isClearAnomalySupported" data-ng-click="fileAnomalyDetailsCtrl.clearAnomaly()">
				<cv:msg key="label.clearAnomaly" bundle="anomaly"/>
			</a>
		</span>
	</div>

	<div data-ng-if="!fileAnomalyDetailsCtrl.noAnomalyDataAvailable && fileAnomalyDetailsCtrl.initialAnomalyDataLoaded">
		<!-- File anomaly type info -->
		<div class="col-xs-12 margin-bottom-15">
		    <span data-ng-bind="fileAnomalyDetailsCtrl.anomalyType"/>
		</div>
	</div>

	<!-- Highchart for file anomaly -->
	<div class="row" data-ng-if="fileAnomalyDetailsCtrl.showChart">
		<div class="col-xs-12">
			<cv-tile-component>
				<div id="chartContainer" name="chartContainer" />
			</cv-tile-component>
		</div>
	</div>
	<div class="row" data-ng-if="!fileAnomalyDetailsCtrl.noAnomalyDataAvailable && fileAnomalyDetailsCtrl.initialAnomalyDataLoaded && fileAnomalyDetailsCtrl.noStatsFoundForChart">
		<div class="col-xs-12">
			<cv-tile-component data-ac-id="empty-chart" data-title="<cv:msg key="header.fileAnomaly" bundle="anomaly"/>">
				<div class="server-message">
					<cv:msg key="label.info.noStatsFound" bundle="anomaly"/>
				</div>
			</cv-tile-component>
		</div>
	</div>

	<!-- Grid for file anomaly -->
	<div data-ng-if="fileAnomalyDetailsCtrl.initialAnomalyDataLoaded">
		<!-- Live anomaly grid -->
		<div class="row" data-ng-if="!fileAnomalyDetailsCtrl.isBackupAnomaly">
			<div class="col-xs-12">
				<cv-kendo-grid data-cv-grid-options="fileAnomalyDetailsCtrl.gridOptionsLive"></cv-kendo-grid>
			</div>
		</div>

		<!-- Backup anomaly grid -->
		<div class="row" data-ng-if="fileAnomalyDetailsCtrl.isBackupAnomaly">
			<div class="col-xs-12">
				<cv-kendo-grid data-cv-grid-options="fileAnomalyDetailsCtrl.gridOptionsBackup"></cv-kendo-grid>
			</div>
		</div>
	</div>
	
	<div class="row" data-ng-if="!fileAnomalyDetailsCtrl.initialAnomalyDataLoaded">
		<div class="col-xs-12">
			<div class="server-message">
				<cv:msg key="Loading" bundle="messages"/>
			</div>
		</div>
	</div>
</div>