import { acAppAnomaly } from 'common/js/modules';

var app = acAppAnomaly;

app.service('fileAnomalyService', [
	'$http',
	function($http) {
		this.getFileAnomalyClientList = () => {
			return $http.get('proxy/Client/Anomaly');
		};

		this.getFileAnomalyInfo = (filter, clients, aggregateHour, timeFrame) => {
			return $http.get(
				'proxy/Client/AnomalyRecord?filter=' +
					filter +
					'&clients=' +
					clients +
					'&aggregateHour=' +
					aggregateHour +
					'&timeFrame=' +
					timeFrame
			);
		};

		this.clearFileAnomaly = request => {
			return $http.post(`proxy/Client/PruneAnomalyRecord`, JSON.stringify(request), httpHeader['jsonDefaultHeader']);
		};
	}
]);

export default app;
