import 'modules/anomaly/fileAnomaly/js/constants/anomalyType.constants.js';

import { acAppAnomaly } from 'common/js/modules';

var app = acAppAnomaly;

app.factory('fileAnomalyFactory', [
	'cvLoc',
	'ANOMALY_TYPE_ENUM',
	function fileAnomalyFactory(cvLoc, ANOMALY_TYPE_ENUM) {
		fileAnomalyFactory.getFileAnomalyType = function(type) {
			let anomalyStr = '';
			let separator = '';

			if ((type & ANOMALY_TYPE_ENUM.ANOMALY_CREATED) == ANOMALY_TYPE_ENUM.ANOMALY_CREATED) {
				anomalyStr = anomalyStr + separator + cvLoc('label.creation');
				separator = ', ';
			}

			if ((type & ANOMALY_TYPE_ENUM.ANOMALY_RENAMED) == ANOMALY_TYPE_ENUM.ANOMALY_RENAMED) {
				anomalyStr = anomalyStr + separator + cvLoc('label.rename');
				separator = ', ';
			}

			if ((type & ANOMALY_TYPE_ENUM.ANOMALY_MODIFIED) == ANOMALY_TYPE_ENUM.ANOMALY_MODIFIED) {
				anomalyStr = anomalyStr + separator + cvLoc('label.modification');
				separator = ', ';
			}

			if ((type & ANOMALY_TYPE_ENUM.ANOMALY_DELETED) == ANOMALY_TYPE_ENUM.ANOMALY_DELETED) {
				anomalyStr = anomalyStr + separator + cvLoc('label.deletion');
				separator = '';
			}

			return anomalyStr == '' ? cvLoc('label.notAvailable') : anomalyStr;
		};

		fileAnomalyFactory.getTimeString = function(time, format) {
			let dateFormat = 'MMM d, h:mm tt';
			if (format) {
				dateFormat = format;
			}
			return time && time > 0 ? kendo.toString(new Date(time * 1000), dateFormat) : cvLoc('label.notAvailable');
		};

		return fileAnomalyFactory;
	}
]);

export default app;
