import 'modules/anomaly/fileAnomaly/js/constants/anomalyAction.constants.js';
import 'vsa/js/constants/servers.constants.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';
import 'modules/anomaly/fileAnomaly/js/services/fileAnomaly.svc.js';
import 'vsa/js/services/restore.svc.js';
import 'adminConsole/js/services/agents.svc.js';
import 'modules/anomaly/fileAnomaly/js/factories/fileAnomaly.factory.js';
import 'adminConsole/js/controllers/clients.ctrl.js';
import * as fileAnomalyTemplate from 'modules/anomaly/fileAnomaly/js/controllers/columnTemplates/fileAnomaly.column.template';
import { acAppAnomaly } from 'common/js/modules';

var app = acAppAnomaly;

class FileAnomalyController {
	constructor(
		cvLoc,
		cvToaster,
		$compile,
		$filter,
		$scope,
		$state,
		$modal,
		$dialogs,
		fileAnomalyService,
		restoreService,
		agentService,
		AppTypes,
		POLICY_APP_TYPE,
		VSA_VENDOR,
		ANOMALY,
		ANOMALY_ACTIONS,
		fileAnomalyFactory,
		clientFactory
	) {
		this.cvLoc = cvLoc;
		this.cvToaster = cvToaster;
		this.$compile = $compile;
		this.$filter = $filter;
		this.$scope = $scope;
		this.$state = $state;
		this.$modal = $modal;
		this.$dialogs = $dialogs;
		this.fileAnomalyService = fileAnomalyService;
		this.restoreService = restoreService;
		this.agentService = agentService;
		this.AppTypes = AppTypes;
		this.POLICY_APP_TYPE = POLICY_APP_TYPE;
		this.VSA_VENDOR = VSA_VENDOR;
		this.ANOMALY = ANOMALY;
		this.ANOMALY_ACTIONS = ANOMALY_ACTIONS;
		this.fileAnomalyFactory = fileAnomalyFactory;
		this.clientFactory = clientFactory;
	}

	$onInit() {
		this.recoveryTargets = [];

		this._getRecoveryTargets();
		this._initializeGrid();
	}

	_initializeGrid() {
		const self = this;
		this.gridOptions = {};
		this.gridOptions.enableResizing = true;
		this.gridOptions.enableCsvExport = true;
		this.gridOptions.exportAllPages = true;
		this.gridOptions.exportName = 'UnusualFileActivityClients';
		this.gridOptions.columns = this._initColumnDefs();
		this.gridOptions.gridTitle = this.cvLoc('header.fileAnomaly');
		this.gridOptions.tableName = 'fileAnomalyTable';
		this.gridOptions.enableCheckBoxColumn = true;
		this.gridOptions.enableMultiSelect = true;
		this.gridOptions.url = this._fetchData.bind(this);
		this.gridOptions.usePageToolbar = true;
		this.gridOptions.onGridDataBound = this._onGridDataBound.bind(this);
		this.gridOptions.hasViews = true;
		this.gridOptions.enablePaging = true;
		this.gridOptions.pageSize = 20;
		this.gridOptions.pageSizes = [5, 10, 20, 50, 100];
		this.gridOptions.sortDirection = {
			field: 'clientName',
			dir: 'asc'
		};
		this.gridOptions.onGridSelectionChange = this._onSelectionChange.bind(this);
		this.gridOptions.actionMenu = [
			// TODO: uncomment when the support is extended.
			/*{
				id: this.ANOMALY_ACTIONS.RECOVER_AS_VM,
				label: this.cvLoc('label.recoverAsVM'),
				onSelect: this._onBatchActionMenuSelect.bind(this)
			},*/
			{
				id: this.ANOMALY_ACTIONS.CLEAR_ANOMALY,
				label: this.cvLoc('label.clearAnomaly'),
				onSelect: this._onBatchActionMenuSelect.bind(this)
			}
		];

		this.gridOptions.gridEmptyMessage = this._emptyGridMessage();
		this.gridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
	}

	_initColumnDefs() {
		return fileAnomalyTemplate.getfileAnomalyColumnTemplate({ cvLoc: this.cvLoc });
	}

	_onBatchActionMenuSelect({ optionId, selectedRowValues }) {
		if (selectedRowValues.length === 1) {
			this._performOperation(optionId, selectedRowValues[0]);
		} else {
			this._performMultiOperation(optionId, selectedRowValues);
		}
	}

	_performOperation(action, client) {
		if (action === this.ANOMALY_ACTIONS.RECOVER_AS_VM) {
			this._recoverAsVM(client);
		} else if (action === this.ANOMALY_ACTIONS.CLEAR_ANOMALY) {
			this._clearAnomaly(client);
		}
	}

	_performMultiOperation(action, clients) {
		if (action === this.ANOMALY_ACTIONS.RECOVER_AS_VM) {
			this._recoverAsVMMultipleClients(clients);
		} else if (action === this.ANOMALY_ACTIONS.CLEAR_ANOMALY) {
			this._clearAnomalyMultipleClients(clients);
		}
	}

	_recoverAsVM(client) {
		let self = this;
		let backupSetList = [];
		this.agentService
			.getBs(undefined, client.clientId, client.appType, false)
			.success(function(backupSets) {
				backupSetList = backupSets.backupsetProperties;
				self._launchVMeModal(client, backupSetList);
			})
			.error(function() {
				self.cvToaster.showErrorMessage({
					ttl: '10000',
					message: self.cvLoc('label.noBackupSetsAvailableForVMe')
				});
			});
	}

	_launchVMeModal(client, backupSetList) {
		let self = this;
		this.$modal.open({
			templateUrl: appUtil.appRoot + 'vsa/partials/virtualizeFileSystem.jsp',
			backdrop: 'static',
			controller: [
				'$scope',
				'$uibModalInstance',
				'$state',
				'cvLoc',
				'vMeParams',
				function($scope, $modalInstance, $state, cvLoc, vMeParams) {
					$scope.virtualizeToVendor = self.VSA_VENDOR.VMWARE;
					$scope.vendor = $scope.virtualizeToVendor;
					$scope.vMeParams = vMeParams;

					$scope.$modalInstance = $modalInstance; //unfortunately $modalInstance is not being injected in modal's controller, so passing it through scope hierarchy
					$scope.cancel = function() {
						$modalInstance.dismiss();
					};
					$scope.buildVirtualizeModalUrl = function(filePath) {
						return appUtil.appRoot + 'vsa/partials/' + filePath;
					};
				}
			],
			resolve: {
				vMeParams: function() {
					return {
						vMeFor: self.ANOMALY.FILE_ANOMALY,
						serverId: client.clientId,
						serverName: client.clientName,
						serverDisplayName: client.displayName,
						applicationId: client.appType,
						backupSets: backupSetList,
						osInfo: client.osInfo,
						recoveryTargets: self.recoveryTargets,
						pointInTime: client.detectedTime
					};
				}
			}
		});
	}

	_recoverAsVMMultipleClients(clients) {}

	_clearAnomaly(client) {
		let clients = [];
		clients.push(client);
		return this._clearAnomalyMultipleClients(clients);
	}

	_clearAnomalyMultipleClients(clients) {
		const self = this;
		let clientsList = [];
		let clientNameList = undefined;
		clients.forEach(client => {
			clientsList.push({
				_type_: 'CLIENT_ENTITY',
				clientId: client.clientId,
				clientName: client.clientName
			});

			clientNameList = clientNameList ? clientNameList + ', ' + client.clientName : client.clientName;
		});

		this.$dialogs.confirm(this.cvLoc('label.clearAnomaly'), this.cvLoc('label.confirmClearAnomaly', clientNameList), {
			noFunction: () => {},
			yesFunction: () => {
				return this.fileAnomalyService
					.clearFileAnomaly({
						clients: clientsList
					})
					.success(data => {
						self.grid.refreshData();
					})
					.error(err => {
						self.cvToaster.showErrorMessage({
							message: err
						});
					});
			}
		});
	}

	_emptyGridMessage() {
		return '<div class="text-align-center">' + this.cvLoc('label.noDataAvailable') + '</div>';
	}

	_fetchData(options) {
		let self = this;
		this.fileAnomalyService
			.getFileAnomalyClientList()
			.success(function(anomalyClientListResp) {
				let data = [];
				let fileAnomalyClientList = anomalyClientListResp ? anomalyClientListResp.anomalyClients : [];
				if (fileAnomalyClientList) {
					for (var i = 0; i < fileAnomalyClientList.length; i++) {
						let client = {
							clientName: fileAnomalyClientList[i].client.clientName,
							clientId: fileAnomalyClientList[i].client.clientId,
							displayName: fileAnomalyClientList[i].client.displayName,
							isVMeSupported: fileAnomalyClientList[i].isVMeSupported,
							osInfo: fileAnomalyClientList[i].osInfo.osInfo,
							appType:
								_.get(fileAnomalyClientList[i], 'osInfo.osInfo.osId', 0) > 0
									? self.clientFactory.isWindowsOS(_.get(fileAnomalyClientList[i], 'osInfo.osInfo.osId', 0))
										? self.AppTypes.WINDOWS_FILESYSTEM
										: self.AppTypes.UNIX_FILESYSTEM
									: self.AppTypes.WINDOWS_FILESYSTEM,
							detectedTime: fileAnomalyClientList[i].refTime
						};
						let fileAnomalyInfo = {
							clientName: client.clientName,
							clientId: client.clientId,
							displayName: client.displayName,
							anomalyType: self.fileAnomalyFactory.getFileAnomalyType(fileAnomalyClientList[i].anomalyType),
							createdFiles: fileAnomalyClientList[i].createCount,
							renamedFiles: fileAnomalyClientList[i].renameCount,
							deletedFiles: fileAnomalyClientList[i].deleteCount,
							modifiedFiles: fileAnomalyClientList[i].modCount,
							formattedDetectedTime: self.$filter('customDateTime')(fileAnomalyClientList[i].refTime),
							isVMeSupported: client.isVMeSupported,
							osInfo: client.osInfo
						};
						fileAnomalyInfo.permittedOptions = {
							entityId: client.clientId,
							appendToBody: true,
							permittedActionList: self._computePermittedActions(client)
						};

						data.push(fileAnomalyInfo);
					}
				}
				return options.success(data);
			})
			.error(function(e) {
				return options.error(e);
			});
	}

	_computePermittedActions(client) {
		let permittedActionsForClient = [
			{
				show: this._showRecoverAsVMOption(client),
				value: this.ANOMALY_ACTIONS.RECOVER_AS_VM,
				label: this.cvLoc('label.recoverAsVM'),
				onClick: () => {
					this._recoverAsVM(client);
				}
			},
			{
				show: capabilities.hasAgentManagementCapability,
				value: this.ANOMALY_ACTIONS.CLEAR_ANOMALY,
				label: this.cvLoc('label.clearAnomaly'),
				onClick: () => {
					this._clearAnomaly(client);
				}
			}
		];
		return permittedActionsForClient;
	}

	_onGridDataBound(dataItem, row) {
		const permittedOptions = dataItem.permittedOptions;
		const id = permittedOptions.entityId;
		const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
		this.$scope[`permittedOptions${id}`] = permittedOptions;
		row.find('.permittedActions').append(this.$compile(template)(this.$scope));
	}

	_onSelectionChange(e) {
		[this.ANOMALY_ACTIONS.CLEAR_ANOMALY].forEach(item => {
			if (e.values.length > 0 && capabilities.hasAgentManagementCapability) {
				this.grid.enableActionMenuOption(item);
			} else {
				this.grid.disableActionMenuOption(item);
			}
		});
	}

	_getRecoveryTargets() {
		let self = this;
		let vmPolicyAppType = this.POLICY_APP_TYPE.REGULAR; // Regular life cycle policy app type.

		return this.restoreService.getLifeCyclePolicies(vmPolicyAppType, true, true).then(
			function(data) {
				if (data.data && data.data.length) {
					self.recoveryTargets = data.data;
					self.grid.refreshData();
				}
			},
			function(e) {
				// No error needs to be raised, the check is whether virtualization targets are populated or not.
			}
		);
	}

	_showRecoverAsVMOption(client) {
		return (
			/*client.isVMeSupported &&*/ // TODO: Un-comment when requested to honor even the stored proc checks.
			capabilities.hasAgentManagementCapability && this.recoveryTargets && this.recoveryTargets.length > 0
		);
	}
}

FileAnomalyController.$inject = [
	'cvLoc',
	'cvToaster',
	'$compile',
	'$filter',
	'$scope',
	'$state',
	'$uibModal',
	'$dialogs',
	'fileAnomalyService',
	'restoreService',
	'agentService',
	'AppTypes',
	'POLICY_APP_TYPE',
	'VSA_VENDOR',
	'ANOMALY',
	'ANOMALY_ACTIONS',
	'fileAnomalyFactory',
	'clientFactory'
];
app.controller('fileAnomalyController', FileAnomalyController);

export default app;
