import DateTimeDropdown from 'common/js/datetimedropdown';

const getClientName = cvLoc => ({
	clientName: {
		title: cvLoc('header.clientName'),
		type: 'string',
		width: '12%',
		template: getClientNameTemplate()
	}
});

const getAnomalyType = cvLoc => ({
	anomalyType: {
		title: cvLoc('header.anomalyType'),
		type: 'string',
		width: '16%',
		template: getAnomalyTypeTemplate()
	}
});

const getCreatedFiles = cvLoc => ({
	createdFiles: {
		title: cvLoc('header.createdFiles'),
		type: 'number',
		width: '10%',
		template: getCreatedFilesTemplate(),
		filterType: false
	}
});

const getRenamedFiles = cvLoc => ({
	renamedFiles: {
		title: cvLoc('header.renamedFiles'),
		type: 'number',
		width: '10%',
		template: getRenamedFilesTemplate(),
		filterType: false
	}
});

const getDeletedFiles = cvLoc => ({
	deletedFiles: {
		title: cvLoc('header.deletedFiles'),
		type: 'number',
		width: '10%',
		template: getDeletedFilesTemplate(),
		filterType: false
	}
});

const getModifiedFiles = cvLoc => ({
	modifiedFiles: {
		title: cvLoc('header.modifiedFiles'),
		type: 'number',
		width: '10%',
		template: getModifiedFilesTemplate(),
		filterType: false
	}
});

const getDetectedTime = cvLoc => ({
	detectedTime: {
		title: cvLoc('header.detectedTime'),
		type: 'number',
		width: '16%',
		template: getDetectedTimeTemplate(),
		filterType: 'datetimedropdown',
		data: [...DateTimeDropdown.getDefaultData(cvLoc)],
		searchable: false
	}
});

const getActionsColumn = cvLoc => ({
	action: {
		title: cvLoc('header.Actions'),
		type: 'string',
		template: getActionsTemplate(),
		disableViewFiltering: true,
		sortable: false,
		disableColumnFilter: true,
		searchable: false,
		allowHiding: false,
		excludeFromExport: true,
		width: '8%',
		attributes: {
			class: 'permitted-actions'
		}
	}
});

const getFolderPath = (cvLoc, isBackupAnomaly) => ({
	folderPath: {
		title: cvLoc('header.folderPath'),
		type: 'string',
		width: isBackupAnomaly ? '45%' : '30%',
		template: getFolderPathTemplate()
	}
});

const getJobId = cvLoc => ({
	jobId: {
		title: cvLoc('header.jobId'),
		type: 'number',
		width: '10%',
		template: getJobIdTemplate()
	}
});

export const getfileAnomalyColumnTemplate = ({ cvLoc }) => ({
	...getClientName(cvLoc),
	...getAnomalyType(cvLoc),
	...getCreatedFiles(cvLoc),
	...getRenamedFiles(cvLoc),
	...getDeletedFiles(cvLoc),
	...getModifiedFiles(cvLoc),
	...getDetectedTime(cvLoc),
	...getActionsColumn(cvLoc)
});

export const getFileAnomalyLiveFolderBrowseTemplate = ({ cvLoc }) => ({
	...getFolderPath(cvLoc, false),
	...getCreatedFiles(cvLoc),
	...getRenamedFiles(cvLoc),
	...getDeletedFiles(cvLoc),
	...getModifiedFiles(cvLoc),
	...getDetectedTime(cvLoc),
	...getActionsColumn(cvLoc)
});

export const getFileAnomalyBackupFolderBrowseTemplate = ({ cvLoc }) => ({
	...getFolderPath(cvLoc, true),
	...getJobId(cvLoc),
	...getDetectedTime(cvLoc),
	...getActionsColumn(cvLoc)
});

const getClientNameTemplate = () =>
	`<div>
	<a uib-tooltip="#:displayName#" 
	tooltip-append-to-body="true" 
	tooltip-placement="bottom" 
	href="\\#/fileAnomaly/#:clientId#/?clientName=#:clientName#">#:displayName#</a>
</div>`;

const getAnomalyTypeTemplate = () => `<div>#:anomalyType#</div>`;

const getCreatedFilesTemplate = () => `<div>#:createdFiles#</div>`;

const getRenamedFilesTemplate = () => `<div>#:renamedFiles#</div>`;

const getDeletedFilesTemplate = () => `<div>#:deletedFiles#</div>`;

const getModifiedFilesTemplate = () => `<div>#:modifiedFiles#</div>`;

const getDetectedTimeTemplate = () => `<div>#:formattedDetectedTime#</div>`;

const getActionsTemplate = () => `<div class="permittedActions"></div>`;

const getFolderPathTemplate = () => `<div>#:folderPath#</div>`;

const getJobIdTemplate = () => `<div>#:jobId#</div>`;
