<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<script type="text/ng-template"  id="tree_item_renderer.html">
		<div data-ng-class="{'selected': item.selectedState==='selected', 'partial': item.selectedState==='partial'}" >
			<button id="browseCollectionContent_button_#0354" type="button" data-ng-class="item.state | lowercase" data-ng-click="itemDrilledDown(item)"></button> 
			<span data-ng-click="toggleSelectedState(item)" data-ng-disabled="item.disabled"><span class="vsaIconLOADING {{item.iconName}}">&nbsp;</span>{{item.displayName}}</span>
		</div>
    	<div class="children" data-ng-class="item.state">
	        <div class="browse-item" data-ng-repeat="item in item.children | filter: {hidden: '!true'}" data-ng-include="'tree_item_renderer.html'"></div>
	    </div>
	</script>
	<!-- <span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span> -->
	<div class="multiSelectVMs">
		<span class="help-block set-to-left margin-top-20-minus" data-ng-show="showContentWarning()"><fmt:message key="error.noItemSelected" />		</span>
			<div class="browseAndSelectVM">
				<div class="form-group">
					<div data-ng-if="enableShowSelected" class="float-left margin-left-0">
						<input id="showSelected" name="showSelected" data-ng-model="input.showSelected" data-ng-change="showSelected(treeData.tree)" class="" type="checkbox" />
						<label for="showSelected"><cv:msg key="label.showSelected" bundle="messages" /></label>
					</div>
					<div data-ng-if="showSearchBar" class="search-widget-wrapper search-filter cv-tile-component-filter cv-label">
						<input class="search-field"
								title='<cv:msg key="label.search" bundle="messages" />'
								id="searchFilter"
								type="text"
								placeholder='<cv:msg key="label.search" bundle="messages" />'
								data-ng-model="input.searchText"
								data-ng-change="search(treeData.tree)" />
						<span data-ng-click="clearSearch()" class="form-control-clear glyphicon glyphicon-remove form-control-feedback" title="Clear"></span>
					</div>
				</div>
				<div class="browse-tree alerts-browse" style="clear: both;">
					<div data-ng-hide="singleSelectionMode" class="select-all-wrapper">
						<a ng-show="browseResp" class="group select-clear-all" ng-click='clearAll()'><fmt:message key="label.clearAll" /></a>
						<a ng-show="browseResp" class="group select-clear-all" ng-click='selectAll()'><fmt:message key="label.selectAll" /></a>
					</div>
			    	<div  data-ng-repeat="item in treeData.tree.children | filter: {hidden: '!true'}" class="browse-item" data-ng-include="'tree_item_renderer.html'"></div>
				</div>
 			</div>
	</div>
</fmt:bundle>