<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div >
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.alertsJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
		<cv:cvMessages bundle="localization.emailTemplate"></cv:cvMessages>
		<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	</script>
	<script type="text/ng-template"  id="tree_item_renderer.html">
		<div ng-class="{'selected': item.selectedState==='selected', 'partial': item.selectedState==='partial'}" >
			<button id="alertDetails_button_#7323" type="button" ng-class="item.state | lowercase" ng-click="itemDrilledDown(item)"></button> 
			<span ng-click="toggleSelectedState(item)"><label>{{item.label}}</span>
		</div>
    	<div class="children" ng-class="item.state">
	        <div class="browse-item" ng-repeat="item in item.children" ng-include="'tree_item_renderer.html'"></div>
	    </div>
	</script>
	<fmt:bundle basename="localization.alerts">
		<div class="row">
			<div class="col-md-12">
				<span><cv-changename obj="changeNameObj" service-method="renameAlert.do" class="float-left"></cv-changename></span>
				<span data-ng-show="alertDetail">
					<a href="" class="page-action-item" data-ng-click="deleteAlert()"><cv:msg key="Delete" bundle="messages" /></a>
					<a href="" class="page-action-item" data-ng-click="editTemplate()"> <fmt:message key='label.editTemplate' /></a>
					<a href=""  ng-class="{'disabled': disableLink}" class="page-action-item" data-ng-click="enableDisableAlert()"> {{enableLabel}}</a>
				</span>
			</div>
		</div>
		<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
		<div class="row">
			<div class="col-md-6">
				<cv-tile-component data-title='<fmt:message key="heading.alertSummary" />' data-ac-id="alertDetails-heading.alertSummary-alerts">
					<ul class="list-style-secondary">
						<li class="group">
							<span class="pageDetailColumn"><fmt:message key="label.alertType" /></span>
							<span class="pageDetailColumn">{{alertInfo.alert.alertType.name}}</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><fmt:message key="label.alertCategory" /></span>
							<span class="pageDetailColumn">{{alertInfo.alert.alertCategory.name}}</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><fmt:message key="label.alertCriteria" /></span>
							<span class="pageDetailColumn">{{alertDetail.criteriaName}}</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><fmt:message key="label.alertNotifIndividualEdit" /></span>
							<span class="pageDetailColumn pull-right">
								<toggle-control status="alertNotifIndividual ? 'enabled-activity' : 'disabled-activity'" data-ng-click="toggleAlertNotifIndividual()" 
												title="Enable/Disable <fmt:message key='label.notificationTypes' />"></toggle-control>	
							</span>
						</li>
					</ul>
				</cv-tile-component>
				<div data-ng-if="alertDetail.isEntityTypeClient">
					<cv-tile-component data-title='<fmt:message key="heading.entities" />' data-ac-id="alertDetails-heading.entities-alerts">
						<div class="page-details-box-links"><a ng-click="openEntitiesEditModal()"><fmt:message key="label.edit" /></a></div>
						<div>
							<h4 class="margin-top-15 margin-bottom-5"><fmt:message key="label.clientGroups" /></h4>
							<span class="line-height-1-point-8">{{serverGroupsList.join(', ')}}</span>
						</div>
						<div>
							<h4 class="margin-top-15 margin-bottom-5"><fmt:message key="label.clients" /></h4>
							<span class="line-height-1-point-8">{{serversList.join(', ')}}</span>
						</div>
						<span class="server-message {{noEntityListMessage.type}}">{{noEntityListMessage.message}}</span>
					</cv-tile-component>
				</div>
			</div>
			<div class="col-md-6">
				<div class="edit-alert-target-tile">
					<cv-tile-component data-title='<fmt:message key="label.alertTarget" />' data-ac-id="alertDetails-label.alertTarget-alerts">
						<div class="page-details-box-links"><a ng-click="openTargetEditModal()"><fmt:message key="label.edit" /></a></div>
						<ul class="list-style-secondary">
							<li class="group"><span class="pageDetailColumn"><fmt:message key="label.sendAlertTo" /></span>
								<span class="pageDetailColumn">{{notifTypeList.join(', ')}}</span>
							</li>
						</ul>
						<div data-ng-show="notifTypeSelection.email || notifTypeSelection.console">
							<h5 class="margin-top-20"><fmt:message key="label.recipients" /></h5>
							<cv-tabset-component element="cvtile" default-tab="defaultTab" control="tabControls" data-ng-class="disabledClass.className">
								<cv-tab tabname="{{allUsers.label}}" data-ng-repeat="allUsers in allUsersList">
									<div class="padding-top-10" data-ng-show="!allUsers.showProperty">
										<span class="pageDetailColumn"><fmt:message key="label.noRecipientSelected" /></span>
									</div>
									<div data-ng-show="allUsers.showProperty">
										<ul class="list-style-secondary list-overflow-scroll">
											<li class="group" data-ng-repeat="user in allUsers.userList track by $index" title="user.name">
												<span class="pageDetailColumn user-type userGroupColumn ellipsis-parent ellipsis-content"><label data-id="{{user.id}}">{{user.name}}</label></span>
												<span class="pageDetailColumn ellipsis-parent ellipsis-content"><fmt:message key="userType.user" /></span>
											</li>
											<li class="group" data-ng-repeat="group in allUsers.userGroupList track by $index" title="group.name">
												<span class="pageDetailColumn group-type userGroupColumn ellipsis-parent ellipsis-content"><label data-id="{{group.id}}">{{group.name}}</label></span>
												<span class="pageDetailColumn ellipsis-parent ellipsis-content"><fmt:message key="userType.group" /></span>
											</li>
											<li class="group" data-ng-repeat="ngroup in allUsers.nonGalaxyUserList track by $index" title="ngroup.name">
												<span class="pageDetailColumn email-type userGroupColumn ellipsis-parent ellipsis-content"><label data-id="{{ngroup.id}}">{{ngroup.name}}</label></span>
												<span class="pageDetailColumn ellipsis-parent ellipsis-content"><fmt:message key="userType.ngroup" /></span>
											</li>
											<li class="group" data-ng-repeat="egroup in allUsers.externalGroupList track by $index" title="egroup.name">
												<span class="pageDetailColumn group-type userGroupColumn ellipsis-parent ellipsis-content"><label data-id="{{ngroup.id}}">{{egroup.name}}</label></span>
												<span class="pageDetailColumn ellipsis-parent ellipsis-content"><fmt:message key="userType.egroup" /></span>
											</li>
										</ul>
									</div>
								</cv-tab>
							</cv-tabset-component>
						</div>
					</cv-tile-component>
				</div>
			</div>
		</div>
	</fmt:bundle>
</div>