<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.alertsJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
    <cv:cvMessages bundle="localization.emailTemplate"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<form name="alertTemplate">
<div class="setup-title try" data-ng-show="isEditMode">
    <h3><cv:msg key="label.editTemplate" bundle="alerts" /></h3>
</div>
<div data-ng-class="isEditMode ? 'setup-content' : ''">
    <div data-ng-show="isEditMode" data-ng-class='{"margin-top-19-minus" : alertTemplateServerMessage.message != ""}'>
        <span class="server-message {{alertTemplateServerMessage.type}}">{{alertTemplateServerMessage.message}}</span>
    </div>
    <div class="form-group padding-top-10 padding-bottom-10">
        <label class="no-margin col-xs-3" for="alertNotifLocale"><cv:msg key="emailTemplates.table.col.locale" bundle="emailTemplate" /></label>
        <div class="margin-bottom-30 col-xs-9">
            <isteven-multi-select
                input-model="locale.alertLocaleList"
                output-model="locale.selectedLocale"
                button-label="displayString"
                item-label="displayString"
                tick-property="selected"
                helper-elements=""
                selection-mode="single"
                id="alertLocale"
                on-item-click="alertLocaleChange()"
                class="isteven-multi-select full-width"
                max-height="250px">
        	</isteven-multi-select>
        </div>
    </div>
	<div class="form-group padding-top-20" data-ng-if="alertNotifTypes[alertNotifObject.email.index].selected">
        <label class="no-margin col-xs-3" for="alertNotifEmailSub"><cv:msg key="label.alertNotifEmailSub" bundle="alerts" /></label>
        <div class="margin-bottom-30 col-xs-9">
            <input type="text" id="alertNotifEmailSub" class="full-width" data-ng-model="model.emailSubject.message"/>
        </div>
    </div>

    <div class="form-group padding-top-20">
        <div class="col-xs-12 margin-bottom-30 html-text-template-editor">
            <div class="template-switch-section">
                <button id="addAlertStepTemplate_button_#6286" type="button" data-ng-class="{'active-btn': alerts.email.isActive}" data-ng-click="viewTemplate('email')" class="btn btn-default float-left"
                data-ng-if="alertNotifTypes[alertNotifObject.email.index].selected"><cv:msg key="label.alertNotifTypeEmail" bundle="alerts" /></button>                
            <!-- Console -->
            <button id="addAlertStepTemplate_button_#62866" type="button" data-ng-class="{'active-btn':  alerts.console.isActive}" data-ng-click="viewTemplate('console')" class="btn btn-default float-left"
                data-ng-if="alertNotifTypes[alertNotifObject.console.index].selected"><cv:msg key="label.alertNotifTypeCA" bundle="alerts" /></button>
            <!--Event viewer-->
            <button id="addAlertStepTemplate_button_#62867" type="button" data-ng-class="{'active-btn': alerts.eventViewer.isActive}" data-ng-click="viewTemplate('eventViewer')" class="btn btn-default float-left"
                data-ng-if="alertNotifTypes[alertNotifObject.ev.index].selected"><cv:msg key="label.alertNotifTypeEV" bundle="alerts" /></button>
            <!--Token Dropdown -->
            <div class="dropdown padding-top-7 float-right" data-ng-show="alerts.eventViewer.isActive || (!isConsoleTemplHTML && alerts.console.isActive)">
                    <div class="uib-dropdown dropdown" uib-dropdown>
                        <a class="uib-dropdown-toggle" uib-dropdown-toggle>
                        <span><cv:msg key="editor.tokens" bundle="messages"/></span>
                        <span class="k-icon k-i-arrow-60-down"></span></a>
                        <ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2 margin-top-0">
                            <li data-ng-repeat="token in tokens track by $index"><a ng-click="tokenSelected(token.tokenFormat)" data-ng-bind="token.tokenFormat"></a></li>
                        </ul>
                </div>
            </div>
            </div>
            <div data-ng-show="!hideKendoEditor">
                <div class="cv-editor" id="cv-editor" ></div>
            </div>
            <div data-ng-show="alerts.eventViewer.isActive" class="text-template-editor">
                <textarea cv-alert-text class="cv-editor margin-top-0 full-width" name="evInputTxt" rows="15" cols="90" listen-on="{{listeners.ev}}" data-ng-model="alerts.eventViewer.template"></textarea>
            </div>
            <div data-ng-show="!isConsoleTemplHTML && alerts.console.isActive" class="text-template-editor">
                <textarea cv-alert-text class="cv-editor margin-top-0 full-width" name="consoleInputTxt" rows="15" cols="90" listen-on="{{listeners.console}}" data-ng-model="alerts.console.template"></textarea>
            </div>
        </div>
    </div>
    <div class="button-container" data-ng-show="isEditMode">
        <button id="addAlertStepTemplate_button_#8115" class="btn btn-default cvBusyOnAjax" data-ng-click="cancelTemplateModal()" ><cv:msg key="label.cancel" bundle="alerts" /></button>
        <button id="addAlertStepTemplate_button_#7072" class="btn btn-primary cvBusyOnAjax" data-ng-click="submitTemplateModal()" ><cv:msg key="label.save" bundle="alerts" /></button>
    </div>
</div>
    </form>
