<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.alertsJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
    <cv:cvMessages bundle="localization.emailTemplate"></cv:cvMessages>
</script>
<div class="setup-title" data-ng-show="isEditMode">
    <h3><cv:msg key="label.editAlertTarget" bundle="alerts" /></h3>
</div>
    
<div data-ng-class="{ 'setup-content': isEditMode || isWizard, 'margin-top-20': isEditMode, 'margin-auto': isWizard }">
	<div data-ng-show="isEditMode" data-ng-class='{"margin-top-19-minus" : serverMessage.message != ""}'>
		<span class="server-message no-margin no-padding {{alertTargetServerMessage.type}}">{{alertTargetServerMessage.message}}</span>
	</div>
	<div class="col-xs-12 margin-top-19-minus error-fixed-height-20">
        <span class="margin-left-20 float-left server-message no-margin no-padding error">{{alertNotifTypesError.error.message}}</span>
    </div>
    <div class="col-xs-12">
        <label class="cv-label no-margin"><cv:msg key="label.sendAlertTo" bundle="alerts" /></label>
    </div>
    <div class="col-xs-12">
        <div class="col-md-6 no-padding" data-ng-repeat="alertNotifType in alertNotifTypes track by $index">
            <input type="checkbox" data-ng-disabled="alertNotifType.disableProp" data-ng-model="alertNotifType.selected" id="{{alertNotifType.id}}" data-ng-click="isAlertNotifError()"> 	
            <label for="{{alertNotifType.id}}" class="no-margin">{{alertNotifType.name}}
            	<cv-help-component data-ng-show="alertNotifType.showHelpText && !isEditMode" data-help-text="<cv:msg key='label.consoleHelpText' bundle='alerts' />" data-help-placement="bottom"></cv-help-component>
            </label>
        </div>
    </div>
    <div class="col-xs-12 no-padding padding-top-20 padding-left-15" data-ng-show="alertNotifTypes[alertNotifObject.email.index].selected || alertNotifTypes[alertNotifObject.console.index].selected">
        <h4 class="col-xs-12 float-left text-left padding-bottom-10 padding-top-20"><cv:msg key="label.recipients" bundle="alerts" /></h4>
        <div class="col-xs-12 padding-bottom-20 add-users group plan-usergroup-invite left-align-select2">
            <label for="toUserList" class="no-margin no-padding col-xs-12"><cv:msg key="label.toUser" bundle="alerts"/>
                <input id="toUserList" name="toUserList" class="alert-add-user-input">
            </label>
            <div id="toEmailErrorMessage" class="col-xs-12 invite-error-message error serverMessage">
                <cv:msg key="error.validEmailError" bundle="alertsJs"/>
            </div>
        </div>
        
        <div class="col-xs-12 padding-bottom-20 add-users group plan-usergroup-invite left-align-select2" data-ng-show="alertNotifTypes[alertNotifObject.email.index].selected">
            <label for="ccUserList" class="no-margin no-padding col-xs-12"><cv:msg key="emailTemplates.label.cc" bundle="emailTemplate"/>
                <input id="ccUserList" name="ccUserList" class="alert-add-user-input">
            </label>
            <div id="ccEmailErrorMessage" class="col-xs-12 invite-error-message error serverMessage">
                <cv:msg key="error.validEmailError" bundle="alertsJs"/>
            </div>
        </div>
        
        <div class="col-xs-12 padding-bottom-20 add-users group plan-usergroup-invite left-align-select2" data-ng-show="alertNotifTypes[alertNotifObject.email.index].selected">
            <label for="bccUserList" class="no-margin no-padding col-xs-12"><cv:msg key="emailTemplates.label.bcc" bundle="emailTemplate"/>
                <input id="bccUserList" name="bccUserList" class="alert-add-user-input">
            </label>
            <div id="bccEmailErrorMessage" class="col-xs-12 invite-error-message error serverMessage">
                <cv:msg key="error.validEmailError" bundle="alertsJs"/>
            </div>
        </div>
    </div>
    <div class="button-container" data-ng-show="isEditMode">
        <button id="addAlertStepTarget_button_#9252" class="btn btn-default cvBusyOnAjax" data-ng-click="cancelUsersModal()" ><cv:msg key="label.cancel" bundle="alerts" /></button> 
        <button id="addAlertStepTarget_button_#8679" class="btn btn-primary cvBusyOnAjax" data-ng-click="submitUsersModal()" ><cv:msg key="label.save" bundle="alerts" /></button> 
    </div>
</div>