import { cvModuleAlertsModule } from 'common/js/modules';

var alertsMod = cvModuleAlertsModule;

alertsMod.service('definitionsService', [
	'$http',
	function($http) {
		this.getAlerts = function(alertInfo) {
			return $http.get('alertsDefinitions.do', {
				// passing hardcoded values for now as server always sends entire data
				params: {
					pageSize: 15,
					pageNumber: 1
				}
			});
		};

		this.enableDisableAlert = function(alertInfo) {
			return $http.get('enableAlertRule.do', {
				params: {
					alertId: alertInfo.alertId,
					doEnable: alertInfo.doEnable
				}
			});
		};

		this.deleteAlertRule = function(alertId) {
			return $http['delete']('deleteAlertRule.do', {
				params: {
					alertId: alertId
				}
			});
		};

		this.getSubscriptionBasedAlerts = function() {
			return $http.get('getSubscriptionBasedAlerts.do');
		};

		this.getAlertsCriteriaList = function(alertInfo) {
			return $http.get('getAlertsCriteriaList.do', { cache: true });
		};

		this.getDefaultTemplateAndTokenList = function(alertTypeId, alertCriteriaId, localeId) {
			return $http.get('getDefaultTemplateAndTokenList.do', {
				params: {
					alertTypeId: alertTypeId,
					alertCriteriaId: alertCriteriaId,
					localeId: localeId
				},
				cache: true
			});
		};

		this.getEntityList = function(alertTypeId, isVM) {
			return $http.get('getEntityList.do', {
				params: {
					alertType: alertTypeId,
					isVM: isVM || false
				}
			});
		};

		this.createAlertDefinition = function(alertDef) {
			return $http.post('createAlertDef.do', {
				alertDetail: JSON.stringify(alertDef)
			});
		};
	}
]);

alertsMod.service('triggeredAlertsService', [
	'$http',
	'cvLoc',
	function($http, cvLoc) {
		this.getSeverityText = severity => {
			switch (severity) {
				case 1:
					return cvLoc('label.critical');
				case 2:
					return cvLoc('label.major');
				case 3:
					return cvLoc('label.information');
				default:
					return cvLoc('label.noDataAvailable');
			}
		};

		this.getSeverityClass = severity => {
			switch (severity) {
				case 1:
					return 'critical';
				case 2:
					return 'major';
				case 3:
					return 'info';
			}
		};

		this.getAlerts = function(alertInfo, ignoreLoadingBar) {
			return $http.get('triggeredAlerts.do', {
				params: {
					pageSize: alertInfo.pageSize,
					pageNumber: alertInfo.pageNumber
				},
				ignoreLoadingBar: ignoreLoadingBar
			});
		};

		this.getAlertDescription = function(alertInfo) {
			let headers = {};
			if (alertInfo.commcellName) {
				headers = {
					_cn: alertInfo.commcellName
				};
			}
			return $http.get('triggeredAlertDescription.do', {
				params: {
					alertId: alertInfo.alertId
				},
				headers
			});
		};

		this.pinAlert = function(pinInfo) {
			const headers = {};
			if (pinInfo.commcellName) {
				headers._cn = pinInfo.commcellName;
			}
			return $http.get('pinAlert.do', {
				params: {
					liveFeedId: pinInfo.liveFeedId,
					status: pinInfo.status,
					doPin: pinInfo.doPin
				},
				headers
			});
		};

		this.deleteAlert = function(selectedRowValues) {
			const commcellEvents = _.groupBy(selectedRowValues, 'client.commCellName');
			const promises = [];
			_.forEach(commcellEvents, (events, commcellName) => {
				let headers = {};
				const params = {
					liveFeedIds: JSON.stringify(_.map(events, 'liveFeedId'))
				};
				if (commcellName && commcellName !== 'undefined') {
					headers = {
						_cn: commcellName
					};
				}
				promises.push(
					$http.get('deleteTriggeredAlert.do', {
						params,
						headers
					})
				);
			});
			return Promise.all(promises);
		};

		this.parseAlertContent = alertContent => {
			try {
				alertContent = alertContent.replace(/\\u0022/g, '');
				alertContent = decodeURIComponent(
					alertContent.replace(/href="(.*?)"/g, function(m, mTxt) {
						return 'href=\\"' + encodeURIComponent(mTxt) + '\\"';
					})
				);
				return JSON.parse(alertContent);
			} catch (e) {
				return null;
			}
		};

		this.getTransformedAlertContent = (alert, severity) => {
			try {
				const alertProps = {
					Severity: `<span class="${this.getSeverityClass(severity)}">${this.getSeverityText(severity)}</span>`,
					...alert
				};
				return `
				<section>
					${Object.keys(alertProps)
						.map(
							alertProp => `
							<div class="cv-flex margin-top-15 margin-bottom-15">
								<div class="flex-1 break-all-text darkgrey-font">${alertProp}</div>
								<div class="flex-2 break-all-text">${alertProps[alertProp]}</div>
							</div>`
						)
						.join('')}
				</section>
			`;
			} catch (e) {
				console.error(e);
			}
			return '';
		};
	}
]);

alertsMod.service('alertDetailsService', [
	'$http',
	function($http) {
		this.getExistingAlertInfo = function(alertInfo) {
			return $http.get('getAlertInfo.do', {
				params: {
					alertId: alertInfo.alertId
				}
			});
		};

		this.getUserSuggestionsList = function(useSuggestionInput) {
			return $http.get('getUserSuggestionsList.do', {
				params: {
					textString: useSuggestionInput.textString
				}
			});
		};

		this.getUserSuggestionList = function() {
			return $http.get('getUserSuggestionList.do');
		};

		this.getVMList = function(browseType, id) {
			var url1 = '';
			if (browseType == '\\') {
				url1 = 'servers.do';
			} else if (browseType == 'VMW') {
				url1 = 'subclients.do?appId=106&serverId=' + id;
			}
			return $http({
				method: 'GET',
				url: url1,
				type: browseType
			});
		};

		this.updateIndividualNotifStatus = function(alertId, isIndividualNotifAllowed) {
			return $http.post('updateIndividualNotifStatus.do', {
				alertId: alertId,
				isIndividualNotifAllowed: isIndividualNotifAllowed
			});
		};

		this.updateAlertTarget = function(alertDef) {
			return $http.post('updateAlertTarget.do', {
				alertDetail: JSON.stringify(alertDef)
			});
		};

		this.updateAlertTemplate = function(alertDef) {
			return $http.post('updateAlertTemplate.do', {
				alertDetail: JSON.stringify(alertDef)
			});
		};

		this.updateAlertEntities = function(alertDef) {
			return $http.post('updateAlertEntities.do', {
				alertDetail: JSON.stringify(alertDef)
			});
		};

		var usersList = [];

		this.setUsersList = function(newUsersList) {
			usersList = angular.copy(newUsersList);
		};
		this.getUsersList = function() {
			return usersList;
		};

		this.getTemplate = function() {
			return $http.get(appUtil.appRoot + 'common/partials/editor.jsp');
		};
	}
]);
alertsMod.service('alertNotesService', [
	'$http',
	function($http) {
		this.fAlertNotesOperations = function(notes) {
			const headers = httpHeader.jsonDefaultHeader.headers;
			if (_.has(notes, 'updateFeedsList[0].commcellName')) {
				headers._cn = _.get(notes, 'updateFeedsList[0].commcellName');
			}
			if (notes && notes.updateFeedsList.length) {
				return $http({
					method: 'POST',
					url: cv.contextPath + '/api/Alert/' + notes['updateFeedsList'][0]['liveFeedId'],
					data: JSON.stringify(notes),
					headers
				});
			}
		};
	}
]);
export default alertsMod;
