import { cvModuleAlertsModule } from 'common/js/modules';

import Editor from '../../../../common/js/directives/editor.js';
import * as uploadImage from '../../../../common/js/directives/editor-uploadImage.js';
import * as tokens from '../../../../common/js/directives/editor-tokens.js';

let alertUIFactoryFunction = [
	'cvLoc',
	'cvUtil',
	'definitionsService',
	'alertDetailsService',
	'REGEX',
	'$dialogs',
	function(cvLoc, cvUtil, definitionsService, alertDetailsService, REGEX, $dialogs) {
		function setEntityTypeById(entityId, entity, id) {
			switch (
				entityId // set the appropriate ID based on the item selected in the tree
			) {
				case '7':
					entity.subclientId = id;
					break;
				case '6':
					entity.backupsetId = id;
					break;
				case '5':
					entity.instanceId = id;
					break;
				case '4':
					entity.applicationId = id;
					break;
				case '3':
					entity.clientId = id;
					break;
				case '28':
					entity.clientGroupId = id;
			}
		}

		function setParentEntityProps(entity, item) {
			item = item.parent;
			if (item) {
				setEntityTypeById(item.typeId, entity, item.id);
				setParentEntityProps(entity, item); // call it's parent until it reaches root and set it's Id
			}
		}

		function formEntityAssoc(associations, entityList) {
			entityList.forEach(entityList => {
				var entity = {};
				entity.entityType = entityList.typeId; // this has to be set for the selected item
				setEntityTypeById(entityList.typeId, entity, entityList.id); // set Id into appropriate field based on the type of the item
				setParentEntityProps(entity, entityList); // set parent entity's Id also
				associations.push(entity);
			});
		}

		function containsObject(array, item, field1, field2) {
			for (let i = 0; i < array.length; i++) {
				if (field1 != null && typeof field1 !== 'undefined' && field2 != null && typeof field2 !== 'undefined') {
					if (array[i][field1] === item[field1] && array[i][field2] === item[field2]) {
						return true;
					}
				}
			}
			return false;
		}

		function validateEmail(email) {
			return REGEX.EMAIL.test(email);
		}

		function addToList(newUser, addUsersList, recipientType) {
			if (newUser.type == 'EMAIL' && !validateEmail(newUser.loginName)) {
				return true;
			}
			let usr;
			switch (newUser.type) {
				case 'USER':
					usr = {
						userId: typeof newUser.userInfoId === 'number' ? newUser.userInfoId : 0,
						userName: newUser.loginName
					};
					if (!containsObject(addUsersList.userList, usr, 'userId', 'userName')) {
						addUsersList.userList.push(usr);
					}
					break;
				case 'COMMCELL_GROUP':
					usr = {
						userGroupId: typeof newUser.userInfoId === 'number' ? newUser.userInfoId : 0,
						userGroupName: newUser.loginName
					};
					if (!containsObject(addUsersList.userGroupList, usr, 'userGroupId', 'userGroupName')) {
						addUsersList.userGroupList.push(usr);
					}
					break;
				case 'EXTERNAL_GROUP':
					usr = {
						userGroupId: typeof newUser.userInfoId === 'number' ? newUser.userInfoId : 0,
						userGroupName: newUser.loginName
					};
					if (!containsObject(addUsersList.adUserGroupList, usr, 'userGroupId', 'userGroupName')) {
						addUsersList.adUserGroupList.push(usr);
					}
					break;
				case 'EMAIL':
					usr = {
						nonGalaxyUser: newUser.loginName,
						recipientType: recipientType
					};
					if (!containsObject(addUsersList.nonGalaxyUserList, usr, 'nonGalaxyUser', 'recipientType')) {
						addUsersList.nonGalaxyUserList.push(usr);
					}
					break;
			}
		}

		function addNewUserGroup($selector, recipientType) {
			let addUsersList = {
				userList: [],
				userGroupList: [],
				adUserGroupList: [],
				nonGalaxyUserList: []
			};
			let listedObj = $selector.select2('data');
			for (let i = listedObj.length; i--; ) {
				if (addToList(listedObj[i], addUsersList, recipientType)) {
					console.log('not valid');
				} else {
					listedObj.splice(i, 1);
				}
			}
			return addUsersList;
		}

		function getUsers(alertDef, $selector, recipientType) {
			let usersList = addNewUserGroup($selector, recipientType);

			alertDef.recipientUserList.push({
				userList: usersList.userList,
				recipientType: recipientType
			});

			alertDef.recipientUserGroupList.push({
				userGroupList: usersList.userGroupList,
				recipientType: recipientType
			});

			alertDef.recipientadUserGroupList.push({
				userGroupList: usersList.adUserGroupList,
				recipientType: recipientType
			});

			if (usersList.nonGalaxyUserList.length > 0) {
				alertDef.nonGalaxyList.nonGalaxyUserList = alertDef.nonGalaxyList.nonGalaxyUserList.concat(
					usersList.nonGalaxyUserList
				);
			}
		}

		function format(state, container, query, escapeMarkup) {
			if (state.type === 'USER') {
				return "<span class='user-type plan-user-suggestion'>" + escapeMarkup(state.text) + '</span>';
			} else if (state.type === 'COMMCELL_GROUP' || state.type === 'EXTERNAL_GROUP') {
				return "<span class='group-type plan-user-suggestion'>" + escapeMarkup(state.text) + '</span>';
			} else {
				return "<span class='email-type plan-user-suggestion'>" + escapeMarkup(state.text) + '</span>';
			}
		}
		function formatSel(state, container, escapeMarkup, query) {
			if (state.type === 'USER') {
				return "<span class='user-type plan-user-suggestion'>" + escapeMarkup(state.loginName) + '</span>';
			} else if (state.type === 'COMMCELL_GROUP' || state.type === 'EXTERNAL_GROUP') {
				return "<span class='group-type plan-user-suggestion'>" + escapeMarkup(state.loginName) + '</span>';
			} else {
				return "<span class='email-type plan-user-suggestion'>" + escapeMarkup(state.loginName) + '</span>';
			}
		}

		function initializeAddUser($selector, $errorSelector, alertNotifTypesErrorObj) {
			$selector.select2({
				placeholder: cvLoc('placeholder.enterUserEmail'),
				width: '87%',
				createSearchChoice: function(term, data) {
					if (data.filter(data => data.text.localeCompare(term) === 0).length === 0) {
						return {
							id: term,
							text: term,
							loginName: term,
							userInfoId: term,
							type: 'EMAIL'
						};
					}
				},
				selectOnBlur: true,
				closeOnSelect: false,
				multiple: true,
				minimumInputLength: 0,
				formatResult: format,
				formatSelection: formatSel,
				ajax: {
					url: 'getUserSuggestionsListPlan.do',
					dataType: 'json',
					type: 'GET',
					quietMillis: 50,
					data: function(term) {
						return {
							term: term
						};
					},
					transport: function(params) {
						params.beforeSend = function(request) {
							request.setRequestHeader('csrf', cvUtil.readCookie('csrf'));
						};
						return $.ajax(params);
					},
					results: function(data) {
						return {
							results: $.map(data, function(item) {
								return {
									text: item.name + ' (' + item.loginName + ')',
									loginName: item.loginName,
									id: item.loginName,
									userInfoId: item.userInfo.id,
									type: item.userInfo.userType
								};
							})
						};
					}
				}
			});

			$selector.on('select2-selecting', function(e) {
				if (e.object.type == 'EMAIL' && !validateEmail(e.object.loginName)) {
					$errorSelector.show();
					let currObj = $selector.select2('data');
					$selector.select2('data', null);
					setTimeout(function() {
						$selector.select2('data', currObj);
					}, 1);
				} else {
					$errorSelector.hide();
				}
				alertNotifTypesErrorObj.error = cvUtil.emptyMsg();
			});
			$errorSelector.hide();
		}

		function initializeAddUserSelect(alertNotifTypesErrorObj) {
			initializeAddUser($('#toUserList'), $('#toEmailErrorMessage'), alertNotifTypesErrorObj);
			initializeAddUser($('#ccUserList'), $('#ccEmailErrorMessage'), alertNotifTypesErrorObj);
			initializeAddUser($('#bccUserList'), $('#bccEmailErrorMessage'), alertNotifTypesErrorObj);
		}

		function getAlertNotifObject() {
			return {
				email: { index: 0, value: 'EMAIL', label: cvLoc('userType.ngroup') },
				ev: { index: 1, value: 'APPLOG', label: cvLoc('label.alertNotifTypeEV') },
				console: { index: 2, value: 'LIVEFEEDS', label: cvLoc('label.alertNotifTypeCA') },
				snmp: { index: 3, value: 'SNMP', label: cvLoc('label.alertNotifTypeSNMP') }
			};
		}

		function getSelectedNotifTypes(alertNotifTypes) {
			let selectedNotifTypes = [],
				alertNotifObject = getAlertNotifObject(),
				bitConstants = getBitConstants(),
				notifTypeNumber = 0;

			if (alertNotifTypes[alertNotifObject.email.index].selected) {
				selectedNotifTypes.push(alertNotifObject.email.value);
				notifTypeNumber |= bitConstants.notifType.email;
			}
			if (alertNotifTypes[alertNotifObject.console.index].selected) {
				selectedNotifTypes.push(alertNotifObject.console.value);
				notifTypeNumber |= bitConstants.notifType.console;
			}
			if (alertNotifTypes[alertNotifObject.ev.index].selected) {
				selectedNotifTypes.push(alertNotifObject.ev.value);
				notifTypeNumber |= bitConstants.notifType.ev;
			}
			if (alertNotifTypes[alertNotifObject.snmp.index].selected) {
				selectedNotifTypes.push(alertNotifObject.snmp.value);
				notifTypeNumber |= bitConstants.notifType.snmp;
			}
			return {
				selectedNotifTypes: selectedNotifTypes,
				notifTypeNumber: notifTypeNumber
			};
		}

		function getNotifType(label, id, showHelpText) {
			return {
				name: label,
				id: id,
				selected: false,
				disableProp: false,
				showHelpText: showHelpText
			};
		}
		function getAlertNotifTypes() {
			let alertNotifObject = getAlertNotifObject(),
				alertTypes = [];

			alertTypes.push(getNotifType(alertNotifObject.email.label, 'alertNotifTypeEmail', false));
			alertTypes.push(getNotifType(alertNotifObject.ev.label, 'alertNotifTypeEV', false));
			alertTypes.push(getNotifType(alertNotifObject.console.label, 'alertNotifTypeCA', true));
			alertTypes.push(getNotifType(alertNotifObject.snmp.label, 'alertNotifTypeSNMP', false));
			return alertTypes;
		}

		function getCurrentLocale() {
			return cv.localeObj ? cv.localeObj : 0;
		}

		function getTemplatesAndTokensFromResp(data) {
			if (data == null || data == '') {
				return null;
			}
			let result = {
				tokenList: data.tokenList,
				notifTypesSupported: data.notifTypesSupported
			};

			data.msgs.forEach(msg => {
				if (msg.notifType === 4) {
					result.defaultTextTemplate = msg.notifMessage;
				} else if (msg.notifType === 1) {
					result.defaultHTMLTemplate = msg.notifMessageHtml;
				} else if (msg.notifType === 8192) {
					result.defaultJSONTemplate = msg.notifMessageHtml;
				}
			});

			const SUBJECT_BEGIN_TOKEN_ID = 1241513986,
				SUBJECT_END_TOKEN_ID = 1241513985;
			let subjectBeginIndex = result.tokenList.findIndex(token => token.tokenId === SUBJECT_BEGIN_TOKEN_ID);
			let subjectBeginTokenFormat = result.tokenList[subjectBeginIndex].tokenFormat;
			result.tokenList.splice(subjectBeginIndex, 1);

			let subjectEndIndex = result.tokenList.findIndex(token => token.tokenId === SUBJECT_END_TOKEN_ID);
			let subjectEndTokenFormat = result.tokenList[subjectEndIndex].tokenFormat;
			result.tokenList.splice(subjectEndIndex, 1);

			let subjectAndBodyObj = getEmailSubjectAndBody(
				result.defaultHTMLTemplate,
				subjectBeginTokenFormat,
				subjectEndTokenFormat
			);
			result.emailSubject = subjectAndBodyObj.subject;
			result.defaultHTMLTemplate = subjectAndBodyObj.body;

			if (result.defaultJSONTemplate && !verifyJSON(result.defaultJSONTemplate)) {
				const jsonHTMLTmpl = getEmailSubjectAndBody(
					result.defaultJSONTemplate,
					subjectBeginTokenFormat,
					subjectEndTokenFormat
				);
				result.defaultJSONTemplate = jsonHTMLTmpl.body;
			}

			result.subjectBeginTokenFormat = subjectBeginTokenFormat;
			result.subjectEndTokenFormat = subjectEndTokenFormat;

			return result;
		}

		function getEmailSubjectAndBody(message, beginTag, endTag) {
			let emailSubjectIndex = message.indexOf(endTag);

			let subject = emailSubjectIndex > -1 ? message.substring(beginTag.length, emailSubjectIndex) : '';
			let body = emailSubjectIndex > -1 ? message.substring(emailSubjectIndex + endTag.length) : message;

			return {
				subject: subject,
				body: body
			};
		}

		function updateNotifTypesAllowed(alertNotifTypes, notifTypesAllowed = [], notifTypesSelected = []) {
			let alertNotifObject = getAlertNotifObject();

			angular.forEach(alertNotifObject, notifObj => {
				if (notifTypesAllowed && notifTypesAllowed.length > 0) {
					alertNotifTypes[notifObj.index].disableProp = !(notifTypesAllowed.indexOf(notifObj.value) >= 0);
				}
				if (notifTypesSelected && notifTypesSelected.length > 0) {
					alertNotifTypes[notifObj.index].selected =
						!alertNotifTypes[notifObj.index].disableProp && notifTypesSelected.indexOf(notifObj.value) >= 0;
				}
			});
		}

		function isAlertNotifError(alertNotifTypes, alertNotifTypesError) {
			if (alertNotifTypes.findIndex(type => type.selected == true) >= 0) {
				alertNotifTypesError.error = cvUtil.emptyMsg();
				return false;
			} else {
				alertNotifTypesError.error = cvUtil.errMsg(cvLoc('error.alertNotifTypes'));
				return true;
			}
		}

		function isUserListEmpty() {
			return (
				$('#toUserList').select2('data').length == 0 &&
				$('#ccUserList').select2('data').length == 0 &&
				$('#bccUserList').select2('data').length == 0
			);
		}

		function encodeData(str) {
			return str.replace(/>/gi, '&gt;').replace(/</gi, '&lt;');
		}

		function verifyJSON(str) {
			try {
				const parsedJSON = JSON.parse(str);
				return JSON.stringify(parsedJSON, undefined, 4);
			} catch (e) {
				return '';
			}
		}

		function getPlainText(textMsg) {
			textMsg = textMsg.replace(/<\/p><p>/gi, '\n'); //Add \n for new line
			textMsg = textMsg.replace(/<[^>]+>/gm, ''); //Remove HTML Tags
			textMsg = $('<textarea />')
				.html(textMsg)
				.text(); //Remove HTML Entities
			return textMsg;
		}
		function processTokens(tokens) {
			let data = [];
			for (let i = 0; i < tokens.length; i++) {
				data.push({
					text: tokens[i].tokenFormat,
					value: encodeData(tokens[i].tokenFormat),
					title: tokens[i].tokenFormat
				});
			}
			return data;
		}
		function startEditor(editor, tokensList, template = '', isDisable = false) {
			let editorParams = {
				maxFileSize: 500000,
				tools: [
					'bold',
					'italic',
					'underline',
					'strikethrough',
					'insertUnorderedList',
					'insertOrderedList',
					'justifyLeft',
					'justifyCenter',
					'justifyRight',
					'createLink',
					'unlink',
					'uploadImage',
					'foreColor',
					'viewHtml',
					'fontSize',
					'tokens'
				],
				processTokens: function(tokens) {
					return processTokens(tokens);
				}
			};

			if (!editor.textEditorTemplate) {
				alertDetailsService.getTemplate().then(function(editorTemplate) {
					editor.textEditorTemplate = editorTemplate.data;
					if (!editor.textEditor) {
						editor.textEditor = new Editor(editorParams, $('#cv-editor'), editor.textEditorTemplate, cvLoc, {
							uploadImage: uploadImage,
							tokens: tokens
						});
						editor.textEditor.setText(template, true);
					}
					editor.textEditor.setTokens(editorParams.processTokens(tokensList));
					if (isDisable) {
						disableToolbar();
					}
				});
			} else {
				editor.textEditor.setTokens(editorParams.processTokens(tokensList));
			}
		}
		function disableToolbar() {
			let colorPicker = $('[data-role=colorpicker]').data('kendoColorPicker');
			if (colorPicker) colorPicker.enable(false);
			let comboBox = $('[data-role=combobox]').data('kendoComboBox');
			if (comboBox) comboBox.enable(false);
			//Disable all other buttons except token button which is the last one
			angular
				.element(
					document.querySelectorAll(
						'.k-editor-toolbar .k-tool-group:not(:last-child), .k-editor-toolbar .k-tool, .k-editor-toolbar li.k-tool-group:not(:last-child) > span'
					)
				)
				.addClass('k-state-disabled');
			//Avoid click of image button and font dropdown in IE because kendoComboBox is undefined in IE
			angular.element(document.querySelectorAll('.k-state-disabled')).css('pointer-events', 'none');
			//Set p margin as 0 to make the editor look like normal Text Editor
			document
				.querySelector('.cv-editor iframe')
				.contentWindow.document.styleSheets[0].insertRule('p {margin: 0px !important;}', 0);
		}

		function enableToolbar() {
			angular.element(document.querySelectorAll('.k-state-disabled')).css('pointer-events', 'auto');
			let colorPicker = $('[data-role=colorpicker]').data('kendoColorPicker');
			if (colorPicker) colorPicker.enable(true);
			let comboBox = $('[data-role=combobox]').data('kendoComboBox');
			if (comboBox) comboBox.enable(true);
			angular.element(document.querySelectorAll('.k-state-disabled')).removeClass('k-state-disabled');
			document.querySelector('.cv-editor iframe').contentWindow.document.styleSheets[0].deleteRule(0);
		}

		function deleteAlert(obj, successHandler, errorHandler) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					definitionsService
						.deleteAlertRule(obj.id)
						.success(function() {
							// $scope.getDefinitions();
							// cvToaster.showSuccessMessage({
							// 	'ttl': '5000', //5 sec
							// 	'message': cvLoc('info.singleDeleteRuleSuccess', '<b>' + obj.alert.name + '</b>')
							// });
							successHandler();
						})
						.error(function(e) {
							cvToaster.showErrorMessage({
								ttl: 5000, // 5sec
								message: e || cvLoc('error.deleteRuleError')
							});
						});
				}
			};

			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.deleteAlertDefinition', '<b>' + obj.name + '</b>'),
				callBackFunctions
			);
		}

		function alertLocaleChange(locale, successHandler) {
			let callBackFunctions = {
				yesFunction: function() {
					locale.lastSelectedLocaleName = locale.selectedLocale[0].localeName;
					successHandler();
				},
				noFunction: function() {
					let selectedIndex = -1;
					for (let i = 0; i < locale.alertLocaleList.length; i++) {
						let curLocale = locale.alertLocaleList[i];
						if (curLocale.localeName == locale.lastSelectedLocaleName) {
							selectedIndex = i;
						}
						curLocale.selected = false;
					}
					locale.alertLocaleList[selectedIndex].selected = true;
				}
			};
			$dialogs.confirm(cvLoc('label.confirmInit'), cvLoc('label.localeChangeNotifMsg'), callBackFunctions);
		}
		//Returns the binary number with corresponding bit set
		function getBitConstants() {
			return {
				notifType: {
					email: 1,
					snmp: 1 << 2,
					ev: 1 << 3,
					console: 1 << 13
				},
				sendIndividualAlert: 1 << 4,
				vm: 1 << 10
			};
		}
		return {
			formEntityAssoc: formEntityAssoc,
			initializeAddUserSelect: initializeAddUserSelect,
			getAlertNotifTypes: getAlertNotifTypes,
			getTemplatesAndTokensFromResp: getTemplatesAndTokensFromResp,
			updateNotifTypesAllowed: updateNotifTypesAllowed,
			getEmailSubjectAndBody: getEmailSubjectAndBody,
			getCurrentLocale: getCurrentLocale,
			isAlertNotifError: isAlertNotifError,
			getUsers: getUsers,
			getSelectedNotifTypes: getSelectedNotifTypes,
			getAlertNotifObject: getAlertNotifObject,
			isUserListEmpty: isUserListEmpty,
			encodeData: encodeData,
			startEditor: startEditor,
			disableToolbar: disableToolbar,
			enableToolbar: enableToolbar,
			getPlainText: getPlainText,
			deleteAlert: deleteAlert,
			processTokens: processTokens,
			alertLocaleChange: alertLocaleChange,
			getBitConstants: getBitConstants,
			verifyJSON
		};
	}
];

cvModuleAlertsModule.constant('ALERTS_SUPPORTED', {
	CONSOLE: 'console',
	EMAIL: 'email',
	EVENTVIEWER: 'eventViewer',
	SNMP: 'snmp'
});

const alertUIFactory = cvModuleAlertsModule.factory('alertUIFactory', alertUIFactoryFunction);

export default alertUIFactory;
