import 'modules/servers/js/services/servers.svc.js';
import 'storage/js/services/storage.svc.js';
import 'modules/alerts/js/services/alerts.svc.js';
import 'adminConsole/js/services/clients.svc.js';
import 'adminConsole/js/services/agents.svc.js';
import 'adminConsole/js/services/backupSets.svc.js';

import { cvModuleAlertsModule } from 'common/js/modules';

var serverMod = cvModuleAlertsModule;

serverMod.directive('cvBrowseAlertCollectionContent', function() {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'modules/alerts/partials/browseCollectionContent.jsp',
		scope: {
			vmSelected: '=',
			selectedContent: '=', // required - array to put selections in; array object must already exist
			alertId: '=', // required - server ID to browse,
			entityList: '=',
			singleSelectionMode: '@', // allow only one item to be selected - defaults to false
			selectableTypes: '@', // comma-delimited list of VSObjType types that can be selected - defaults to all
			selectContentWarningFn: '&',
			hideGrouping: '@',
			displayMode: '@',
			entityServerMessage: '=',
			serverMessage: '=',
			showSearchBar: '@',
			enableShowSelected: '@',
			ignoreRootLevel: '=', //if root level is selected, return all children instead, to avoid permission error for tenant admin
			preSelectedList: '='
			/*
			 * if selectContentWarningFn is specified, a "must select at least one item" warning will be shown
			 * when no items are currently selected in the tree. However, the warning will only be shown if
			 * selectContentWarningFn() returns true OR if the tree is "dirty", meaning the user has
			 * unselected an item. Typically, selectContentWarningFn() should return true if the user has
			 * attempted to submit the form, which is when we want validation warnings to be shown.
			 */
		},
		controller: [
			'$scope',
			'$log',
			'serverService',
			'storageService',
			'definitionsService',
			'clientService',
			'agentService',
			'backupSetService',
			'cvLoc',
			'cvUtil',
			'$stateParams',
			function(
				$scope,
				$log,
				serverService,
				storageService,
				definitionsService,
				clientService,
				agentService,
				backupSetService,
				cvLoc,
				cvUtil,
				$stateParams
			) {
				$scope.vendor = $stateParams.vendor;
				var dirty = false; // for validation messages - used in showContentWarning()
				// Configure options:
				var options = {};
				options.singleSelectionMode = !!$scope.singleSelectionMode;
				options.isSelectable = null; // allows all types to be selected; this is the default
				if (typeof $scope.selectableTypes === 'string' && $scope.selectableTypes.toLowerCase() !== 'all') {
					var parsed = $scope.selectableTypes.split(',');
					if (parsed.length > 0) {
						options.isSelectable = {};
						for (var i = 0, len = parsed.length; i < len; i++) {
							options.isSelectable[parsed[i].trim().toLowerCase()] = true;
						}
					}
				}

				if (!$scope.preSelectedList) {
					$scope.preSelectedList = {
						isAllClients: false,
						isAllClientGroups: false,
						entityList: []
					};
				}
				var createLoadingChildArray = function() {
					return [
						{
							type: 'LOADING',
							guid: '',
							displayName: cvLoc('Loading'),
							state: 'leaf',
							loaded: true
						}
					];
				};

				$scope.treeData = {
					contentBrowseViewPath: '\\NONE:Hosts',
					contentBrowseViewOptions: [],
					tree: {
						type: '',
						guid: '',
						displayName: '',
						inventoryPath: '\\NONE:Hosts',
						children: createLoadingChildArray()
					}
				};

				$scope.separator = '/';

				$scope.itemDrilledDown = function(item) {
					$scope.toggle(item);
				};

				var hasChildren = function(item) {
					return !!item.children && item.children.length;
				};

				$scope.showContentWarning = function() {
					if ($scope.selectedContent.length > 0) {
						return false;
					}

					if (typeof $scope.selectContentWarningFn !== 'function') {
						// No custom fn passed in to handle this - default to false
						return false;
					}
					return dirty || $scope.selectContentWarningFn();
				};

				var isItemInList = function(treeItem, selectedList) {
					if (!treeItem || !selectedList) {
						return false;
					}
					for (var i = 0; i < selectedList.length; i++) {
						var listItem = selectedList[i];
						if (treeItem.type === listItem.type && treeItem.id === listItem.id && treeItem.parent === listItem.parent) {
							return true;
						}
					}
					return false;
				};

				/*
				 * Subroutine of $scope.getSelectedList. Entries already in the list are not added.
				 * This adds objects convertable to the CollectionContentEntity java class, using only
				 * properties: type, guid, displayName, and inventoryPath.
				 */
				var addSelectedToList = function(item, selectedList) {
					var selectable = false;
					if (!!item.type && item.type !== 'LOADING') {
						// if item is $scope.treeData.tree, it won't have a type defined
						if (options.isSelectable == null) {
							selectable = true; // default is everything is selectable
						} else {
							selectable = !!options.isSelectable[item.type.toLowerCase()];
						}
					}
					if (selectable && item.selectedState === 'selected') {
						// Add to selected list if not there already
						if (!isItemInList(item, selectedList)) {
							// We add an object with only the fields from the VsaInventoryItem class here:
							selectedList.push({
								type: item.type,
								typeId: item.typeId,
								id: item.id,
								displayName: item.displayName,
								parent: item.parent
							});
						}
					} else if (hasChildren(item)) {
						// Item is not selected or is not selectable; check children
						for (var i = 0; i < item.children.length; i++) {
							addSelectedToList(item.children[i], selectedList);
						}
					}
				};

				/*
				 * Mines the tree and returns a list of currently selected VMs.
				 */
				$scope.getSelectedList = function() {
					var selectedList = [];
					addSelectedToList($scope.treeData.tree, selectedList);
					return selectedList;
				};

				/*
				 * Replaces the contents of the bound selectedContent list var with the current tree
				 * selections
				 */
				$scope.updateSelectedContent = function() {
					// Get list of selections:
					var newList = $scope.getSelectedList();

					// Replace content of bound selectedContent var with new selections:
					$scope.selectedContent.length = 0;
					$scope.selectedContent.push.apply($scope.selectedContent, newList);
				};

				/*
				 * Determines a single item's state from its childrens' states. Possible states are:
				 * 'selected', 'unselected', and 'partial'.
				 */
				var setSelectedStateFromChildren = function(item) {
					if (hasChildren(item)) {
						var count = 0;
						for (var i = 0; i < item.children.length; i++) {
							var cs = item.children[i].selectedState;
							if (cs === 'partial') {
								item.selectedState = 'partial';
								return;
							}
							if (cs === 'selected') {
								count++;
							}
						}
						if (count == 0) {
							item.selectedState = 'unselected';
						} else if (count == item.children.length) {
							item.selectedState = 'selected';
						} else {
							item.selectedState = 'partial';
						}
					}
				};

				/*
				 * Determines an item's state from its childrens' states and recurses up to the root.
				 * Possible states are: 'selected', 'unselected', and 'partial'.
				 */
				var setSelectedStateFromChildrenUp = function(item) {
					setSelectedStateFromChildren(item);
					if (item.parent) {
						setSelectedStateFromChildrenUp(item.parent);
					}
				};

				/* Sets the selected state of an item and all its descendants. */
				var setSelectedStateDown = function(item, state) {
					item.selectedState = state;
					if (hasChildren(item)) {
						for (var i = 0; i < item.children.length; i++) {
							setSelectedStateDown(item.children[i], state);
						}
					}
				};

				var clearAllSelections = function() {
					// Clear tree selections:
					setSelectedStateDown($scope.treeData.tree, 'unselected');
					// Clear selected content var:
					if ($scope.selectedContent.length > 0) {
						dirty = true;
					}
					$scope.selectedContent.length = 0;
				};

				$scope.selectAll = function() {
					setSelectedStateDown($scope.treeData.tree, 'selected');
					$scope.updateSelectedContent();
				};

				$scope.clearAll = function() {
					$scope.input.searchText = '';
					$scope.search($scope.treeData.tree);
					clearAllSelections();
				};

				/*
				 * Called when a selectable item is clicked on. This sets 'partial' and 'unselected'
				 * items to 'selected', and 'selected' items to 'unselected'. The setting is
				 * propagated recursively to the node's descendants, and the node's ancestors are
				 * adjusted as needed to maintain appropriate states.
				 */
				$scope.toggleSelectedState = function(item) {
					if (item.type === 'LOADING' || $scope.displayMode === 'readOnly' || item.disabled) {
						return;
					}
					var selectable = false;
					if (options.isSelectable == null) {
						selectable = true; // default is everything is selectable
					} else {
						selectable = options.isSelectable[item.type.toLowerCase()];
					}

					if (!selectable) {
						$scope.toggle(item);
						return;
					}
					var newState = null;
					if (item.selectedState === 'selected') {
						dirty = true;
						newState = 'unselected';
					} else {
						// Partials and unselected items become selected
						if (options.singleSelectionMode && $scope.selectedContent.length > 0) {
							// Only one selection is allowed - clear old selection first
							clearAllSelections();
						}
						newState = 'selected';
					}
					setSelectedStateDown(item, newState);
					if (item.parent) {
						setSelectedStateFromChildrenUp(item.parent);
					}
					$scope.updateSelectedContent();
				};

				/* Expand or collapse a node */
				$scope.toggle = function(item) {
					if (item.type !== 'VM') {
						if (item.state == 'expanded') {
							item.state = 'collapsed';
						} else {
							$scope.expand(item);
						}
					}
				};

				/* Expand a tree node and populate as necessary */
				$scope.expand = function(item) {
					if (!item.loaded && $scope.displayMode != 'readOnly') {
						$log.debug('Expanding tree node: ', item);
						$scope.doBrowse(item);
					}
					item.state = 'expanded';
					if (item.children && item.children.length > 0)
						for (var i = 0; i < item.children.length; ++i) {
							item.children[i].hidden = false;
						}
				};

				var checkInSelectedVm = function(currentGuid) {
					var found = false;
					angular.forEach($scope.vmSelected, function(currVM) {
						if (currVM.guid == currentGuid) {
							found = true;
							return;
						}
					});
					return found;
				};

				//MR 186789 search for entities
				$scope.input = {};
				$scope.search = function(item) {
					var searchResult = false;
					var isResult = false;
					$scope.input.showSelected = false;
					if (item.displayName && item.displayName.toLowerCase().indexOf($scope.input.searchText.toLowerCase()) > -1) {
						isResult = true;
					}
					if (item.children && item.children.length > 0) {
						for (var i = 0; i < item.children.length; ++i) {
							if ($scope.search(item.children[i])) searchResult = true;
						}
					}
					item.hidden = !(searchResult || isResult);
					item.state = searchResult ? 'expanded' : 'collapsed';
					if (!$scope.input.searchText) {
						if (!item.type || item.type == 'clientRoot' /* || item.type=='clientGroupRoot' */) item.state = 'expanded';
						else item.state = 'collapsed';
					}
					return searchResult || isResult;
				};

				$scope.clearSearch = function() {
					$scope.input.searchText = '';
					$scope.search($scope.treeData.tree);
				};

				$scope.showSelected = function(item) {
					var selectedResult = false;
					var isResult = false;
					$scope.input.searchText = '';
					if (item.selectedState == 'selected' || item.selectedState == 'partial') isResult = true;
					if (item.children && item.children.length > 0) {
						for (var i = 0; i < item.children.length; ++i) {
							if ($scope.showSelected(item.children[i])) selectedResult = true;
						}
					}
					item.hidden = !(selectedResult || isResult);
					item.state = selectedResult ? 'expanded' : 'collapsed';
					if (!$scope.input.showSelected) {
						item.hidden = false;
						if (!item.type || item.type == 'clientRoot' /* || item.type=='clientGroupRoot' */) item.state = 'expanded';
						else item.state = 'collapsed';
					}
					return selectedResult || isResult;
				};

				/* Load VM data for a tree node */
				$scope.doBrowse = function(item) {
					if (typeof item.selectedState === 'undefined') {
						item.selectedState = 'unselected';
					}
					var inventoryPath = item.inventoryPath || '\\';
					$log.debug('Browsing tree node: inventoryPath=', inventoryPath);

					if (item.type == 'clientGroupRoot') {
						return;
					}

					if (item.type == 'clientRoot') {
						return;
					}

					item.children = createLoadingChildArray();

					var inventory = [];
					$scope.serverMessage = cvUtil.emptyMsg();

					if (item.type == 'client') {
						clientService
							.getAgents(item.id)
							.success(function(data) {
								if (data) {
									$scope.browseResp = data;
								} else {
									$scope.browseResp = {};
								}

								populateAgents(item, $scope.browseResp);
								$scope.serverMessage = cvUtil.emptyMsg();
							})
							.error(function(err) {
								$scope.serverMessage = {
									message: err.trim() != '' ? err : cvLoc('error.loadingEntities'),
									type: 'error'
								};
							});
					} else if (item.type == 'agent') {
						agentService
							.getInstances(item.parent.id, item.id)
							.success(function(data) {
								if (data) {
									$scope.browseResp = data;
								} else {
									$scope.browseResp = {};
								}

								populateInstances(item, $scope.browseResp);
								$scope.serverMessage = cvUtil.emptyMsg();
							})
							.error(function(err) {
								$scope.serverMessage = {
									message: err.trim() != '' ? err : cvLoc('error.loadingEntities'),
									type: 'error'
								};
							});
					} else if (item.type == 'instance') {
						agentService
							.getBackupSetsByInstance(item.parent.parent.id, item.parent.id, item.id)
							.success(function(data) {
								if (data) {
									$scope.browseResp = data;
								} else {
									$scope.browseResp = {};
								}
								populateBackupset(item, $scope.browseResp);
								$scope.serverMessage = cvUtil.emptyMsg();
							})
							.error(function(err) {
								$scope.serverMessage = {
									message: err.trim() != '' ? err : cvLoc('error.loadingEntities'),
									type: 'error'
								};
							});
					} else if (item.type == 'backupSet') {
						backupSetService
							.getSubClientsByInstance(
								item.parent.parent.parent.id,
								item.parent.parent.id,
								item.id,
								item.parent.id,
								true
							)
							.success(function(data) {
								if (data) {
									$scope.browseResp = data;
								} else {
									$scope.browseResp = {};
								}

								populateSubclientList(item, $scope.browseResp);
								$scope.serverMessage = cvUtil.emptyMsg();
							})
							.error(function(err) {
								$scope.serverMessage = {
									message: err.trim() != '' ? err : cvLoc('error.loadingEntities'),
									type: 'error'
								};
							});
					}
				};

				var populateSubclientList = function(item, childData) {
					var inventory = [];
					angular.forEach(childData, function(browseItem) {
						$log.debug(' - Loaded child: ', browseItem);
						var iconName = 'vsaIcon' + browseItem.type;

						var child = {
							// VsaInventoryItem fields:
							type: 'subClient',
							typeId: '7',
							displayName: browseItem.subClientEntity.subclientName,
							id: browseItem.subClientEntity.subclientId,
							// Tree-only fields:
							parent: item,
							state: 'collapsed',
							loaded: true,
							iconName: 'alertFolderIcon'
						};

						inventory.push(child);
						if (browseItem.children) {
							populateItem(child, browseItem.children);
						}
					});
					item.children = inventory;
					item.loaded = true;
				};

				var populateBackupset = function(item, childData) {
					var inventory = [];
					angular.forEach(childData, function(browseItem) {
						$log.debug(' - Loaded child: ', browseItem);
						var iconName = 'vsaIcon' + browseItem.type;

						var child = {
							// VsaInventoryItem fields:
							type: 'backupSet',
							typeId: '6',
							displayName: browseItem.backupSetEntity.backupsetName,
							id: browseItem.backupSetEntity.backupsetId,
							// Tree-only fields:
							parent: item,
							state: 'collapsed',
							loaded: false,
							iconName: 'alertFolderIcon'
						};

						inventory.push(child);
						if (browseItem.children) {
							populateItem(child, browseItem.children);
						}
					});
					item.children = inventory;
					item.loaded = true;
				};

				var populateInstances = function(item, childData) {
					var inventory = [];
					angular.forEach(childData, function(browseItem) {
						$log.debug(' - Loaded child: ', browseItem);
						var iconName = 'vsaIcon' + browseItem.type;

						var child = {
							// VsaInventoryItem fields:
							type: 'instance',
							typeId: '5',
							displayName: browseItem.instance.instanceName,
							id: browseItem.instance.instanceId,
							// Tree-only fields:
							parent: item,
							state: 'collapsed',
							loaded: false,
							iconName: 'alertFolderIcon'
						};

						inventory.push(child);
						if (browseItem.children) {
							populateItem(child, browseItem.children);
						}
					});
					item.children = inventory;
					item.loaded = true;
				};

				var populateAgents = function(item, childData) {
					var inventory = [];
					angular.forEach(childData, function(browseItem) {
						$log.debug(' - Loaded child: ', browseItem);
						var iconName = 'vsaIcon' + browseItem.type;

						var child = {
							// VsaInventoryItem fields:
							type: 'agent',
							typeId: '4',
							displayName: browseItem.idaEntity.appName,
							id: browseItem.idaEntity.applicationId,
							// Tree-only fields:
							parent: item,
							state: browseItem.type === 'VM' ? 'leaf' : 'collapsed',
							loaded: false,
							iconName: 'alertFolderIcon'
						};

						inventory.push(child);
						if (browseItem.children) {
							populateItem(child, browseItem.children);
						}
					});
					item.children = inventory;
					item.loaded = true;
				};

				var populateReadOnly = function(item) {
					var inventory = [];
					var childData = [];
					var clientGroupData = [];
					var clientGroupInventory = [];
					var clientInventory = [];

					var isAllClientGroupsFlag = $scope.entityList.isAllClientGroups;
					var isAllClientsFlag = $scope.entityList.isAllClients;

					var entityList = $scope.entityList.xmlEntityList.associations;
					angular.forEach(entityList, function(client) {
						if (client.clientName != undefined && client.clientName != '') {
							childData.push(client);
						}
						if (client.clientGroupName != undefined && client.clientGroupName != '') {
							clientGroupData.push(client);
						}
					});

					if (
						(!childData || !childData.length > 0) &&
						(!clientGroupData || !clientGroupData.length > 0) &&
						!isAllClientsFlag &&
						!isAllClientGroupsFlag
					) {
						//no clients and client groups, isAllClientsFlag could be set to true indicates all clients with only one record with all empty values
						item.children = {};
						return;
					}

					if (clientGroupData.length > 0 || isAllClientGroupsFlag) {
						// if client groups exist, move then under client groups

						var displayName = cvLoc('label.clientGroups');
						var selectedState = 'unselected';

						if (isAllClientGroupsFlag) {
							// if all client groups flag exist, add this at root level
							displayName = cvLoc('label.allClientGroups');
							selectedState = 'selected';
						}
						var clientGroupRoot = {
							// clients
							type: 'clientGroupRoot',
							typeId: '27',
							displayName: displayName,
							id: '',
							// Tree-only fields:
							parent: '',
							state: 'expanded',
							loaded: true,
							iconName: 'alertFolderIcon',
							selectedState: selectedState
						};
						angular.forEach(clientGroupData, function(browseItem) {
							// if already present, means there is another item under the same client

							if (!browseItem.flags || !browseItem.flags.exclude) {
								// if excluded item, do not add to the tree, exclusions will have to be handled later
								var child = {
									// clients
									type: 'client',
									typeId: '28',
									displayName: browseItem.clientGroupName,
									id: browseItem.clientGroupId,
									// Tree-only fields:
									parent: '',
									state: 'expanded',
									loaded: true,
									iconName: 'alertFolderIcon',
									selectedState: 'selected'
								};
								clientGroupInventory.push(child); // prepare all clientgroup list
							}
						});

						clientGroupRoot.children = clientGroupInventory; // make all client groups as children to root client group element

						inventory.push(clientGroupRoot); // add root element of client group
					}

					if (childData.length > 0 || isAllClientsFlag) {
						var displayName = cvLoc('label.clients');
						var selectedState = 'unselected';

						if (isAllClientsFlag) {
							displayName = cvLoc('label.allClients');
							selectedState = 'selected';
						}

						var clientRoot = {
							// clients
							type: 'clientRoot',
							typeId: '2',
							displayName: displayName,
							id: '',
							// Tree-only fields:
							parent: '',
							state: 'expanded',
							loaded: true,
							iconName: 'alertFolderIcon',
							selectedState: selectedState
						};

						$scope.clientMap = {};
						//							$scope.clientMap.agents = [];
						//							$scope.clientMap.agents.instances = [];
						//							$scope.clientMap.agents.instances.backupsets = [];
						//							$scope.clientMap.agents.instances.backupsets.subclient = [];

						angular.forEach(childData, function(browseItem) {
							var isClientFound = false;

							if (!browseItem.flags || !browseItem.flags.exclude) {
								// if excluded item, do not add to the tree to display, exclusions will have to be handled later
								angular.forEach($scope.clientMap, function(obj) {
									// if already present, means there is another item under the same client
									if ($scope.clientMap[browseItem.clientId]) {
										isClientFound = true;
									}
								});
								if (!isClientFound) {
									var child = {
										// clients
										type: 'client',
										typeId: '3',
										displayName: _.get(browseItem, 'displayName', browseItem.clientName),
										id: browseItem.clientId,
										// Tree-only fields:
										parent: '',
										state: 'expanded',
										loaded: true,
										iconName: 'alertFolderIcon',
										selectedState: 'selected'
									};

									$scope.clientMap[browseItem.clientId] = child; // first entry with this clientId
									clientInventory.push($scope.clientMap[browseItem.clientId]);
								}

								if (browseItem.applicationId) {
									$scope.setAgentIfNotPresent($scope.clientMap[browseItem.clientId], browseItem);
								}
							}
						});

						clientRoot.children = clientInventory; // make all clients as children to root client element
						inventory.push(clientRoot); // add root element of client
					}

					item.children = inventory;
					item.loaded = true;
				};

				$scope.setAgentIfNotPresent = function(parentItemParam, browseItem) {
					var isAgentFound = false; // now check for the agent already exist for the given client
					if (!browseItem.applicationId) {
						return;
					}

					angular.forEach(parentItemParam.agents, function(agent) {
						if (parentItemParam.agents[browseItem.applicationId]) {
							isAgentFound = true;
						}
					});
					if (!isAgentFound) {
						// agent not found, so add agent for the client

						var child = {
							type: 'agent',
							typeId: '4',
							displayName: browseItem.appName,
							id: browseItem.applicationId,
							// Tree-only fields:
							parent: parentItemParam,
							state: 'expanded',
							loaded: false,
							iconName: 'alertFolderIcon',
							selectedState: 'selected'
						};
						if (!parentItemParam.agents) {
							// very first time, create agents array under clients
							parentItemParam.agents = {};
						}
						parentItemParam.agents[browseItem.applicationId] = child;
						parentItemParam.children = parentItemParam.agents;
					}

					if (browseItem.instanceId) {
						$scope.setInstancesIfNotPresent(parentItemParam.agents[browseItem.applicationId], browseItem);
					}
				};

				$scope.setInstancesIfNotPresent = function(parentAgentItemParam, browseItem) {
					// construct instances under agent
					var isInstanceFound = false; // now check for the agent already exist for the given client
					if (!browseItem.instanceId) {
						return;
					}

					angular.forEach(parentAgentItemParam.instances, function(instances) {
						if (parentAgentItemParam.instances[browseItem.instanceId]) {
							isInstanceFound = true;
						}
					});
					if (!isInstanceFound) {
						// instance not found, so add instance to the agent

						var child = {
							type: 'instance',
							typeId: '4',
							displayName: browseItem.instanceName,
							id: browseItem.instanceId,
							// Tree-only fields:
							parent: parentAgentItemParam,
							state: 'expanded',
							loaded: false,
							iconName: 'alertFolderIcon',
							selectedState: 'selected'
						};
						if (!parentAgentItemParam.instances) {
							// very first time, create instances array under agents
							parentAgentItemParam.instances = {};
						}
						parentAgentItemParam.instances[browseItem.instanceId] = child;
						parentAgentItemParam.children = parentAgentItemParam.instances;
					}

					if (browseItem.backupsetId) {
						$scope.setBackupSetIfNotPresent(parentAgentItemParam.instances[browseItem.instanceId], browseItem);
					}
				};

				$scope.setBackupSetIfNotPresent = function(parentInstanceItemParam, browseItem) {
					// construct instances under agent
					var isBackupSetFound = false; // now check for the agent already exist for the given client
					if (!browseItem.instanceId) {
						return;
					}

					angular.forEach(parentInstanceItemParam.backupsets, function(backupsets) {
						if (parentInstanceItemParam.backupsets[browseItem.backupsetId]) {
							isBackupSetFound = true;
						}
					});
					if (!isBackupSetFound) {
						// backupset  not found, so add backupset for the instance

						var child = {
							type: 'instance',
							typeId: '4',
							displayName: browseItem.backupsetName,
							id: browseItem.backupsetId,
							// Tree-only fields:
							parent: parentInstanceItemParam,
							state: 'expanded',
							loaded: false,
							iconName: 'alertFolderIcon',
							selectedState: 'selected'
						};
						if (!parentInstanceItemParam.backupsets) {
							// very first time, create instances array under agents
							parentInstanceItemParam.backupsets = {};
						}
						parentInstanceItemParam.backupsets[browseItem.backupsetId] = child;
						parentInstanceItemParam.children = parentInstanceItemParam.backupsets;
					}

					if (browseItem.subclientId) {
						$scope.setSubClientIfNotPresent(parentInstanceItemParam.backupsets[browseItem.backupsetId], browseItem);
					}
				};

				$scope.setSubClientIfNotPresent = function(parentBackupSetItemParam, browseItem) {
					// construct subclients under backupset
					var isSubClientFound = false;
					if (!browseItem.subclientId) {
						return;
					}

					angular.forEach(parentBackupSetItemParam.subclients, function(subclients) {
						if (parentBackupSetItemParam.subclients[browseItem.subclientId]) {
							isSubClientFound = true;
						}
					});
					if (!isSubClientFound) {
						// subclient  not found, so add this subclient to the backup set

						var child = {
							type: 'instance',
							typeId: '4',
							displayName: browseItem.subclientName,
							id: browseItem.subclientId,
							// Tree-only fields:
							parent: parentBackupSetItemParam,
							state: 'expanded',
							loaded: true,
							iconName: 'alertFolderIcon',
							selectedState: 'selected'
						};
						if (!parentBackupSetItemParam.subclients) {
							parentBackupSetItemParam.subclients = {};
						}
						parentBackupSetItemParam.subclients[browseItem.subclientId] = child;
						parentBackupSetItemParam.children = parentBackupSetItemParam.subclients;
					}
				};

				$scope.doLoadInit = function(item) {
					dirty = false;
					var inventory = [];
					var clientGroups = [];
					var clients = [];

					var clientGroupRoot = {
						// clients
						type: 'clientGroupRoot',
						typeId: '27',
						displayName: cvLoc('label.clientGroups'),
						id: '',
						// Tree-only fields:
						parent: '',
						state: 'collapsed',
						loaded: true,
						iconName: 'alertFolderIcon',
						disabled: $scope.ignoreRootLevel,
						selectedState: $scope.preSelectedList.isAllClientGroups ? 'selected' : ''
					};

					var clientRoot = {
						// clients
						type: 'clientRoot',
						typeId: '2',
						displayName: cvLoc('label.clients'),
						id: '',
						// Tree-only fields:
						parent: '',
						state: 'expanded',
						loaded: true,
						iconName: 'alertFolderIcon',
						disabled: $scope.ignoreRootLevel,
						selectedState: $scope.preSelectedList.isAllClients ? 'selected' : ''
					};

					$scope.entityServerMessage = cvUtil.emptyMsg();

					if (!$scope.alertId || $scope.alertId.alertId.length == 0) {
						return false;
					}

					definitionsService
						.getEntityList($scope.alertId.alertId, $scope.alertId.isVM)
						.success(function(data) {
							if (data && data.length > 0) {
								$scope.entityList = data;

								inventory.push(clientGroupRoot);
								inventory.push(clientRoot);
							} else {
								$scope.entityList = {};
								$scope.entityServerMessage = {
									message: cvLoc('label.noEntitiesAvailable'),
									type: 'error'
								};
							}

							angular.forEach($scope.entityList, function(entity) {
								if (entity.clientId && entity.clientId > 0) {
									var child = {
										// clients
										type: 'client',
										typeId: '3',
										displayName: _.get(entity, 'displayName', entity.clientName),
										id: entity.clientId,
										// Tree-only fields:
										parent: '',
										state: 'collapsed',
										loaded: false,
										iconName: 'alertFolderIcon'
									};
									if (
										$scope.preSelectedList.isAllClients ||
										$scope.preSelectedList.entityList.findIndex(item => item.clientId == entity.clientId) > -1
									) {
										child.selectedState = 'selected';
									}
									clients.push(child);
								} else if (entity.clientGroupId) {
									var child = {
										// clients
										type: 'clientGroup',
										typeId: '28',
										displayName: entity.clientGroupName,
										id: entity.clientGroupId,
										// Tree-only fields:
										parent: '',
										state: 'expanded',
										loaded: true,
										iconName: 'alertFolderIcon'
									};
									if (
										$scope.preSelectedList.isAllClientGroups ||
										$scope.preSelectedList.entityList.findIndex(item => item.clientGroupId == entity.clientGroupId) > -1
									) {
										child.selectedState = 'selected';
									}
									clientGroups.push(child);
								}
							});

							clientGroupRoot.children = clientGroups;
							clientRoot.children = clients;
							item.children = inventory;
							item.loaded = true;
							$scope.updateSelectedContent();
						})
						.error(function(err) {
							$scope.serverMessage = {
								message: err.trim() != '' ? err : cvLoc('error.loadingEntities'),
								type: 'error'
							};
						});

					//							if (typeof item.selectedState === "undefined") {
					//								item.selectedState = 'unselected';
					//							}
				};

				/*
				 * Called when the user selects a VM-tree grouping from a dropdown. In this case the
				 * tree is cleared and reloaded from the root using the new setting.
				 */
				$scope.treeViewChanged = function() {
					clearAllSelections();
					$scope.treeData.tree = {
						type: '',
						guid: '',
						displayName: '',
						inventoryPath: $scope.treeData.contentBrowseViewPath,
						children: createLoadingChildArray()
					};
					$scope.doLoadInit($scope.treeData.tree);
				};

				if ($scope.displayMode === 'readOnly') {
					if (!$scope.selectedContent) {
						$scope.selectedContent = {};
					}
					$scope.$watch('entityList', function(newValue, oldValue) {
						//							if ($scope.entityList && $scope.entityList.length === 1
						//									&& ($scope.entityList[0].clientId == "0")) { // dummylist
						//								return;
						//							}

						$scope.treeData.tree = {
							type: '',
							guid: '',
							displayName: '',
							inventoryPath: $scope.treeData.contentBrowseViewPath,
							children: createLoadingChildArray()
						};
						populateReadOnly($scope.treeData.tree);
						$scope.treeData.tree.state = 'expanded';
					});
				} else {
					$scope.$watch('alertId', function(newValue, oldValue) {
						if (!oldValue || newValue.alertId != oldValue.alertId || newValue.isVM != oldValue.isVM) {
							$scope.treeViewChanged();
						}
					});
				}

				// Initial tree loading:
				$scope.treeData.tree.state = 'expanded';

				//$scope.doLoadInit($scope.treeData.tree);
			}
		]
	};
});

export default serverMod;
