import 'modules/ida/js/directives/cv-browse-directives.js';
import 'modules/alerts/js/directives/cv-browse-servers-collection-content-directive.js';
import 'modules/alerts/js/directives/cv-text-viewer.js';
import 'modules/alerts/js/services/alerts.svc.js';
import 'modules/alerts/js/factories/alertUI.factory.js';

import { cvModuleAlertsModule } from 'common/js/modules';

var alertsMod = cvModuleAlertsModule;

var controllers = {};

/*
 * Alert Details Controller
 */
controllers.alertDetailsController = [
	'$scope',
	'$uibModal',
	'$log',
	'$stateParams',
	'alertDetailsService',
	'alertUIFactory',
	'cvLoc',
	'cvUtil',
	'$state',
	'cvToaster',
	'cvBreadcrumbsTabsFactory',
	'definitionsService',
	'$dialogs',
	function(
		$scope,
		$modal,
		$log,
		$stateParams,
		alertDetailsService,
		alertUIFactory,
		cvLoc,
		cvUtil,
		$state,
		cvToaster,
		cvBreadcrumbsTabsFactory,
		definitionsService,
		$dialogs
	) {
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.alertDefinitions'),
				link: '#/alertsDefinitions'
			}
		]);

		$scope.alertId = $stateParams.alertId;
		$scope.tabControls = {}; //Need to select "To" tab when target is changed.
		$scope.serverMessage = cvUtil.infoMsgLoc('Loading');

		$scope.openTargetEditModal = function() {
			var targetDialog = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/alerts/partials/addAlertStepTarget.jsp',
				windowClass: 'editTargetModal',
				backdrop: 'static',
				controller: targetModalController,
				resolve: {
					targetObj: function() {
						return {
							//Pass only required data
							alertId: $scope.alertId,
							selectedNotifTypes: $scope.selectedNotifTypes,
							selectedFormatUsersList: $scope.selectedFormatUsersList,
							selectedFormatUsersListCc: $scope.selectedFormatUsersListCc,
							selectedFormatUsersListBcc: $scope.selectedFormatUsersListBcc
						};
					}
				}
			});

			//Update modal values on success based on teh changes done
			targetDialog.result.then(function(alertDef) {
				let originalNotifType = $scope.alertInfo.alert.notifType;
				$scope.alertInfo.alert.notifType = alertDef.notifTypeNumber; //notifTypeNumber is the notif type used in binary digits
				//Make length 0 to empty the current list. If you use [], it will create a new list.
				$scope.selectedNotifTypes.length = 0;
				$scope.notifTypeList.length = 0;
				$scope.updateNotifTypesList();

				//If either email or console is selected now but earlier none of them is selected then set html as empty so that we can display default HTML template in editor.
				if (
					($scope.notifTypeSelection.email || $scope.notifTypeSelection.console) &&
					!(
						originalNotifType & $scope.bitConstants.notifType.email ||
						originalNotifType & $scope.bitConstants.notifType.console
					)
				) {
					$scope.originalTemplate.html = null;
				}

				//If either event viewer or snmp is selected now but earlier none of them is selected then set text as empty so that we can display default Text template in editor.
				if (
					($scope.notifTypeSelection.ev || $scope.notifTypeSelection.snmp) &&
					!(
						originalNotifType & $scope.bitConstants.notifType.snmp ||
						originalNotifType & $scope.bitConstants.notifType.ev
					)
				) {
					$scope.originalTemplate.text = null;
				}

				$scope.updateUndefinedUserList(true);

				/*
				 * pushUserToList converts the selected users in format that we got from server when we get
				 * Alert info. These userList objects are directly binded with HTML User list so update these
				 * objects to update teh list on UI without refreshing the page.
				 */
				$scope.pushUserToList = function(groupType, recipientType, userId, userName) {
					$scope.alertInfo[groupType + recipientType].push({
						id1: userId,
						id2: 1,
						name: userName
					});
				};
				$scope.getUsersInDisplayFormat = function(
					usersList,
					dataListSelector,
					displayListSelector,
					dataIdSelector,
					dataNameSelector
				) {
					let recipientType = '';
					usersList.forEach(userList => {
						recipientType =
							userList.recipientType == 'TO'
								? $scope.recipientTypesPropNames[0]
								: userList.recipientType == 'CC'
								? $scope.recipientTypesPropNames[1]
								: $scope.recipientTypesPropNames[2];
						if (angular.isArray(userList[dataListSelector])) {
							userList[dataListSelector].forEach(user => {
								$scope.pushUserToList(displayListSelector, recipientType, user[dataIdSelector], user[dataNameSelector]);
							});
						} else {
							$scope.pushUserToList(
								displayListSelector,
								recipientType,
								userList[dataIdSelector],
								userList[dataNameSelector]
							);
						}
					});
				};

				$scope.getUsersInDisplayFormat(alertDef.recipientUserList, 'userList', 'userList', 'userId', 'userName');
				$scope.getUsersInDisplayFormat(
					alertDef.recipientUserGroupList,
					'userGroupList',
					'userGroupList',
					'userGroupId',
					'userGroupName'
				);
				$scope.getUsersInDisplayFormat(
					alertDef.recipientadUserGroupList,
					'userGroupList',
					'externalGroupList',
					'userGroupId',
					'userGroupName'
				);
				$scope.getUsersInDisplayFormat(
					alertDef.nonGalaxyList.nonGalaxyUserList,
					'nonGalaxyUser',
					'nonGalaxyUserList',
					'nonGalaxyUser',
					'nonGalaxyUser'
				);

				$scope.setSelectedUsers();

				//Update show property to hide/show "To", "Cc" and "Bcc" list
				$scope.recipientTypesPropNames.forEach((type, index) => {
					$scope.allUsersList[index].showProperty = $scope['selectedFormatUsersList' + type].length > 0;
				});
			});
		};

		$scope.editTemplate = function() {
			var templateDialog = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/alerts/partials/addAlertStepTemplate.jsp',
				windowClass: 'editTemplateModal',
				backdrop: 'static',
				controller: templateModalController,
				resolve: {
					targetObj: function() {
						return {
							alertId: $scope.alertId,
							alertTypeId: $scope.alertInfo.alert.alertType.id,
							alertCriteriaId: $scope.alertInfo.criteria[0].criteriaId,
							locale: $scope.alertInfo.locale,
							selectedNotifTypes: $scope.selectedNotifTypes,
							notifMsgs: $scope.originalTemplate
						};
					}
				}
			});
			templateDialog.result.then(function(obj) {
				$scope.selectedNotifTypes.forEach(notifType => {
					switch (notifType) {
						case $scope.alertNotifObject.email.value:
							$scope.originalTemplate.html = obj.html;
							break;
						case $scope.alertNotifObject.ev.value:
						case $scope.alertNotifObject.snmp.value:
							$scope.originalTemplate.text = obj.text;
							break;
						case $scope.alertNotifObject.console.value:
							$scope.originalTemplate.json = obj.json;
							break;
					}
				});

				$scope.alertInfo.locale.localeID = obj.locale.localeID;
				$scope.alertInfo.locale.localeName = obj.locale.localeName;
			});
		};

		$scope.openEntitiesEditModal = function() {
			var entitiesDialog = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/alerts/partials/addAlertStepEntities.jsp',
				windowClass: 'editEntitiesModal',
				backdrop: 'static',
				controller: entitiesModalController,
				resolve: {
					targetObj: function() {
						return {
							alertId: $scope.alertId,
							alertType: $scope.alertInfo.alert.alertType.id,
							isVM: $scope.alertInfo.alert.status & $scope.bitConstants.vm,
							preSelectedList: {
								isAllClients: $scope.alertDetail.isAllClients,
								isAllClientGroups: $scope.alertDetail.isAllClientGroups,
								entityList:
									$scope.alertDetail.xmlEntityList &&
									$scope.alertDetail.xmlEntityList.associations &&
									$scope.alertDetail.xmlEntityList.associations.length > 0
										? $scope.alertDetail.xmlEntityList.associations
										: []
							}
						};
					}
				}
			});
		};

		//Enable/disable alerts
		$scope.enableDisableAlert = () => {
			const status = _.get($scope.alertInfo, 'alert.status');
			const doEnable = status & 1 ? true : false;
			$scope.disableLink = true;
			definitionsService
				.enableDisableAlert({
					alertId: $scope.alertInfo.alert.alert.id,
					doEnable: doEnable
				})
				.success(function(data) {
					$scope.disableLink = false;
					if (!doEnable) {
						$scope.alertInfo.alert.status = $scope.alertInfo.alert.status | 1;
						$scope.enableLabel = cvLoc('label.enable');
					} else {
						$scope.alertInfo.alert.status = $scope.alertInfo.alert.status >> 1;
						$scope.alertInfo.alert.status = $scope.alertInfo.alert.status << 1;
						$scope.enableLabel = cvLoc('label.disable');
					}
				})
				.error(function(e) {
					$scope.disableLink = false;
					cvToaster.showErrorMessage({
						ttl: 5000, // 5sec
						message: e || cvLoc('error.enableDisableError')
					});
				});
		};

		$scope.deleteAlert = function() {
			var successHandler = function() {
				$state.go('alertsDefinitions');
				cvToaster.showSuccessMessage({
					ttl: '5000', //5 sec
					message: cvLoc('label.deleteRuleSuccess')
				});
			};
			alertUIFactory.deleteAlert({ id: $scope.alertId, name: $scope.alertInfo.alert.alert.name }, successHandler);
		};

		alertDetailsService
			.getExistingAlertInfo({ alertId: $scope.alertId })
			.success(function(alertDetails) {
				$scope.serverMessage = cvUtil.emptyMsg();
				$scope.alertDetail = alertDetails;
				$scope.alertInfo = alertDetails.alertDetail; //Use $scope.alertInfo to avoid $scope.alertDetail.alertDetail everytime.
				$scope.changeNameObj = _.get(alertDetails, 'alertDetail.alert.alert');

				//disabledClass used to add "disabled" for "To", "Cc" and "Bcc" list wrapper so that "Cc" and "Bcc" can be disabled when Email is not selected.
				$scope.disabledClass = {
					className: ''
				};
				//Set enable/disable locale label
				const doEnable = alertDetails.alertDetail.alert.status & 1 ? true : false;
				$scope.enableLabel = doEnable ? cvLoc('label.enable') : cvLoc('label.disable');

				$scope.usersGroupsPropNames = ['userList', 'userGroupList', 'nonGalaxyUserList', 'externalGroupList'];
				$scope.recipientTypesPropNames = ['', 'Cc', 'Bcc'];

				$scope.bitConstants = alertUIFactory.getBitConstants();
				$scope.notifTypeList = []; //List of selected notification types to show on UI
				$scope.notifTypeSelection = {
					email: false,
					console: false,
					ev: false,
					snmp: false
				};
				$scope.selectedNotifTypes = []; //List of notif types selected to pass to target and template controllers.
				$scope.alertNotifObject = alertUIFactory.getAlertNotifObject();

				$scope.addNotifType = function(label, value) {
					$scope.notifTypeList.push(label);
					$scope.selectedNotifTypes.push(value);
				};

				$scope.updateNotifTypesList = function() {
					let notifType = $scope.alertInfo.alert.notifType;
					if (notifType & $scope.bitConstants.notifType.email) {
						$scope.addNotifType($scope.alertNotifObject.email.label, $scope.alertNotifObject.email.value);
						$scope.notifTypeSelection.email = true;
						$scope.disabledClass.className = '';
					} else {
						$scope.disabledClass.className = 'disabled';
						$scope.notifTypeSelection.email = false;
					}
					if (notifType & $scope.bitConstants.notifType.ev) {
						$scope.addNotifType($scope.alertNotifObject.ev.label, $scope.alertNotifObject.ev.value);
						$scope.notifTypeSelection.ev = true;
					} else {
						$scope.notifTypeSelection.ev = false;
					}
					if (notifType & $scope.bitConstants.notifType.console) {
						$scope.addNotifType($scope.alertNotifObject.console.label, $scope.alertNotifObject.console.value);
						$scope.notifTypeSelection.console = true;
					} else {
						$scope.notifTypeSelection.console = false;
					}
					if (notifType & $scope.bitConstants.notifType.snmp) {
						$scope.addNotifType($scope.alertNotifObject.snmp.label, $scope.alertNotifObject.snmp.value);
						$scope.notifTypeSelection.snmp = true;
					} else {
						$scope.notifTypeSelection.snmp = false;
					}
					if ($scope.notifTypeSelection.email || $scope.notifTypeSelection.console) {
						//$scope.tabControls.selectTab(0);
					}
				};

				$scope.updateNotifTypesList();

				$scope.alertNotifIndividual = $scope.alertInfo.alert.status & $scope.bitConstants.sendIndividualAlert;

				$scope.getUsersInSelectFormat = function(usersList, type) {
					//Return list of objects to set values of To, Cc, Bcc user dropdowns.
					let formattedList = [];
					if (usersList && usersList.length > 0) {
						usersList.forEach(user => {
							formattedList.push({
								text: user.name,
								loginName: user.name,
								id: user.name,
								userInfoId: user.id1,
								type: type
							});
						});
					}
					return formattedList;
				};

				$scope.addUser = function(type) {
					let userList = [];
					['USER', 'COMMCELL_GROUP', 'EMAIL', 'EXTERNAL_GROUP'].forEach((userType, index) => {
						userList = userList.concat(
							$scope.getUsersInSelectFormat($scope.alertInfo[$scope.usersGroupsPropNames[index] + type], userType)
						);
					});
					return userList;
				};

				$scope.setSelectedUsers = function() {
					$scope.recipientTypesPropNames.forEach(type => {
						$scope['selectedFormatUsersList' + type] = $scope.addUser(type);
					});
				};
				$scope.setSelectedUsers(); //Get a list of all the selected "To", "Cc", and "Bcc" users to make them preselected on edit target modal.

				//Server return undefined for empty lists. Make it empty array to bind it with html so that in future it can be edited.
				$scope.updateUndefinedUserList = function(isEmpty = false) {
					$scope.recipientTypesPropNames.forEach(type => {
						$scope.usersGroupsPropNames.forEach(userProperty => {
							!isEmpty
								? ($scope.alertInfo[userProperty + type] = $scope.alertInfo[userProperty + type] || [])
								: ($scope.alertInfo[userProperty + type].length = 0);
						});
					});
				};

				$scope.updateUndefinedUserList();

				$scope.getUserList = function(type, label) {
					return {
						userList: $scope.alertInfo[$scope.usersGroupsPropNames[0] + type],
						userGroupList: $scope.alertInfo[$scope.usersGroupsPropNames[1] + type],
						nonGalaxyUserList: $scope.alertInfo[$scope.usersGroupsPropNames[2] + type],
						externalGroupList: $scope.alertInfo[$scope.usersGroupsPropNames[3] + type],
						label: label,
						showProperty: $scope['selectedFormatUsersList' + type].length > 0
					};
				};
				//List of users to show in TO, CC, and BCC tabs on details page.
				$scope.allUsersList = [];
				$scope.allUsersList.push($scope.getUserList($scope.recipientTypesPropNames[0], cvLoc('label.toUser')));
				$scope.allUsersList.push(
					$scope.getUserList($scope.recipientTypesPropNames[1], cvLoc('emailTemplates.label.cc'))
				);
				$scope.allUsersList.push(
					$scope.getUserList($scope.recipientTypesPropNames[2], cvLoc('emailTemplates.label.bcc'))
				);

				//originalTemplate used to store the template need to show in editor on template edit modal.
				$scope.originalTemplate = {
					html: null,
					text: null
				};
				if ($scope.notifTypeSelection.email) {
					$scope.originalTemplate.html = $scope.alertInfo.notifMsgs.find(msg => msg.notifType == 1).notifMessageHtml;
				}

				$scope.originalTemplate.json = $scope.notifTypeSelection.console
					? $scope.alertInfo.notifMsgs.find(msg => msg.notifType == 8192).notifMessageHtml
					: null;

				if ($scope.notifTypeSelection.ev) {
					$scope.originalTemplate.text = $scope.alertInfo.notifMsgs.find(msg => msg.notifType == 8).notifMessage;
				} else if ($scope.notifTypeSelection.snmp) {
					$scope.originalTemplate.text = $scope.alertInfo.notifMsgs.find(msg => msg.notifType == 4).notifMessage;
				}

				// check for empty strings
				$scope.alertInfo.alert.description = $scope.alertInfo.alert.description || cvLoc('severity.noData');
				$scope.alertInfo.alert.alertCategory.name =
					$scope.alertInfo.alert.alertCategory.name || cvLoc('severity.noData');
				$scope.alertInfo.alert.alertType.name = $scope.alertInfo.alert.alertType.name || cvLoc('severity.noData');
				$scope.alertInfo.alert.creator.name = $scope.alertInfo.alert.creator.name || cvLoc('severity.noData');

				$scope.serverGroupsList = [];
				$scope.serversList = [];
				if ($scope.alertDetail.isAllClientGroups) {
					$scope.serverGroupsList.push(cvLoc('label.allClientGroups'));
				}
				if ($scope.alertDetail.isAllClients) {
					$scope.serversList.push(cvLoc('label.allClients'));
				}
				if (
					$scope.alertDetail.xmlEntityList.associations != undefined &&
					$scope.alertDetail.xmlEntityList.associations.length > 0
				) {
					$scope.alertDetail.xmlEntityList.associations.forEach(item => {
						if (
							item.clientGroupId &&
							item.clientGroupName &&
							item.clientGroupName != '' &&
							$scope.serverGroupsList.indexOf(item.clientGroupName) < 0
						) {
							$scope.serverGroupsList.push(item.clientGroupName);
						} else if (
							item.clientId &&
							item.clientName &&
							item.clientName != '' &&
							$scope.serversList.indexOf(item.clientName) < 0
						) {
							$scope.serversList.push(item.clientName);
						}
					});
				}
				if ($scope.serverGroupsList.length == 0) {
					$scope.serverGroupsList.push(cvLoc('label.noServerGroupSelected'));
				}
				if ($scope.serversList.length == 0) {
					$scope.serversList.push(cvLoc('label.noServerSelected'));
				}

				if (
					!$scope.alertDetail ||
					!$scope.alertDetail.xmlEntityList ||
					!$scope.alertDetail.xmlEntityList.associations ||
					$scope.alertDetail.xmlEntityList.associations.length == 0
				) {
					$scope.noEntityListMessage = cvUtil.infoMsg(cvLoc('label.noEntityList'));
				} else {
					$scope.noEntityListMessage = cvUtil.infoMsg('');
				}
			})
			.error(function(e) {
				$scope.serverMessage = cvUtil.errMsg(cvLoc('error.alertInfoLoadError'));
			});

		$scope.toggleAlertNotifIndividual = function() {
			$scope.alertNotifIndividual = !$scope.alertNotifIndividual;
			alertDetailsService
				.updateIndividualNotifStatus($scope.alertInfo.alert.alert.id, $scope.alertNotifIndividual)
				.success(function(data) {
					if (data == '') {
						//Not refreshing the whole page. updating only the status property.
						if ($scope.alertNotifIndividual) {
							$scope.alertInfo.alert.status |= $scope.bitConstants.sendIndividualAlert; //Set bit to enable
						} else {
							$scope.alertInfo.alert.status &= ~$scope.bitConstants.sendIndividualAlert; //Reset bit to disable
						}
					} else {
						$scope.alertNotifIndividual = !$scope.alertNotifIndividual;
						cvToaster.showErrorMessage({
							ttl: '5000', //5 sec
							message: data
						});
					}
				})
				.error(function(e) {
					$scope.alertNotifIndividual = !$scope.alertNotifIndividual;
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: cvLoc('error.alertSaveError') + e
					});
				});
		};
	}
];

/*
 * Edit Alert Target Controller
 */
var targetModalController = [
	'$scope',
	'$log',
	'alertDetailsService',
	'alertUIFactory',
	'cvLoc',
	'cvUtil',
	'$uibModalInstance',
	'$state',
	'targetObj',
	function($scope, $log, alertDetailsService, alertUIFactory, cvLoc, cvUtil, $modalInstance, $state, targetObj) {
		$scope.targetObj = angular.copy(targetObj);

		$scope.alertNotifTypes = alertUIFactory.getAlertNotifTypes();
		alertUIFactory.updateNotifTypesAllowed($scope.alertNotifTypes, [], $scope.targetObj.selectedNotifTypes);

		$scope.isEditMode = true;
		$scope.alertNotifTypesError = {
			error: cvUtil.emptyMsg()
		};
		$scope.alertNotifObject = alertUIFactory.getAlertNotifObject();

		$scope.isEmailSelected = function() {
			return $scope.alertNotifTypes[$scope.alertNotifObject.email.index].selected;
		};

		$scope.isCASelected = function() {
			return $scope.alertNotifTypes[$scope.alertNotifObject.console.index].selected;
		};

		$scope.isAlertNotifError = function() {
			return alertUIFactory.isAlertNotifError($scope.alertNotifTypes, $scope.alertNotifTypesError);
		};

		setTimeout(function() {
			alertUIFactory.initializeAddUserSelect($scope.alertNotifTypesError);

			$('#toUserList').select2('data', $scope.targetObj.selectedFormatUsersList);
			$('#ccUserList').select2('data', $scope.targetObj.selectedFormatUsersListCc);
			$('#bccUserList').select2('data', $scope.targetObj.selectedFormatUsersListBcc);
		}, 1);

		$scope.cancelUsersModal = function() {
			$modalInstance.dismiss();
		};

		$scope.submitUsersModal = function() {
			$scope.alertTargetServerMessage = cvUtil.emptyMsg();
			if ($scope.isAlertNotifError()) {
				return;
			}

			if (!$scope.isEmailSelected()) {
				//Set users to NULL so that while fetching users it will return empty list instead of some preselected users
				$('#ccUserList').select2('data', null);
				$('#bccUserList').select2('data', null);

				if (!$scope.isCASelected()) {
					$('#toUserList').select2('data', null);
				}
			}

			if (($scope.isEmailSelected() || $scope.isCASelected()) && alertUIFactory.isUserListEmpty()) {
				$scope.alertNotifTypesError.error = cvUtil.errMsg(cvLoc('error.userListEmpty'));
				return;
			}
			let selectedNotifTypes = alertUIFactory.getSelectedNotifTypes($scope.alertNotifTypes);

			$scope.alertDef = {
				alertrule: { alertId: $scope.targetObj.alertId },
				notifType: selectedNotifTypes.selectedNotifTypes,
				recipientUserList: [],
				recipientUserGroupList: [],
				recipientadUserGroupList: [],
				nonGalaxyList: { nonGalaxyUserList: [] }
			};

			alertUIFactory.getUsers($scope.alertDef, $('#toUserList'), 'TO');
			alertUIFactory.getUsers($scope.alertDef, $('#ccUserList'), 'CC');
			alertUIFactory.getUsers($scope.alertDef, $('#bccUserList'), 'BCC');

			alertDetailsService
				.updateAlertTarget($scope.alertDef)
				.success(function(data) {
					if (data == '') {
						let selectedNotifTypes = alertUIFactory.getSelectedNotifTypes($scope.alertNotifTypes);
						$scope.alertDef.notifTypeNumber = selectedNotifTypes.notifTypeNumber;
						$modalInstance.close($scope.alertDef);
					} else {
						$scope.alertTargetServerMessage = cvUtil.errMsg(data);
					}
				})
				.error(function(e) {
					$scope.alertTargetServerMessage = cvUtil.errMsg(e === '' || e == null ? cvLoc('error.alertSaveError') : e);
				});
		};
	}
];

/*
 * Edit Alert Template Controller
 */
var templateModalController = [
	'$scope',
	'$log',
	'alertDetailsService',
	'definitionsService',
	'settingsService',
	'alertUIFactory',
	'cvLoc',
	'cvUtil',
	'$uibModalInstance',
	'targetObj',
	'ALERTS_SUPPORTED',
	function(
		$scope,
		$log,
		alertDetailsService,
		definitionsService,
		settingsService,
		alertUIFactory,
		cvLoc,
		cvUtil,
		$modalInstance,
		targetObj,
		ALERTS_SUPPORTED
	) {
		$scope.targetObj = angular.copy(targetObj);
		$scope.isEditMode = true;
		$scope.isConsoleTemplHTML = false;
		$scope.model = {
			emailSubject: { message: '' }
		};
		$scope.listeners = {
			ev: 'evText',
			console: 'consoleJson'
		};
		$scope.htmlTemplateActive = true;
		let isPrimaryTabSet = false;

		const hideKendoEditor = () => {
			return $scope.alerts.eventViewer.isActive || ($scope.alerts.console.isActive && !$scope.isConsoleTemplHTML);
		};

		$scope.locale = {
			alertLocaleList: [],
			lastSelectedLocaleName: $scope.targetObj.locale.localeName
		};
		settingsService
			.getLocalelist()
			.success(function(data) {
				$scope.locale.alertLocaleList = data;
				$scope.locale.alertLocaleList.forEach(locale => {
					//Currently Polish and English both have 0 as localeId. So only setting English as selected when localeId is 0.
					if (locale.localeId == $scope.targetObj.locale.localeID) {
						if (locale.localeId === 0 && locale.localeName === 'pl') {
							return;
						}
						locale.selected = true;
						$scope.locale.lastSelectedLocaleName = locale.localeName;
					}
				});
				$scope.alertTemplateServerMessage = cvUtil.emptyMsg();
			})
			.error(function(e) {
				$scope.alertTemplateServerMessage = cvUtil.errMsg(e === '' || e == null ? cvLoc('error.alertLocaleload') : e);
			});
		$scope.alertLocaleChange = function() {
			alertUIFactory.alertLocaleChange($scope.locale, function() {
				$scope.getTemplate(true);
			});
		};

		$scope.alertNotifTypes = alertUIFactory.getAlertNotifTypes();
		alertUIFactory.updateNotifTypesAllowed($scope.alertNotifTypes, [], $scope.targetObj.selectedNotifTypes);
		$scope.alertNotifObject = alertUIFactory.getAlertNotifObject();

		$scope.isEmailSelected = function() {
			return $scope.alertNotifTypes[$scope.alertNotifObject.email.index].selected;
		};
		$scope.isCASelected = function() {
			return $scope.alertNotifTypes[$scope.alertNotifObject.console.index].selected;
		};
		$scope.isEVSelected = function() {
			return $scope.alertNotifTypes[$scope.alertNotifObject.ev.index].selected;
		};

		$scope.alerts = {
			email: {
				isActive: false,
				isSelected: $scope.isEmailSelected,
				template: '',
				getActiveTemplate: function() {
					this.template = this.isActive ? $scope.editor.textEditor.getText() : this.template;
					return this.template;
				}
			},
			console: {
				isActive: false,
				isSelected: $scope.isCASelected,
				template: '',
				getActiveTemplate: function() {
					this.template = $scope.isConsoleTemplHTML
						? this.isActive
							? $scope.editor.textEditor.getText()
							: this.template
						: this.template;
					return this.template;
				}
			},
			eventViewer: {
				isActive: false,
				isSelected: $scope.isEVSelected,
				template: ''
			}
		};

		Object.keys($scope.alerts).forEach(function(alert) {
			if ($scope.alerts[alert].isSelected() && !isPrimaryTabSet) {
				$scope.alerts[alert].isActive = true;
				$scope.currentActive = alert;
				isPrimaryTabSet = true;
			}
		});

		$scope.tokenSelected = function(selectedToken) {
			if (selectedToken) {
				const sendToListener = $scope.alerts.console.isActive ? $scope.listeners.console : $scope.listeners.ev;
				$scope.$broadcast(sendToListener, selectedToken);
			}
		};

		$scope.updateNotifTemplates = function(isLocaleChange) {
			if ($scope.isEmailSelected()) {
				//If locale is not changed, set value to empty so that it can be set to default html value later.
				$scope.alerts.email.template =
					!isLocaleChange && $scope.targetObj.notifMsgs.html
						? $scope.targetObj.notifMsgs.html
						: $scope.defaultHTMLTemplate;
			}

			if (
				$scope.alertNotifTypes[$scope.alertNotifObject.ev.index].selected ||
				$scope.alertNotifTypes[$scope.alertNotifObject.snmp.index].selected
			) {
				$scope.alerts.eventViewer.template =
					!isLocaleChange && $scope.targetObj.notifMsgs.text
						? $scope.targetObj.notifMsgs.text
						: $scope.defaultTextTemplate;
			}

			if ($scope.alertNotifTypes[$scope.alertNotifObject.console.index].selected) {
				const consoleTemplate =
					!isLocaleChange && $scope.targetObj.notifMsgs.json
						? $scope.targetObj.notifMsgs.json
						: $scope.defaultJSONTemplate;

				$scope.alerts.console.template = consoleTemplate;
				const parsedConsoleJson = alertUIFactory.verifyJSON(consoleTemplate);
				if (parsedConsoleJson) $scope.alerts.console.template = parsedConsoleJson;
				else $scope.isConsoleTemplHTML = true;
			}
		};

		$scope.getTemplate = function(isLocaleChange = false) {
			let localeId =
				$scope.locale.selectedLocale && $scope.locale.selectedLocale.length
					? $scope.locale.selectedLocale[0].localeId
					: $scope.targetObj.locale.localeID;

			definitionsService
				.getDefaultTemplateAndTokenList($scope.targetObj.alertTypeId, $scope.targetObj.alertCriteriaId, localeId)
				.success(function(data) {
					let result = alertUIFactory.getTemplatesAndTokensFromResp(data);
					if (result == null) {
						$scope.alertTemplateServerMessage = cvUtil.errMsg(cvLoc('error.templateTokenError'));
					}
					$scope.tokensList = result.tokenList;
					$scope.defaultTextTemplate = result.defaultTextTemplate;
					$scope.defaultHTMLTemplate = result.defaultHTMLTemplate;
					$scope.defaultJSONTemplate = result.defaultJSONTemplate;
					$scope.subjectBeginTokenFormat = result.subjectBeginTokenFormat;
					$scope.subjectEndTokenFormat = result.subjectEndTokenFormat;

					if ($scope.alerts.eventViewer.isSelected() || $scope.alerts.console.isSelected())
						$scope.tokens = $scope?.tokensList?.length ? $scope.tokensList : [];
					$scope.updateNotifTemplates(isLocaleChange);

					$scope.hideKendoEditor = hideKendoEditor();
					if ($scope.isEmailSelected()) {
						if ($scope.alerts.email.template === '') {
							$scope.alerts.email.template = result.defaultHTMLTemplate;
							$scope.model.emailSubject.message = result.emailSubject;
						} else {
							let res = alertUIFactory.getEmailSubjectAndBody(
								$scope.alerts.email.template,
								$scope.subjectBeginTokenFormat,
								$scope.subjectEndTokenFormat
							);
							$scope.alerts.email.template = res.body;
							$scope.model.emailSubject.message = result.emailSubject;
						}
					}

					if (isLocaleChange) {
						$scope.editor.textEditor.setTokens(alertUIFactory.processTokens($scope.tokensList));
						if (!$scope.hideKendoEditor) $scope.editor.textEditor.setText($scope.alerts[$scope.currentActive].template);
					}

					if (!isLocaleChange) startEditor();
				})
				.error(function(e) {
					$scope.alertTemplateServerMessage = cvUtil.errMsg(
						e === '' || e == null ? cvLoc('error.templateTokenError') : e
					);
				});
		};

		$scope.getTemplate();
		function startEditor() {
			// starts the editor after the end of the digest cycle
			let watch = $scope.$watch(undefined, function() {
				// Wait for the end of the digest cycle for the ng-if to render
				if ($('#cv-editor')[0]) {
					watch(); // unregister the watch
					// retrieve the template and render the text editor
					$scope.htmlTemplateActive = $scope.isEmailSelected();
					alertUIFactory.startEditor(
						$scope.editor,
						$scope.tokensList,
						!$scope.hideKendoEditor ? $scope.alerts[$scope.currentActive].template : '',
						$scope.hideKendoEditor
					);
				}
			});
		}

		$scope.editor = {
			textEditor: null,
			textEditorTemplate: null
		};
		$scope.viewTemplate = function(alertType) {
			if (alertType && alertType !== $scope.currentActive) {
				if (!$scope.hideKendoEditor) $scope.alerts[$scope.currentActive].template = $scope.editor.textEditor.getText();
				Object.keys($scope.alerts).forEach(function(aType) {
					$scope.alerts[aType].isActive = alertType === aType;
					if ($scope.alerts[aType].isActive) {
						$scope.currentActive = aType;
					}
				});
				$scope.hideKendoEditor = hideKendoEditor();
				if (!$scope.hideKendoEditor) {
					alertUIFactory.enableToolbar();
					$scope.editor.textEditor.setText($scope.alerts[$scope.currentActive].template);
				}
			}
		};

		$scope.cancelTemplateModal = function() {
			$modalInstance.dismiss();
		};

		$scope.submitTemplateModal = function() {
			$scope.alertTemplateServerMessage = cvUtil.emptyMsg();

			//check if editor text is safe before proceeding to save.
			if ($scope.isEmailSelected() && $scope.editor.textEditor.isTextSecure() === false) {
				$scope.alertTemplateServerMessage = cvUtil.errMsg(
					cvLoc('error.alertSaveError') + ' ' + cvLoc('editor.msg.error.unsecureEditorText')
				);
				return;
			}

			if (
				$scope.isCASelected() &&
				!$scope.isConsoleTemplHTML &&
				!alertUIFactory.verifyJSON($scope.alerts.console.template)
			)
				return;
			let resTemplate = {
				//use resTemplate instead of $scope.alertDef to pass un-encoded content on success
				html:
					$scope.subjectBeginTokenFormat +
					$scope.model.emailSubject.message +
					$scope.subjectEndTokenFormat +
					$scope.alerts.email.getActiveTemplate(),
				text: $scope.alerts.eventViewer.template,
				json: $scope.isConsoleTemplHTML
					? $scope.alerts.console.getActiveTemplate()
					: $scope.alerts.console.template.replace(/^\s+|\s+$/g, ''),
				locale: {
					localeID: $scope.locale.selectedLocale[0].localeId,
					localeName: $scope.locale.selectedLocale[0].localeName
				}
			};
			$scope.alertDef = {
				alertrule: { alertId: $scope.targetObj.alertId },
				locale: resTemplate.locale,
				alertContent: {
					htmlMessage: encodeURIComponent(resTemplate.html),
					textMessage: encodeURIComponent(resTemplate.text),
					jsonMessage: encodeURIComponent(resTemplate.json)
				}
			};

			alertDetailsService
				.updateAlertTemplate($scope.alertDef)
				.success(function(data) {
					if (data == '') {
						$modalInstance.close(resTemplate);
					} else {
						$scope.alertTemplateServerMessage = cvUtil.errMsg(data);
					}
				})
				.error(function(e) {
					$scope.alertTemplateServerMessage = cvUtil.errMsg(e === '' || e == null ? cvLoc('error.alertSaveError') : e);
				});
		};
	}
];

/*
 * Edit Alert Entities Controller
 */
var entitiesModalController = [
	'$scope',
	'alertDetailsService',
	'alertUIFactory',
	'cvEntitySelectionTreeComponent',
	'cvLoc',
	'cvUtil',
	'$uibModalInstance',
	'targetObj',
	'$state',
	function(
		$scope,
		alertDetailsService,
		alertUIFactory,
		cvEntitySelectionTreeComponent,
		cvLoc,
		cvUtil,
		$modalInstance,
		targetObj,
		$state
	) {
		$scope.targetObj = angular.copy(targetObj);
		$scope.isEditMode = true;
		$scope.alertEntitiesServerMessage = cvUtil.emptyMsg();
		$scope.isTenantAdmin = cv.isTenantAdmin;
		$scope.preSelectedList = $scope.targetObj.preSelectedList; //preSelectedList is used to make the entities pre selected when entities modal is opened for edit
		$scope.alertDetails = {
			//These variables ar eused in Entities jsp.
			selEntityList: [],
			alertCriteria: {
				alertType: $scope.targetObj.alertType
			}
		};
		$scope.selectedAlert = {
			alertId: '',
			isVM: false
		};
		$scope.treeParams = {
			initialSelections: [],
			initialExclusions: [],
			result: {},
			mode: 'edit',
			noExclusions: true,
			hideIndexAnalytics: true,
			isShowSelectedByDefault: true
		};
		_.assignIn($scope.treeParams, cvEntitySelectionTreeComponent.populateTreeParams($scope.preSelectedList.entityList));
		$scope.treeParams.isNodeApplicable = function(node) {
			if (node.entity.entityTypeName == 'CLIENT_ENTITY') {
				//remove this after mongo filter for server gets fixed
				if (
					_.includes(node.entity.clientName, 'IndexServer') ||
					_.includes(node.entity.clientName, 'AnalyticsServer')
				) {
					// Workaround for avoiding Index Server and Analytic Servers coming due to Mongo issue
					return false;
				}
				node.noChild = false;
				node.childrenLoaded = false;
			}
			if (node.entity.entityTypeName == 'CLIENT_GROUP_ENTITY' || node.entity.entityTypeName == 'SUBCLIENT_ENTITY') {
				node.noChild = true;
				node.childrenLoaded = true;
			}
			return true;
		};
		//Need to do it in timeout to make old vaue and new value different in directive so that it can load the tree
		setTimeout(function() {
			$scope.selectedAlert = {
				alertId: $scope.targetObj.alertType,
				isVM: $scope.targetObj.isVM
			};
		}, 1);
		$scope.cancelEntitiesModal = function() {
			$modalInstance.dismiss();
		};

		$scope.submitEntitiesModal = function() {
			let associations = [];
			associations = cvEntitySelectionTreeComponent.getAssociations($scope.treeParams);

			$scope.alertEntitiesServerMessage = cvUtil.emptyMsg();
			$scope.alertDef = {
				alertrule: {
					alertId: $scope.targetObj.alertId
				},
				EntityList: {
					associations: associations
				}
			};

			alertDetailsService
				.updateAlertEntities($scope.alertDef)
				.success(function(data) {
					if (data == '') {
						$modalInstance.dismiss();
						$state.forceReload();
					} else {
						$scope.alertEntitiesServerMessage = cvUtil.errMsg(data);
					}
				})
				.error(function(e) {
					$scope.alertEntitiesServerMessage = cvUtil.errMsg(e === '' || e == null ? cvLoc('error.alertSaveError') : e);
				});
		};
	}
];

/*
 * Filters and Directives specific to Alerts
 */
alertsMod.filter('substring', function() {
	return function(str, start, end) {
		return str.substring(start, end);
	};
});

alertsMod.directive('onKeyup', function() {
	return function(scope, elm, attrs) {
		elm.bind('keyup', function() {
			scope.$apply(attrs.onKeyup);
		});
	};
});

alertsMod.directive('getData', [
	'cvLoc',
	function(cvLoc) {
		return {
			restrict: 'C',
			replace: true,
			transclude: true,
			scope: {
				myData: '@myData',
				myLabel: '@'
			},
			template:
				'<div class="severity-level">' +
				'<div title="{{myLabel}}" data-ng-class="{critical: myData==1, major: myData==2, info: myData==3}">{{myLabel}}</div>' +
				'</div>'
		};
	}
]);

alertsMod.filter('bitwiseAnd', function() {
	return function(firstNumber, secondNumber) {
		return (parseInt(firstNumber, 10) & parseInt(secondNumber, 10)) === parseInt(secondNumber, 10);
	};
});

alertsMod.directive('getPinInfo', function() {
	return {
		restrict: 'C',
		replace: true,
		transclude: true,
		scope: {
			myData: '@myData'
		},
		template:
			'<div>' +
			'<span ng-show="myData | bitwiseAnd : 2"><div class="pinDiv pinned pinIconSelector"><span class="redPin"  title="Unpin"></span></div></span>' +
			'<span ng-show="!(myData | bitwiseAnd : 2)"><div class="pinDiv unpinned pinIconSelector"><span class="blackPin" title="Pin"></span></div></span>' +
			'</div>'
	};
});

alertsMod.controller(controllers);

export default alertsMod;
