import 'modules/alerts/js/factories/alertUI.factory.js';
import { cvModuleAlertsModule } from 'common/js/modules';
import CvWizard from 'common/js/directives/cv-wizard/cvWizard.js';

var appModule = cvModuleAlertsModule;

class AddAlertStepTargetController {
	static $inject = ['$scope', 'cvUtil', 'cvLoc', 'alertUIFactory'];
	constructor($scope, cvUtil, cvLoc, alertUIFactory) {
		const model = $scope.$cvWizardStepInstance.getModel();
		$scope.alertDetails = model.alertDetails;
		$scope.alertNotifTypesError = model.alertNotifTypesError;
		$scope.alertNotifTypes = model.alertNotifTypes;
		$scope.alertNotifObject = model.alertNotifObject;
		$scope.isWizard = true;

		setTimeout(function() {
			alertUIFactory.initializeAddUserSelect(model.alertNotifTypesError);
		}, 1000);

		$scope.isAlertNotifError = function() {
			return alertUIFactory.isAlertNotifError(model.alertNotifTypes, model.alertNotifTypesError);
		};

		$scope.isEmailSelected = function() {
			return model.alertNotifTypes[model.alertNotifObject.email.index].selected;
		};

		$scope.isCASelected = function() {
			return model.alertNotifTypes[model.alertNotifObject.console.index].selected;
		};

		$scope.$cvWizardStepInstance.on(CvWizard.EVENT.NEXT, event => {
			// On next step
			$scope.serverMessage = cvUtil.emptyMsg();
			if (!$scope.isAlertNotifError()) {
				if (($scope.isEmailSelected() || $scope.isCASelected()) && alertUIFactory.isUserListEmpty()) {
					model.alertNotifTypesError.error = cvUtil.errMsg(cvLoc('error.userListEmpty'));
					event.preventDefault();
					return;
				}
			}
			model.alertNotifTypesError.error = cvUtil.emptyMsg();
		});
	}
}

appModule.controller('addAlertStepTargetController', AddAlertStepTargetController);

export default appModule;
