import { acAppRestAPIOverviewModule } from 'common/js/modules';
import 'modules/RESTOverview/js/services/restAPIConfiguration.svc.js';
import 'modules/servers/js/services/servers.svc.js';

class restAPIOverviewController {
	constructor(
		$scope,
		tabService,
		cvBreadcrumbsTabsFactory,
		cvLoc,
		serverService,
		restAPIConfigurationService,
		$state,
		cvToaster
	) {
		this.$scope = $scope;
		this.tabService = tabService;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.cvLoc = cvLoc;
		this.serverService = serverService;
		this.restAPIConfigurationService = restAPIConfigurationService;
		this.$state = $state;
		this.cvToaster = cvToaster;

		this._initializeBreadCrumbs();
		this._initializeModels();
	}

	_initializeBreadCrumbs() {
		let breadCrumbs = [];

		breadCrumbs.push({
			title: this.cvLoc('label.nav.developerTools'),
			link: '#/developerTools'
		});

		this.cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}

	_initializeModels() {
		let self = this;
		this.serverService
			.getGlobalParam('nRestApiLog', true)
			.success(data => {
				self.isReportEnabled = parseInt(data) > 0;
			})
			.error(err => {
				self.cvToaster.showErrorMessage({
					message: err,
					ttl: '5000'
				});
			});
	}

	enableReports(disableFlag) {
		let self = this;
		let digitalValue = disableFlag ? 0 : 1;
		this.restAPIConfigurationService
			.setLogMonitoringStatus(digitalValue)
			.success(data => {
				self.$state.forceReload();
			})
			.error(err => {
				self.$state.forceReload();
				self.cvToaster.showErrorMessage({
					ttl: '5000',
					message: err.errorMessage
				});
			});
	}
}

restAPIOverviewController.$inject = [
	'$scope',
	'tabService',
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	'serverService',
	'restAPIConfigurationService',
	'$state',
	'cvToaster'
];

acAppRestAPIOverviewModule.controller('restAPIOverviewController', restAPIOverviewController);

export default acAppRestAPIOverviewModule;
