<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<!--[if lt IE 10]><html class="no-js lt-ie10"> <![endif]-->
<!--[if gte IE 10]><html class="no-js"><![endif]-->
<!--[if !IE]><!-><html class="no-js"><!--<![endif]-->
    <jsp:include page="loginHeader.jsp"></jsp:include>
    <body class="login-page" data-ng-app="acApp.login.sso">
    	<noscript>
    		<div class="js-disabled">
        		<p class="js-disabled-message"><cv:msg key="label.enableJavaScript" bundle="messagesJs" /></p>
    		</div>
		</noscript>
        <section class="main">
        <div class="center-container">
       		<div class="center-container__center-el">
		    <div class="center-el__center-block">
		    <div><img src="${pageContext.request.contextPath}/common/img/adminConsoleLogo.png"></img></div>
		    <div class="logo-lock-up">AdminConsole</div>
		    <div class="error" ng-class="{'show-error':'${requestScope.LOGIN_MESSAGE}' }">${requestScope.LOGIN_MESSAGE}</div>
		    <form action="{{loginAction}}" autocomplete="off" method="POST" class="login-form group" ng-controller="ssoController" ng-submit="submit()">
		    	<div class="no-margin {{serverMessage.type}}" data-ng-bind="serverMessage.message"></div>
				   <div class="commcellSSO">
		  		  		<div class="clear-float">&nbsp;</div>
		  		  		<span id="fetchingCommcellSSORedirectUrl"><cv:msg key="label.attemptingSSOLogin" bundle="messagesJs" /></span>
		  		  		<span id="commcellSSOMessages">
							<span class="commcellSSORedirectUrlList"></span>
							<span>
								<a id="dismissCommcellSSO" ng-click="disableCommcellSSOAttempt(true)"><cv:msg key="label.cancel" bundle="messagesJs" /></a>
							</span>
						</span>
		  		  </div>
				  <input type="text" id="username" name="username" placeholder='<cv:msg key="label.userNameOrEmail" bundle="messagesJs" />' autofocus ng-model="userName" ng-keydown="userNameChanged($event)" required><br>
				  <div class="commcellSSOHiddenFields" data-ng-disabled="prepareForCommcellSSO">
					  <input type="password" id="password" name="password" placeholder='<cv:msg key="label.password" bundle="messagesJs" />' autocomplete="off" ng-click="attemptCommcellSSO()"><br>
	 				  <c:set var="baseUrlClass" value="devMode" />
					  <c:if test="${requestScope.appNotInitialized == true}">
					  	<div class="error" ng-class="{'show-error':'AppNotInitialized' }">Note: Enter webserver domain or baseUrl to connect (App is not yet initialized). Use admin account for first login.</div>
	 					<c:set var="baseUrlClass" value="" />
					  </c:if>
					  <c:if test="${applicationScope.noInitialBaseUrl == true}">
						  <c:set var="baseUrlClass" value=""></c:set>
					  </c:if>
					  <div class="${baseUrlClass} dropdown">
					  		<input type="text" name="webServiceUrl" data-ng-model="webServiceUrl" placeholder='<cv:msg key="label.webserviceUrl" bundle="messagesJs" />'
						  		data-uib-typeahead="url for url in webConsoleHosts | filter:$viewValue" data-typeahead-min-length="0" data-typeahead-editable="true" data-typehead-focus-first="false" /><br>
					  </div>
					  <c:if test="${applicationScope.noInitialBaseUrl == true}">
						  <div class="additionalSettingsDiv"  ng-model="collapsed" ng-click="collapsed=!collapsed" >Additional settings &#9660;</div>
						  <textarea id="additionalSettings" name="additionalSettings" ng-show="collapsed" data-ng-model="additionalSettings" placeholder="Add additional settings here (Optional). Will be used with a Webserver URL above during initialization." rows="3" cols="33"></textarea>
					  </c:if>

					  <input type="hidden" name="requestedFrag" id="requestedFrag">
	                  <input name="rememberMe" id="rememberMe" value="false" type="checkbox" ><label for="rememberMe" class="remember-me-label"><cv:msg key="label.keepMeLoggedIn" bundle="messagesJs" /></label>
	                  <input type="submit" value="Login" class="submit btn btn-primary-flat" data-ng-class="{true:'busy'}[loading]">
	                  <a class="remember-me-label" href="${pageContext.request.contextPath}/login/forgotPassword.jsp"><cv:msg key="forgotPassword" bundle="messagesJs" />?</a>
                  </div>
				  <div id="ssoMessage" style="display:none">
				  		<div class="clear-float">&nbsp;</div>
				  		<font color="red" style="float: left"><cv:msg key="label.attemptingSSOLogin" bundle="messagesJs" />&nbsp;&nbsp;<a ng-click="cancelSSO()"><cv:msg key="label.cancel" bundle="messagesJs" /></a></font>
			  	  </div>
				  <div class="cvAccountsMessages" id="cvAccountsSSOMessages">
				  		<div class="clear-float">&nbsp;</div>
				  		<span id="cvAccountsFetchingSSOSiteURL"><cv:msg key="label.cvAccounts.fetchingSSOServerDetails" bundle="messagesJs" /></span>
				  		<span class="ellipsis-content" id="cvAccountsSSOSuccessMessage"><cv:msg key="label.cvAccounts.redirectingToSSOServer" bundle="messagesJs" /></span>
				  		<br><span class="ellipsis-content ellipsis-parent" id="cvAccountsSSOServerName"></span><br>
				  		<a id="dismissCVAccountsSSO" ng-click="disableCvAccountsAttempt()"><cv:msg key="label.cancel" bundle="messagesJs" /></a>
		  		  </div>
				</form>
		    </div>
		  </div>
		              <!-- add Content here -->
		</div>
		</section>
		<script nonce="${sessionScope.cspNonce}" >
    	var ssoUserName = '${sessionScope.REQUEST_USER_NAME}';
    	var isCvAccountsEnabled = '${applicationScope.isCvSSOEnabled}';
    	var disableCvAccountsSSORedirect = '${fn:escapeXml(param.disableSSORedirect)}';
    	var isCommcellSSOEnabled = "${applicationScope.isCommcellSSOEnabled}"
    	var isConsoleSSOEnabled = "${applicationScope.isConsoleSSOEnabled}"
		</script>
		<jsp:include page="loginFooter.jsp"></jsp:include>
    </body>
</html>
