(function() {
	'use strict';
	var app = angular.module('acApp.registration');

	app.service('registrationService', [
		'$http',
		'cvUtil',
		function($http, cvUtil) {
			function getConfig() {
				var config = {};
				config.headers = {};
				var csrfParam = cvUtil.readCookie('csrf');
				config.headers['csrf'] = csrfParam;
				config.headers['Content-Type'] = 'application/x-www-form-urlencoded;charset=utf-8;';
				config.headers['X-Requested-With'] = 'XMLHttpRequest';
				return config;
			}

			this.registerAndLinkCommcell = function(registrationInformation) {
				var config = getConfig();
				return $http.post('registerAndLinkCommCell.do', $.param(registrationInformation), config);
			};

			this.isCommcellRegistered = function() {
				var config = getConfig();
				return $http.get('isCommCellRegistered.do', config);
			};

			this.getOemId = function() {
				var config = getConfig();
				return $http.get('getOemId.do', config);
			};

			this.getCountries = function() {
				var config = getConfig();
				return $http.get('getCountries.do', config);
			};
		}
	]);
})();
