(function() {
	'use strict';

	angular.module('acApp.login.sso').service('loginService', [
		'$http',
		'cvUtil',
		'httpWrapper',
		function($http, cvUtil, httpWrapper) {
			this.getDomainsForSSO = function(data) {
				return httpWrapper.get('isDomainValidForSSO.do', {
					params: {
						userName: data.ssoUserName
					}
				});
			};

			this.getCvAccountsSSOSiteURL = function(data) {
				return httpWrapper.get('getCVAccountsSSOSiteUrl.do');
			};

			this.getCommcellSSOServerUrls = function(username) {
				var config = getConfig();
				return httpWrapper.post(
					'getIDPSSORedirectUrl.do',
					$.param({
						username: username
					}),
					config
				);
			};

			this.commcellSSOLogin = function(params) {
				return httpWrapper.get('commcellSSOLogin.do', {
					params: params
				});
			};

			function getConfig() {
				var config = {};
				config.headers = {};
				var csrfParam = cvUtil.readCookie('csrf');
				config.headers['csrf'] = csrfParam;
				config.headers['Content-Type'] = 'application/x-www-form-urlencoded;charset=utf-8;';
				config.headers['X-Requested-With'] = 'XMLHttpRequest';
				return config;
			}
			this.forgotPassword = function(username) {
				var config = getConfig();
				return httpWrapper.post(
					'forgotPassword.do',
					$.param({
						username: username
					}),
					config
				);
			};

			this.resetPassword = function(token, password) {
				var config = getConfig();
				return httpWrapper.post(
					'resetPassword.do',
					$.param({
						token: token,
						password: password
					}),
					config
				);
			};
		}
	]);
})();
