(function() {
	'use strict';
	var app = angular.module('acApp.registration', ['cvCommon']);

	app.controller('productRegistrationController', [
		'$scope',
		'cvLoc',
		'cvUtil',
		'REGEX',
		'$window',
		'cvToaster',
		'registrationService',
		function($scope, cvLoc, cvUtil, REGEX, $window, cvToaster, registrationService) {
			function resetRegisteredInformation() {
				$scope.registrationInformation = {
					emailAddress: '',
					password: []
				};
				$scope.passwordField = {
					password: '',
					confirmPassword: ''
				};
			}
			resetRegisteredInformation();

			var redirectToLogin = function() {
				$window.location.href = 'loginForm.do';
			};

			if (cvApp.globalParams.firstAccountCreated === '1') {
				redirectToLogin();
			}
			$scope.registerAndLinkCommcell = function() {
				$scope.model.serverMessage.message = cvLoc('label.processing');
				$scope.model.serverMessage.type = 'ok';
				$scope.model.isProcessing = true;

				//When CreateNewAccount.jsp is used, registrationInformation needs to be populated using model for cvCredential directive
				$scope.passwordField.password = $scope.model.password;
				$scope.registrationInformation.emailAddress = $scope.model.username;

				$scope.registrationInformation.password = cvUtil.getBytes($scope.passwordField.password);

				registrationService
					.registerAndLinkCommcell({
						registrationInfo: angular.toJson($scope.registrationInformation)
					})
					.then(
						function(response) {
							setTimeout(redirectToLogin, 1000);
							$scope.model.isProcessing = false;
						},
						function(errorMessage) {
							$scope.model.isProcessing = false;
							$scope.model.serverMessage = errorMessage.data
								? cvUtil.errMsg(errorMessage.data)
								: cvLoc('generic_error');
						}
					);
			};

			$scope.userNameInfo = {
				label: cvLoc('label.cloudEmail'),
				requiredError: cvLoc('error.validEmailAddress'),
				type: 'Email',
				passwordLabel: cvLoc('label.newPassword')
			};

			$scope.needsAttention = function(inputElement) {
				return inputElement.$touched && inputElement.$invalid && !inputElement.pristine;
			};

			$scope.model = {
				emailPattern: REGEX.EMAIL,
				isProcessing: false,
				serverMessage: {
					type: '',
					message: ''
				}
			};
		}
	]);

	app.directive('setupSteps', [
		'$timeout',
		function($timeout) {
			return {
				link: function(scope, elem, attr) {
					$timeout(function() {
						var steps = parseInt(attr.setupSteps);
						if (isFinite(steps)) {
							var percent = 100 / steps;
							percent = Math.round(percent * 100) / 100;
							elem.find('li').width(percent + '%');
						}
					});
				}
			};
		}
	]);
})();
