(function() {
	'use strict';

	var ssoLoginMod = angular.module('acApp.login.sso', ['cvCommon', 'ui.bootstrap']);

	ssoLoginMod.config(function() {});

	var controllers = {};
	var injection = {};
	injection.ssoController = ['$scope', '$http', 'loginService', 'cvUtil', '$window', '$document', 'cvLoc'];
	controllers.ssoController = function($scope, $http, loginService, cvUtil, $window, $document, cvLoc) {
		if (isConsoleSSOEnabled === 'true' && disableCvAccountsSSORedirect !== 'true') {
			$window.location = 'wcSSO.do';
		}
		$scope.prepareForCommcellSSO = false;
		$scope.userName = '';
		$scope.loginAction = 'login.do';
		$scope.ssoTimer = null;
		$scope.ssoTimerExpire = 3000;
		$scope.xxx = cvUtil.emptyMsg();
		$scope.loading = false;
		var encoded = false;
		$scope.submit = function() {
			$scope.loading = true;
			if ($scope.webServiceUrl && $scope.webConsoleHosts.indexOf($scope.webServiceUrl) === -1) {
				$scope.webConsoleHosts.push($scope.webServiceUrl);
			}
			cvUtil.writeCookie('webConsoleHosts', JSON.stringify($scope.webConsoleHosts));
			$('#requestedFrag').val(window.location.hash);
			if (!encoded) {
				$('#password').val(Base64.encode($('#password').val()));
				encoded = true;
			}
		};

		$scope.webConsoleHosts = JSON.parse(cvUtil.readCookie('webConsoleHosts') || '[]');

		$scope.serverMessage = {
			message: '',
			type: ''
		};

		var cvAccountsSSOAttemptDismissed = false;
		var cvAccountsSSOWaitForUserActionTimer = null;

		var isCvAccountsSSOEnabled = function() {
			return isCvAccountsEnabled === 'true' && disableCvAccountsSSORedirect !== 'true';
		};

		if (isCvAccountsSSOEnabled()) {
			angular.element('#cvAccountsSSOMessages').show();
			angular.element('#cvAccountsSSOSuccessMessage').hide();
			angular.element('#cvAccountsFetchingSSOSiteURL').show();
			angular.element('form input').attr('disabled', 'disabled');
			loginService
				.getCvAccountsSSOSiteURL()
				.success(function(data) {
					angular.element('#cvAccountsFetchingSSOSiteURL').hide();
					if (data && data.ssoServerName && data.cvAccountsSSOUrl && !cvAccountsSSOAttemptDismissed) {
						$scope.loading = true;
						var serverDetails = data;
						serverDetails.serverStatus = {
							isReachable: false,
							errorString: ''
						};
						serverDetails.waitForServerResponseTimer = null;
						//isRemoteServerReachable(serverDetails);
						angular.element('#cvAccountsSSOSuccessMessage').show();
						angular.element('#cvAccountsSSOServerName').show();
						angular.element('#cvAccountsSSOServerName').append(serverDetails.ssoServerName);
						serverDetails.waitForServerResponseTimer = setTimeout(function() {
							redirectToCvAccountsServer(serverDetails);
						}, 2000);
					} else {
						if (!cvAccountsSSOAttemptDismissed) {
							console.error('missing cvaccounts sso site url.pls contact your administrator');
							$scope.disableCvAccountsAttempt(cvLoc('error.cvAccounts.cannotProceed'));
						} else {
							angular.element('form input')[0].focus();
						}
					}
				})
				.error(function(err) {
					$scope.disableCvAccountsAttempt(cvLoc('error.cvAccounts.cannotProceed'));
				});
		} else {
			loginService
				.getDomainsForSSO({
					ssoUserName: ssoUserName
				})
				.success(function(data) {
					$scope.myData = data;
					$scope.serverMessage = '';
					$scope.totalAlerts = data.length;

					// this will contain binary saying if sso enabled for this domain.
					var resp = data.isDomainValidForSSO;
					if (resp == true) {
						angular.element('#ssoMessage').show();
						$scope.userName = data.domain + '\\' + data.userName;
						$scope.loginAction = 'ssoLogin.do';
						angular.element('form input').attr('disabled', 'disabled');
						$scope.ssoTimer = setTimeout(function() {
							angular.element('form').submit();
							angular.element('#ssoMessage').hide();
						}, $scope.ssoTimerExpire);
					} else {
					}
				})
				.error(function(e) {
					angular.element('#ssoMessage').hide();
					angular.element('form input').removeAttr('disabled');
					$scope.serverMessage = {
						message: cvLoc('error.loadSsoDomainFail'),
						type: 'error'
					};
				});
		}

		$scope.cancelSSO = function() {
			$scope.loginAction = 'login.do';
			clearTimeout($scope.ssoTimer);
			$scope.userName = '';
			angular.element('form input').removeAttr('disabled');
			angular.element('#ssoMessage').hide();
		};

		$scope.disableCvAccountsAttempt = function(errorString) {
			$scope.loading = false;
			cvAccountsSSOAttemptDismissed = true;
			if (errorString != undefined && errorString.length > 0) {
				$scope.serverMessage = {
					message: errorString,
					type: 'error'
				};
			}
			clearTimeout(cvAccountsSSOWaitForUserActionTimer);
			angular.element('form input').removeAttr('disabled');
			angular.element('#cvAccountsSSOMessages').hide();
			angular.element('form input')[0].focus();
			setTimeout(function() {
				$scope.$apply();
			}, 3);
		};

		var isRemoteServerReachable = function(serverDetails) {
			var xhr = new XMLHttpRequest();
			xhr.open('GET', serverDetails.ssoServerName + 'api/?cvAccountsRemoteServerPing=true', true);
			xhr.timeout = cvAccountsServerPingTimeout;
			xhr.ontimeout = function() {
				serverDetails.serverStatus.isReachable = false;
				serverDetails.serverStatus.errorString = cvLoc('error.cvAccounts.serverConnectionFailed');
				takeImmediateAction();
				return;
			};
			try {
				xhr.send(null);
			} catch (exception) {
				serverDetails.serverStatus.isReachable = false;
				serverDetails.serverStatus.errorString = cvLoc('error.cvAccounts.serverConnectionFailed');
				takeImmediateAction();
				return;
			}

			xhr.onreadystatechange = function() {
				if (xhr.readyState == XMLHttpRequest.DONE) {
					if (xhr.status == 200) {
						serverDetails.serverStatus.isReachable = true;
						serverDetails.serverStatus.errorString = '';
						takeImmediateAction();
						return;
					} else {
						serverDetails.serverStatus.isReachable = false;
						serverDetails.serverStatus.errorString = cvLoc('error.cvAccounts.serverConnectionFailed');
						takeImmediateAction();
						return;
					}
				}
			};

			var takeImmediateAction = function() {
				//without waiting on Timer, take immediate action.
				clearTimeout(serverDetails.waitForServerResponseTimer);
				redirectToCvAccountsServer(serverDetails);
			};
		};

		var redirectToCvAccountsServer = function(serverDetails) {
			if (!cvAccountsSSOAttemptDismissed) {
				cvAccountsSSOWaitForUserActionTimer = setTimeout(function() {
					$window.location = serverDetails.cvAccountsSSOUrl;
					$('#cvSSOMessage').hide();
				}, 3000);
			} else {
				if (!cvAccountsSSOAttemptDismissed) {
					$scope.disableCvAccountsAttempt(serverDetails.serverStatus.errorString);
				} else {
					angular.element('form input')[0].focus();
				}
			}
		};

		var disableOnEscKeyPress = function(keyEvent) {
			if (keyEvent.keyCode == 27) {
				if (isCvAccountsSSOEnabled()) {
					$scope.disableCvAccountsAttempt();
				} else if (commcellSSO.isEnabledAtSP()) {
					$scope.disableCommcellSSOAttempt(true);
				}
			}
		};

		var commcellSSO = {};
		commcellSSO.isAttemptCancelled = {
			byUser: false,
			bySystem: false
		};
		commcellSSO.timer = null;
		commcellSSO.isEnabledAtSP = function() {
			return (
				(isCommcellSSOEnabled === true || isCommcellSSOEnabled === 'true') &&
				typeof $scope.userName !== 'undefined' &&
				$scope.userName.trim().length > 0
			);
		};
		commcellSSO.attemptSSO = function() {
			if (commcellSSO.isAttemptCancelled.byUser !== true && commcellSSO.isEnabledAtSP()) {
				commcellSSO.prepareForCommcellSSOUrlFetch();
				loginService
					.getCommcellSSOServerUrls($scope.userName)
					.success(function(clientResponse) {
						if (
							commcellSSO.isAttemptCancelled.byUser === false &&
							typeof clientResponse !== 'undefined' &&
							clientResponse.isError === false &&
							typeof clientResponse.commcellSSORedirectUrls !== 'undefined' &&
							clientResponse.commcellSSORedirectUrls.length > 0 &&
							typeof clientResponse.callBackUrl !== 'undefined'
						) {
							angular.element('#fetchingCommcellSSORedirectUrl').hide();
							angular.element('#commcellSSOMessages').show();
							var commcellSSORedirectUrlDivElement = angular
								.element('.commcellSSORedirectUrlList')
								.show()
								.empty();
							if (clientResponse.commcellSSORedirectUrls.length === 1) {
								commcellSSORedirectUrlDivElement.append(
									'<div><font color ="green"><span id="commcellSSORedirectUrl">' +
										cvLoc('label.redirectingToCommcell') +
										'<span id="commcellSSORedirectUrlList">' +
										clientResponse.commcellSSORedirectUrls[0].commcellName +
										'</span>' +
										'<font></span></div'
								);
							} else {
								clientResponse.commcellSSORedirectUrls.forEach(function(commcellRedirectUrl) {
									var inputParams = 'redirectUrl=' + commcellRedirectUrl.redirectUrl + '&';
									inputParams += clientResponse.callBackUrl + '&';
									inputParams += clientResponse.username;

									commcellSSORedirectUrlDivElement.append(
										'<div><a class="multipleIDPSSORedirectUrlList" data-inputparams="' +
											inputParams +
											'">' +
											commcellRedirectUrl.commcellName +
											'</a></div>'
									);
								});

								commcellSSORedirectUrlDivElement.on('click', '.multipleIDPSSORedirectUrlList', function() {
									commcellSSO.redirectToCommcellSSOServer($(this));
								});

								commcellSSORedirectUrlDivElement.append(
									'<div><span>' + cvLoc('label.pleaseChooseRedirectURL') + '</span></div>'
								);
							}
							commcellSSO.timer = setTimeout(function() {
								var inputParams = {
									redirectUrl: clientResponse.commcellSSORedirectUrls[0].redirectUrl,
									callBackUrl: clientResponse.callBackUrl,
									username: clientResponse.username
								};

								commcellSSO.redirectToCommcellSSOServer(inputParams);
							}, 2000);
						} else {
							$scope.disableCommcellSSOAttempt(false);
						}
					})
					.error(function() {
						$scope.disableCommcellSSOAttempt(false);
						//by user : true
						//by system : false
					});
			}
		};

		commcellSSO.redirectToCommcellSSOServer = function(inputParams) {
			clearTimeout(commcellSSO.timer);
			if (
				typeof inputParams.username === 'undefined' &&
				typeof inputParams.attr('data-inputparams') !== 'undefined' &&
				inputParams.attr('data-inputparams').startsWith('redirectUrl')
			) {
				var temp = inputParams.attr('data-inputparams').split('&');
				inputParams = {
					redirectUrl: temp[0].split('=')[1],
					callBackUrl: temp[1],
					username: temp[2]
				};
			}
			if (commcellSSO.isAttemptCancelled.byUser === false) {
				loginService
					.commcellSSOLogin(inputParams)
					.success(function(completeSSOUrl) {
						if (typeof completeSSOUrl !== 'undefined' && completeSSOUrl.trim().length > 1) {
							$window.location = completeSSOUrl;
							commcellSSO.isAttemptCancelled.bySystem = true;
						} else {
							console.log("empty redirect url.couldn't redirect");
							$scope.disableCommcellSSOAttempt(false);
						}
					})
					.error(function(error) {
						console.error('error in redirection.');
						$scope.disableCommcellSSOAttempt(false);
					});
			}
		};

		commcellSSO.prepareForCommcellSSOUrlFetch = function() {
			$scope.prepareForCommcellSSO = true;
			angular.element('#username').attr('disabled', 'disabled');
			angular.element('.commcellSSO').css('opacity', '1');
			angular.element('.commcellSSOMessages').hide();
			angular.element('#fetchingCommcellSSORedirectUrl').show();
			commcellSSO.isAttemptCancelled.byUser = false;
			commcellSSO.isAttemptCancelled.bySystem = false;
		};

		commcellSSO.disableCommcellSSOAttempt = function(isCancelledByUser) {
			if (isCancelledByUser === true) {
				commcellSSO.isAttemptCancelled.byUser = true;
			} else {
				commcellSSO.isAttemptCancelled.bySystem = true;
			}
			$scope.prepareForCommcellSSO = false;
			angular.element('#username').removeAttr('disabled');
			angular.element('.commcellSSO').css('opacity', '0');
			angular.element('form input')[1].focus();
		};

		$scope.disableCommcellSSOAttempt = commcellSSO.disableCommcellSSOAttempt;
		$scope.attemptCommcellSSO = commcellSSO.attemptSSO;

		$scope.userNameChanged = function(event) {
			if (event.keyCode == 9 || event.which == 9) {
				commcellSSO.attemptSSO();
			}
		};

		$document.on('keyup', disableOnEscKeyPress);
		$scope.$on('$destroy', function() {
			$document.off('keyup', disableOnEscKeyPress);
		});
	};
	controllers.ssoController.$inject = injection.ssoController;

	controllers.forgotPasswordController = function(
		$scope,
		$http,
		loginService,
		cvUtil,
		$window,
		$document,
		cvLoc,
		$timeout
	) {
		$scope.serverMessage = cvUtil.emptyMsg();
		$scope.email = '';
		$scope.resetPasswordInfo = cvLoc('info.enterEmailOrUserName');
		$scope.loading = false;
		$scope.forgotPassword = function() {
			$scope.serverMessage = cvUtil.emptyMsg();
			if (!$scope.email || $scope.email == '') {
				$scope.serverMessage = {
					message: cvLoc('error.enterEmailOrUserName'),
					type: 'error'
				};
				return;
			} else {
				$scope.loading = true;
				loginService
					.forgotPassword($scope.email)
					.success(function(data) {
						$scope.loading = false;
						$scope.resetPasswordInfo = cvLoc('info.resetPasswordSuccessful');
						$timeout(function() {
							$window.location.href = 'index.jsp';
						}, 5000);
					})
					.error(function(e) {
						$scope.loading = false;
						$scope.serverMessage = {
							message: e,
							type: 'error'
						};
					});
			}
		};
		$scope.userNameChanged = function(event) {
			if (event.keyCode == 13) {
				$scope.reset();
			}
		};
	};
	controllers.forgotPasswordController.$inject = [
		'$scope',
		'$http',
		'loginService',
		'cvUtil',
		'$window',
		'$document',
		'cvLoc',
		'$timeout'
	];

	controllers.resetPasswordController = function(
		$scope,
		$http,
		loginService,
		cvUtil,
		$window,
		$document,
		cvLoc,
		$timeout
	) {
		$scope.serverMessage = cvUtil.emptyMsg();
		$scope.returnToSign = false;
		$scope.password = '';
		$scope.confirmPassword = '';
		$scope.resetPasswordMessage = cvLoc('label.enterNewPassword');
		$scope.loading = false;
		$scope.checkPassword = function() {
			$scope.passwordMessage = cvUtil.emptyMsg();
			if (!$scope.password || $scope.password == '') {
				$scope.passwordMessage = {
					message: cvLoc('error.enterPassword'),
					type: 'error'
				};
			}
		};

		$scope.checkConfirmPassword = function() {
			$scope.confirmPasswordMessage = cvUtil.emptyMsg();

			if (!$scope.password || $scope.password == '') {
				return;
			}
			if ($scope.confirmPassword != $scope.password) {
				$scope.confirmPasswordMessage = {
					message: cvLoc('error.passwordNotMatch'),
					type: 'error'
				};
			}
		};
		$scope.reset = function() {
			$scope.loading = false;
			$scope.serverMessage = cvUtil.emptyMsg();
			$scope.passwordMessage = cvUtil.emptyMsg();
			$scope.confirmPasswordMessage = cvUtil.emptyMsg();
			if ($scope.password == '') {
				$scope.passwordMessage = {
					message: cvLoc('error.enterPassword'),
					type: 'error'
				};
				return;
			}
			if ($scope.password != $scope.confirmPassword) {
				$scope.confirmPasswordMessage = {
					message: cvLoc('error.passwordNotMatch'),
					type: 'error'
				};
				return;
			}
			$scope.passwordToSend = Base64.encode($scope.password);
			var token = cvUtil.getParameter('tk', null);
			$scope.loading = true;
			loginService
				.resetPassword(token, $scope.passwordToSend)
				.success(function(data) {
					$scope.returnToSign = true;
					$scope.resetPasswordMessage = cvLoc('info.resetPasswordSuccess');
					$scope.loading = false;
				})
				.error(function(e) {
					$scope.loading = false;
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};
		$scope.userNameChanged = function(event) {
			if (event.keyCode == 13) {
				$scope.reset();
			}
		};
	};

	controllers.resetPasswordController.$inject = [
		'$scope',
		'$http',
		'loginService',
		'cvUtil',
		'$window',
		'$document',
		'cvLoc',
		'$timeout'
	];
	ssoLoginMod.controller(controllers);
})();
