<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.events"></cv:cvMessages>
	</script>
	<fmt:bundle basename="localization.events">
		<div>
		<h1><cv:msg key="label.eventDetailFor" bundle="events"/> {{eventId}}</h1>
		</div>
		<div class="row">
			<div class="col-md-6">
				<cv-tile-component data-ac-id="eventDetails-header_event-events" data-title='<cv:msg key="header.event" bundle="events"/>' loader="event">
					<ul class="list-style-secondary">
						<li class="group"><span class="pageDetailColumn"><fmt:message key="Severity" /></span> <span class="pageDetailColumn"><div class="iconSelector" col-value="{{event.severity}}"></div></span></li>
						<li class="group"><span class="pageDetailColumn"><fmt:message key="Date" /></span> <span class="pageDetailColumn">{{event.timeSource | dateTime}}</span></li>
						<li class="group"><span class="pageDetailColumn"><fmt:message key="Event Code" /></span> <span class="pageDetailColumn">{{event.eventCode | eventCodeGen}}</span></li>
					</ul>
				</cv-tile-component>
			</div>
			<div class="col-md-6">
				<cv-tile-component data-ac-id="eventDetails-header_source-events" data-title='<cv:msg key="header.source" bundle="events"/>' loader="event">
					<ul class="list-style-secondary">
						<li class="group"><span class="pageDetailColumn"><fmt:message key="Program" /></span> <span class="pageDetailColumn">{{event.subsystem}}</span></li>
						<li class="group"><span class="pageDetailColumn"><fmt:message key="Computer" /></span> <span class="pageDetailColumn">{{event.clientEntity.clientName}}</span></li>
						<li class="group"><span class="pageDetailColumn"><fmt:message key="Job ID" /></span> <span class="pageDetailColumn"><a href="#/jobs/{{event.jobId}}">{{event.jobId}}</a></span></li>
					</ul>
				</cv-tile-component>
			</div>
			<div class="col-md-12">
				<cv-tile-component data-ac-id="eventDetails-header_description-events" data-title='<cv:msg key="header.description" bundle="events"/>' loader="event">
				<ul class="list-style-secondary">
                    <li class="group"><span class="" data-ng-bind-html="event.description"></span></li>
				</ul>
				</cv-tile-component>
			</div>
		</div>
	</fmt:bundle>
</div>