import { acAppEventsModule } from '../../../common/js/modules';
import 'events/js/services/events.svc.js';
import 'modules/settings/js/directives/cvPermittedActions.directives.js';
import 'jobs/js/services/jobs.svc.js';

import * as eventsDefinitionColumnTemplate from '../eventsDefinition.column.template';

var eventsMod = acAppEventsModule;

export class EventsListController {
	constructor(
		$scope,
		eventService,
		$stateParams,
		cvLoc,
		$timeout,
		$filter,
		cvUtil,
		$state,
		jobService,
		$compile,
		multiCommcellFactory
	) {
		this.$scope = $scope;
		this.eventService = eventService;
		this.$stateParams = $stateParams;
		this.cvLoc = cvLoc;
		this.$timeout = $timeout;
		this.$filter = $filter;
		this.cvUtil = cvUtil;
		this.$state = $state;
		this.jobService = jobService;
		this.$compile = $compile;
		this.multiCommcellFactory = multiCommcellFactory;
		this.eventsNotified = [];
		this.$scope.currentParams = {};
		this._jobDetailsEvents();
		this._setupGridOptions();
		//this.initSubscriptionEvents();
	}

	/**
	 * When events are shown in jobDetails page
	 */

	_jobDetailsEvents() {
		let jobIdForDetail = this.$stateParams['jobId'];

		//events table on job quick view modal
		if (!jobIdForDetail && this.$state.current.name != 'events') {
			jobIdForDetail = this.jobService.getJobIdForDetail();
			this.$scope.isModal = true;
		}

		// This check is required because on job details page we dont want to push all events. Only specific events for that jobs needs to be shown
		this.$scope.filterJobs = jobIdForDetail ? true : false;

		if (this.$scope.filterJobs) {
			this.$scope.jobIdToFilter = parseInt(jobIdForDetail);
		}
	}

	/**
	 * init columns definition calls column template file.
	 */

	_initColumnDefs() {
		return eventsDefinitionColumnTemplate.getColumnTemplate(
			{
				cvLoc: this.cvLoc
			},
			this.$scope.filterJobs,
			this.$scope.isModal
		);
	}

	/**
	 * kendoGridSetup options
	 *
	 * @private
	 */
	_setupGridOptions() {
		const self = this;
		this.kendoGridOptions = {};
		this.$scope.kendoGridOptions = this.kendoGridOptions;
		this.kendoGridOptions.pageSize = this.$scope.isModal ? 5 : 20;
		this.kendoGridOptions.idField = 'id';
		this.kendoGridOptions.gridTitle = this.cvLoc('header.events');
		this.kendoGridOptions.gridEmptyMessage = this.cvLoc('label.noEvents');
		this.kendoGridOptions.hideToolbar = this.$scope.isModal;
		this.kendoGridOptions.tableName = this.$scope.isModal ? 'jobEventsTable' : 'eventsTable';
		this.kendoGridOptions.hasViews = this.$scope.isModal ? false : true;
		// Setup column definitions
		this.kendoGridOptions.columns = this._initColumnDefs();
		this.kendoGridOptions.usePageToolbar = !this.$scope.isModal;
		// Setup events data to kendoGrid.
		this.kendoGridOptions.url = this._getEventsData.bind(this);
		// afterViewChange (when changing view filter
		this.kendoGridOptions.afterViewChange = this._changeView.bind(this);
		this.kendoGridOptions.onGridDataBound = this._onGridDataBound.bind(this);

		if (cvConfig.pushEnabled) {
			this.enablePush();
		}
		this.kendoGridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
	}

	getViewParams(view) {
		this.$scope.currentParams.severity = undefined;
		// for each filter it checks if its severity it sets de value and set severity of currentParams
		if (view.filters) {
			for (var i = 0; i < view.filters.length; i++) {
				if (view.filters[i].columnName === 'severity') {
					this.$scope.currentParams.severity = view.filters[i].filterValue;
				}
			}
		}

		// if last duration is present, include time constraint as well
		if (view.advancedFilters && view.advancedFilters.lastDuration) {
			let duration = parseInt(view.advancedFilters.lastDuration);
			this.$scope.currentParams.endTime = Math.ceil(new Date().getTime() / 1000);
			this.$scope.currentParams.startTime = this.$scope.currentParams.endTime - 60 * 60 * 24 * duration; // 1 day
		} else {
			delete this.$scope.currentParams.endTime;
			delete this.$scope.currentParams.startTime;
		}

		if (view.advancedFilters && view.advancedFilters.anomalous) {
			this.$scope.currentParams.anomalous = true;
		} else {
			delete this.$scope.currentParams.anomalous;
		}
	}
	/**
	 * _changeView function to manage view change filter
	 */
	_changeView(viewObj) {
		//        const view = viewObj.view;
		//        this.getViewParams.call(this, view);
		// calls de kendo url setting again, reading the data from events
		this.grid.refreshData();
	}

	enablePush() {
		this.unsubscribe = this.subscribeEvents(this.onPushSuccess.bind(this), this.onPushError.bind(this));
	}

	subscribeEvents(onMessage, onError) {
		var subscribeInfo = {
			msg: 'subscribe',
			type: 'EVENT'
		};
		return pushService.subscribe(subscribeInfo, onMessage, onError);
	}

	processEvent(event) {
		const commCellName = _.get(event, 'clientEntity.commCellName');
		event.eventDetailsUrl = cvUtil.modifyUrlForComet('#/event/' + event.id, commCellName);
		event.jobUrl = cvUtil.modifyUrlForComet('#/jobs/' + event.jobId, commCellName);
		event.target = cv.isCometApp ? '_blank' : '_self';
	}

	onPushSuccess(data) {
		const self = this;
		if (data && data.commservEvents && data.commservEvents.length > 0) {
			_.orderBy(data.commservEvents, ['id'], ['desc']);
			let eventsToUpdate = [];
			angular.forEach(data.commservEvents, event => {
				// convert the severity and time
				event.severityClass = self._getSeverityClass(event.severity);
				event.severityText = self._getSeverityText(event.severity);
				event.formattedTimeSource = self.$filter('date')(event.timeSource * 1000, 'MMM d, y h:mm:ss a');
				this.processEvent(event);
				if (self.$scope.jobIdToFilter) {
					if (event.jobId && event.jobId == self.$scope.jobIdToFilter) {
						eventsToUpdate.push(event);
					}
				} else {
					eventsToUpdate.push(event);
				}
			});

			this.grid.addData(eventsToUpdate, true);
		}
	}

	onPushError(error) {
		console.log(error);
	}
	_onGridDataBound(dataItem, row) {
		if (dataItem.get('isNewData') === 'true') {
			row.addClass('push-notification-new');
			row.addClass('push-notification-new-fade');
			setTimeout(function() {
				row.removeClass('push-notification-new');
				dataItem.set('isNewData', undefined);
			}, 5000);
		}
		let eventIdColumn = row.find('.event-id-column');
		this.multiCommcellFactory.setGridClickFunction(eventIdColumn);
	}

	/**
	 * Gets the event data from the API request
	 *
	 * @param options
	 * @returns {*}
	 * @private
	 */
	_getEventsData(options) {
		const view = this.grid.getViewSvc().getCurrentView();
		this.getViewParams.call(this, view);
		const self = this;
		if (this.$scope.jobIdToFilter) {
			this.$scope.currentParams.jobId = this.$scope.jobIdToFilter;
		} else {
			delete this.$scope.currentParams.jobId;
		}

		return this.eventService
			.getEvents(this.$scope.currentParams)
			.success(data => {
				let allEvents = [];
				if (cv.isCometApp) {
					// sort by time for comet events. Will be kept till events and alerts moved to cache.
					data = _.orderBy(data, ['timeSource'], ['desc']);
				}
				angular.forEach(data, events => {
					// convert the severity and time
					events.severityClass = self._getSeverityClass(events.severity);
					events.severityText = self._getSeverityText(events.severity);
					events.formattedTimeSource = self.$filter('date')(events.timeSource * 1000, 'MMM d, y h:mm:ss a');
					this.processEvent(events);
					allEvents.push(events);
				});

				options.success(allEvents);
			})
			.error(error => {
				console.log('error', error);
			});
	}

	_getSeverityText(severity) {
		switch (severity) {
			case 9:
				return this.cvLoc('label.critical');
			case 0:
				return this.cvLoc('label.info');
			case 3:
				return this.cvLoc('label.minor');
			case 6:
				return this.cvLoc('label.major');
			default:
				return this.cvLoc('label.noDataAvailable');
		}
	}

	_getSeverityClass(severity) {
		switch (severity) {
			case 9:
				return 'critical';
			case 6:
				return 'major';
			case 3:
				return 'minor';
			case 0:
				return 'info';
		}
	}
}

EventsListController.$inject = [
	'$scope',
	'eventService',
	'$stateParams',
	'cvLoc',
	'$timeout',
	'$filter',
	'cvUtil',
	'$state',
	'jobService',
	'$compile',
	'multiCommcellFactory'
];

eventsMod.controller('eventsListController', EventsListController);

export default eventsMod;
