import 'events/js/services/events.svc.js';

import { acAppEventsModule } from 'common/js/modules';

var eventsMod = acAppEventsModule;

var controllers = {};

controllers.eventDetailsController = [
	'$scope',
	'eventService',
	'$stateParams',
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	function($scope, eventService, $stateParams, cvBreadcrumbsTabsFactory, cvLoc) {
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('header.events'),
				link: '#events'
			}
		]);

		$scope.message = cvLoc('label.loading');
		$scope.eventId = $stateParams['eventId'];
		eventService
			.loadEvent($stateParams['eventId'])
			.success(function(data) {
				$scope.event = data;
				$scope.message = '';
			})
			.error(function() {
				$scope.message = cvLoc('error.loadFailed');
			});
	}
];

eventsMod.directive('myCustomDropdown', function() {
	return {
		template:
			'<select class="form-control" ng-model="colFilter.term" ng-options="option.id as option.value for option in colFilter.options"></select>'
	};
});

eventsMod.filter('severityGridFilter', [
	'cvLoc',
	function(cvLoc) {
		var severityHash = {
			1: '0',
			2: '3',
			3: '6',
			4: '9',
			5: '-999'
		};

		return function(input) {
			if (!input) {
				return '';
			} else {
				return severityHash[input];
			}
		};
	}
]);

eventsMod.filter('eventCodeGen', [
	'cvLoc',
	function(cvLoc) {
		return function(text) {
			var eventCode = text & 0xffffff;
			var subsystem = text >> 24;
			return subsystem + ':' + eventCode;
		};
	}
]);

eventsMod.directive('iconSelector', [
	'cvLoc',
	function(cvLoc) {
		return {
			restrict: 'C',
			replace: true,
			transclude: true,
			scope: {
				colValue: '@colValue'
			},
			template:
				'<div ng-switch on="colValue">' +
				'<div title="' +
				cvLoc('label.info') +
				'" ng-switch-when="0" class="ngCellText"><span class="info">' +
				cvLoc('label.info') +
				'</span></div>' +
				'<div title="' +
				cvLoc('label.minor') +
				'" ng-switch-when="3" class="ngCellText"><span class="minor">' +
				cvLoc('label.minor') +
				'</span></div>' +
				'<div title="' +
				cvLoc('label.major') +
				'" ng-switch-when="6" class="ngCellText"><span class="major">' +
				cvLoc('label.major') +
				'</span></div>' +
				'<div title="' +
				cvLoc('label.critical') +
				'" ng-switch-when="9" class="ngCellText"><span class="critical">' +
				cvLoc('label.critical') +
				'</span></div>' +
				'<div title="' +
				cvLoc('label.success') +
				'" ng-switch-when="-999" class="ngCellText"><span class="success">' +
				cvLoc('label.success') +
				'</span></div>' +
				'<div title="' +
				cvLoc('label.info') +
				'" ng-switch-default class="ngCellText"><span class="default">' +
				cvLoc('label.info') +
				'</span></div>'
		};
	}
]);
eventsMod.controller(controllers);

export default eventsMod;
