<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.uninstallSoftware" bundle="servers"/></h1>
	
</div>
<div class="setup-content">
	<div data-ng-if="!isResponse">
		<form name="uninstallSoftwareForm" novalidate
			cv-submit="uninstallSoftware()" autocomplete="off">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<div class="cv-modal-wrapper">
				<label class="cv-label word-wrap"><cv:msg key="label.selctPackages" bundle="servers"/></label>
				<div class="cv-inline-wrapper">
					<div class="padding-right-20">
						<isteven-multi-select input-model="installedPackages"
							output-model="selectedPackages" button-label="displayName"
							item-label="displayName" tick-property="checked"
						
							class="isteven-multi-select user-group-select" id="packageId"
							name="displayName" helper-elements="all none reset filter"
							max-labels="2" translation="model.localLang">
						</isteven-multi-select>
					</div>
				</div>
			</div>

			<div class="padding-15 padding-top-28">
				<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
			</div>

			<div class="button-container">
				<button id="uninstallSoftware_button_#7030" type="button" class="btn btn-default cvBusyOnAjax" 
					data-ng-click="cancel()">
					<cv:msg key="Cancel" />
				</button>
				<button id="uninstallSoftware_button_#4549" type="submit" class="btn btn-primary cvBusyOnAjax" 
					data-ng-disabled="selectedPackages.length==0">
					<cv:msg key="action.uninstall" bundle="servers"/>
				</button>
			</div>
		</form>
	</div>
	<div data-ng-if="isResponse">
		<p data-ng-bind-html="responseContent"></p>
		<div class="button-container">
			<button id="uninstallSoftware_button_#1265" type="submit" class="btn btn-primary" data-ng-click="close()"> 
				<cv:msg key="OK" bundle="servers" />
			</button>
		</div>
	</div>
</div>