<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>

<div class="setup-title">
	<h1><cv:msg key="label.smartMAStateManagement" bundle="storage"/></h1>
</div>

<div class="error" data-ng-if="stateCtrl.errorMessage" data-ng-bind-html="stateCtrl.errorMessage"></div>
<h3 class="modal-list text-left"><cv:msg key="label.association" bundle="users" /></h3>

<div data-ng-if="stateCtrl.treeParams" class="panel-body" >
	<cv-storage-policy-selection-tree-component
		data-mode="edit"
		data-tree-options="stateCtrl.treeParams">
	</cv-storage-policy-selection-tree-component>
</div>

<div class="modal-footer">
	<button id="smartMAStatemanagement_button_cancel" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="stateCtrl.cancel()"><cv:msg key="Cancel" bundle="messages" /></button>
 	<button id="smartMAStatemanagement_button_save" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="stateCtrl.saveAssociations()" ><cv:msg key="Save" bundle="messages" /></button>
</div>
