<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
    <cv:cvMessages bundle="localization.job"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="modal-header">
    <h4 class="modal-title"><cv:msg key="header.repairSoftware" bundle="clients"/></h4>
</div>
<div class="modal-body">
    <span class="{{rsCtrl.serverMessage.type}} serverMessage">{{rsCtrl.serverMessage.message}}</span>
    <div data-ng-if="!rsCtrl.submitted">
        <form name="repairSoftwareForm" autocomplete="off" cv-submit="rsCtrl.repair()">
        <div class="form-group" ng-bind="rsCtrl.confirmMessage"></div>
        <div class="form-group">
            <cv-toggle toggle-name="forceReboot" toggle-label="label.foreceReboot" value="rsCtrl.forceReboot"></cv-toggle>
        </div>
        <div class="form-group">
            <cv-toggle toggle-name="systemCredentials" toggle-label="System Credentials" value="rsCtrl.model.systemCredentials.isEnabled"></cv-toggle>
        </div>
        <div data-ng-if="rsCtrl.model.systemCredentials.isEnabled" class="form-group temporary-disabled">
            
            <div class="cv-modal-wrapper">
                <label class="cv-label" for="username"><cv:msg key="label.userName" bundle="serversJs" /></label>
                <div class="cv-inline-wrapper">
                    <input type="text" name="username" id="username" data-ng-model="rsCtrl.model.systemCredentials.username" required autoCompleteType="disable" autocomplete="off" placeholder="{{usernameHelpText}}" />
                    <span class="cv-help-block" data-ng-show="cv.repairSoftwareForm.needsAttention(repairSoftwareForm.username) || showError"><cv:msg key="error.userName" bundle="servers" /></span>
                </div>
            </div>
            <div class="cv-modal-wrapper">
                <label class="cv-label" for="password"><cv:msg key="label.password" bundle="servers" /></label>
                <div class="cv-inline-wrapper">
                    <input type="password" name="password" id="password" data-ng-model="rsCtrl.model.systemCredentials.password"  required autoCompleteType="disable" autocomplete="off" />
                    <span class="cv-help-block" data-ng-show="cv.repairSoftwareForm.needsAttention(repairSoftwareForm.password) || showError"><cv:msg key="error.password" bundle="servers" /></span>
                </div>
            </div>
            <div class="cv-modal-wrapper">
                <label class="cv-label" for="confirmPasswordRepairInstall"><cv:msg key="label.confirmPassword" bundle="servers" /></label>
                <div class="cv-inline-wrapper">
                    <input type="password" name="confirmPasswordRepairInstall" id="confirmPasswordRepairInstall" data-ng-model="rsCtrl.model.systemCredentials.confirmPassword" data-cv-equals="{{rsCtrl.model.systemCredentials.password}}"
                        required autoCompleteType="disable" autocomplete="off" />
                    <span class="cv-help-block" data-ng-show="repairSoftwareForm.confirmPasswordRepairInstall.$error.required && cv.repairSoftwareForm.needsAttention(repairSoftwareForm.confirmPasswordRepairInstall)">
                        <cv:msg key="error.confirmPassword" bundle="servers" /></span>
                    <span class="cv-help-block"
                        data-ng-if="!repairSoftwareForm.confirmPasswordRepairInstall.$error.required && !cv.repairSoftwareForm.confirmPasswordRepairInstall.$error.cvEquals && cv.repairSoftwareForm.needsAttention(repairSoftwareForm.confirmPasswordRepairInstall)">
                        <cv:msg key="error.mismatchedPassword" bundle="users" /></span>
                </div>
            </div>
        </div>
        <div class="padding-bottom-20">
            <cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
        </div>
        <div class="button-container">
    	    <button id="repairSoftwareModal_button_#8472" type="button" class="btn btn-default" data-ng-click="rsCtrl.cancel()"><cv:msg key="button.no"/></button>
        	<button id="repairSoftwareModal_button_#2696" type="submit" class="btn btn-primary no-margin" ><cv:msg key="button.yes"/></button>
        </div>
    </form>
    </div>
    <div data-ng-if="rsCtrl.submitted">
        <div class="form-group">
        	<div><cv:msg key="label.jobStarted" bundle="job" params="{{rsCtrl.jobId}}"/></div>
        	<a href="#/jobs/{{rsCtrl.jobId}}" target="_blank"><cv:msg key="notification.viewJobs" bundle="job" /></a>
        </div>
        <div class="button-container">
            <button id="repairSoftwareModal_button_#6802" type="button" class="btn btn-primary no-margin" data-ng-click="rsCtrl.cancel()"><cv:msg key="OK"/></button>
   		 </div>
    </div>
</div>
