<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1><cv:msg key="label.releaseLicense" bundle="servers"/></h1>
	</div>
	<div class="bootstrap-wrapper">
		<form data-ng-if="!isResponse" name="releaseLicenseForm" novalidate cv-submit="releaseLicense()" autocomplete="off">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<div class="form-group">
				<div data-ng-if="availableLicenses.length"  class="col-xs-12">
					<cv-checkbox-group is-vertical="true" check-obj="availableLicenses" output-model="selectedLicense"></cv-checkbox-group>
				</div>
				<div data-ng-if="!availableLicenses.length" class="col-xs-12">
					<p data-ng-bind="modalBodyMessageText"></p>
				</div> 
			</div>
			<div class="button-container">
				<button id="releaseLicenseModal_button_#6674" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
				<button id="releaseLicenseModal_button_#7315" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="availableLicenses.length && !selectedLicense.length"><cv:msg key="OK"/></button> 
			</div>
		</form>
		<div data-ng-if="isResponse">
			<p data-ng-bind-html="responseContent"></p>
			<div class="button-container">
				<button id="releaseLicenseModal_button_#5368" type="submit" class="btn btn-primary" data-ng-click="close()"><cv:msg key="OK" /></button> 
			</div>
		</div>
	</div>