<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div data-ng-controller="pushInstallController" data-ng-class="{'hideX' : showJobProgress}">
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
		<cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
		<cv:cvMessages bundle="localization.users"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1 data-ng-if="!isAuthenticated">
			<span>{{dialogTitle}}<cv-help-component data-help-text="{{dialogTitleHelpText}}"></cv-help-component></span>
		</h1>
		<h1 data-ng-if="isAuthenticated">
			<cv:msg key="action.addSoftware" bundle="servers" />
			<cv-help-component data-help-text="{{addSoftwareHelpText}}"></cv-help-component>
		</h1>
	</div>
	<div class="setup-content medium-width" data-ng-class="{'reduced-padding-top' : selectInstallType}">
		<div data-ng-if="!isResponse">
			<div>
				<p class="{{serverConfigMessage.type}} serverMessage">{{serverConfigMessage.message}}</p>
			</div>
			<div data-ng-show="formConfig.hide && showAssociations">
					<h5 data-ng-hide="showPushInstallJobInfo" class="text-left font-weight-bold"><cv:msg key="label.serverAlreadyAdded" bundle="servers"/></h5>
					<p class="text-left"><cv:msg key="label.processBelowStatus" bundle="servers"/></p>
					<cv-grid data-ng-if="gridOptions" cv-grid-options="gridOptions"></cv-grid>
			</div>
			<div class="margin-top-35-minus" data-ng-if="showPushInstallJobInfo">
				<p><cv:msg key="notification.pushInstall" bundle="serversJs" /></p>
				<a ng-href="#/jobs/{{installJobID}}"><cv:msg key="notification.jobDetails" bundle="serversJs" /></a>
			</div>
			<div class="list-group-item" data-ng-show="formConfig.hide && !showAssociations && !showPushInstallJobInfo">
					<h5 class="text-left font-weight-bold"><cv:msg key="label.serverAlreadyAdded" bundle="servers" /></h5>
					<p class="text-left" ng-if="serverPlanMap && serverPlanMap.length"><cv:msg key="label.serverPlanAssociaton" bundle="servers" params="{{serverPlanMap[0].clientInfo.client.clientEntity.clientName}},{{serverPlanMap[0].plan.planName}}" /></p>
			</div>
			<form name="pushInstallSoftwareForm" novalidate cv-submit="installSoftware()" autocomplete="off" data-ng-hide="formConfig.hide" data-ng-switch="model.installType">
				<div data-ng-if="selectInstallType" class="select-icon-longDesc" data-ng-disabled="disableInstallSelect">
					<label class="row select-oneType" data-ng-class="{checked:(model.installType=='push')}">
						<input class="no-float-auto col-md-1" type="radio" data-ng-model="model.installType" value="push" data-ng-change="updateInstallType('push')">
						<span class="col-md-2"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 15.38"><path  d="M10.17,2.94H1a.53.53,0,0,0-.53.53V9.14A.53.53,0,0,0,1,9.67H4.45l-.17,1.56H2.53v.57H8.83v-.56H7.19L7,9.67h3.16a.53.53,0,0,0,.53-.53V3.47A.54.54,0,0,0,10.17,2.94Zm0,6.2H1V3.48h9.22Z"/><polygon  points="23.37 7.72 14.23 7.72 14.23 6.75 11.99 8.04 14.23 9.34 14.23 8.37 23.37 8.37 23.37 7.72"/><path  d="M31.45,13.46H25.08a.26.26,0,0,1-.26-.26V1.6a.26.26,0,0,1,.26-.26h6.37a.26.26,0,0,1,.26.26V13.2A.26.26,0,0,1,31.45,13.46Zm-6.11-.52h5.85V1.86H25.34Z"/><path  d="M30.65,4H25.9a.2.2,0,0,1,0-.41h4.75a.2.2,0,0,1,0,.41Z"/><path  d="M30.65,4.74H25.9a.2.2,0,0,1,0-.41h4.75a.2.2,0,0,1,0,.41Z"/><path  d="M30.68,10.53H25.93a.2.2,0,1,1,0-.41h4.75a.2.2,0,0,1,0,.41Z"/><path  d="M30.68,11.3H25.93a.2.2,0,1,1,0-.41h4.75a.2.2,0,0,1,.2.2A.2.2,0,0,1,30.68,11.3Z"/><path  d="M28.87,2.42h-.57a.08.08,0,0,0-.08.08v.57a.08.08,0,0,0,.08.08h.57A.08.08,0,0,0,29,3.08V2.51A.08.08,0,0,0,28.87,2.42ZM28.39,3V2.59h.41V3Z"/><path  d="M30.72,2.42h-.57a.08.08,0,0,0-.08.08v.57a.08.08,0,0,0,.08.08h.57a.08.08,0,0,0,.08-.08V2.51A.08.08,0,0,0,30.72,2.42ZM30.23,3V2.59h.41V3Z"/><path  d="M27.09,5.9a.82.82,0,1,0,.82.82A.82.82,0,0,0,27.09,5.9Zm0,1.31a.49.49,0,1,1,.49-.49A.49.49,0,0,1,27.09,7.21Z"/><path  d="M29.61,5.9a.82.82,0,1,0,.82.82A.82.82,0,0,0,29.61,5.9Zm0,1.31a.49.49,0,1,1,.49-.49A.49.49,0,0,1,29.61,7.21Z"/><path  d="M21,2.53,20.64.76a.38.38,0,0,0-.37-.3h0l-4.54,0a.38.38,0,0,0-.37.3L15,2.5V6.17a.37.37,0,0,0,.37.37h5.33A.37.37,0,0,0,21,6.17ZM20.26.85l.39,1.71H18.19V.85Zm-4.54,0h2.08V2.56H15.34v0Zm-.38,5.3V2.76h5.31l0,3.4Z"/><path  d="M19.27,4.68V4.32h-.38A.89.89,0,0,0,18.78,4l.27-.27-.3-.3-.27.27a.9.9,0,0,0-.29-.12V3.23h-.36v.38a.9.9,0,0,0-.29.12l-.27-.27-.3.3.27.27a.91.91,0,0,0-.12.29h-.38v.36h.38a.9.9,0,0,0,.12.29L17,5.25l.3.3.27-.27a.9.9,0,0,0,.29.12v.38h.36V5.39a.9.9,0,0,0,.29-.12l.27.27.3-.3L18.78,5a.9.9,0,0,0,.12-.29h.38ZM18,4.86a.36.36,0,1,1,.36-.36A.36.36,0,0,1,18,4.86Z"/></svg>
						</span>
						<span class="col-md-9 select-desc"><cv:msg key="desc.pullInstall" bundle="servers"/></span>
					</label>
					<label class="row select-oneType"  data-ng-class="{checked:(model.installType=='dock')}">
						<input class="no-float-auto col-md-1"  type="radio" data-ng-model="model.installType" value="dock" data-ng-change="updateInstallType('dock')">
						<span class="col-md-2"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 15.38"><path  d="M10.91,3H.87a.58.58,0,0,0-.58.58V9.79a.58.58,0,0,0,.58.58H4.68l-.19,1.7H2.59v.62H9.44v-.61H7.67l-.19-1.7h3.44a.58.58,0,0,0,.58-.58V3.61A.59.59,0,0,0,10.91,3Zm0,6.75H.87V3.62h10Z"/><path  d="M15.33,9.2l-.51.58c-.6-.61-1.15-1.18-1.69-1.76a.33.33,0,0,1,0-.32c.55-.59,1.11-1.15,1.72-1.77l.5.55c-.36.37-.7.73-1.07,1.07s-.25.37,0,.59S15,8.84,15.33,9.2Z"/><path  d="M20.54,6.49,21.16,6c.56.58,1.13,1.16,1.69,1.76a.27.27,0,0,1,0,.26c-.56.58-1.13,1.14-1.73,1.75l-.51-.57c.36-.35.72-.71,1.09-1,.22-.2.25-.35,0-.56S21,6.89,20.54,6.49Z"/><path  d="M15.71,8.3a.41.41,0,0,1-.42-.44.4.4,0,0,1,.42-.45.43.43,0,0,1,.5.42C16.23,8.1,16.07,8.29,15.71,8.3Z"/><path  d="M18.69,8.3c-.34,0-.51-.2-.5-.46a.42.42,0,0,1,.49-.43.41.41,0,0,1,.44.44A.41.41,0,0,1,18.69,8.3Z"/><path  d="M20.14,8.3c-.34,0-.51-.2-.5-.46a.42.42,0,0,1,.49-.43.41.41,0,0,1,.44.44A.41.41,0,0,1,20.14,8.3Z"/><path  d="M17.23,8.3c-.3,0-.47-.15-.47-.45a.39.39,0,0,1,.42-.44.41.41,0,0,1,.46.44A.41.41,0,0,1,17.23,8.3Z"/><path  d="M31.28,14.1H24.73a.27.27,0,0,1-.27-.27V1.89a.27.27,0,0,1,.27-.27h6.56a.27.27,0,0,1,.27.27V13.83A.27.27,0,0,1,31.28,14.1ZM25,13.56h6V2.15H25Z"/><path  d="M30.46,4.37H25.57a.21.21,0,0,1,0-.42h4.89a.21.21,0,0,1,0,.42Z"/><path  d="M30.46,5.12H25.57a.21.21,0,0,1,0-.42h4.89a.21.21,0,0,1,0,.42Z"/><path  d="M30.49,11.08H25.6a.21.21,0,1,1,0-.42h4.89a.21.21,0,0,1,0,.42Z"/><path  d="M30.49,11.88H25.6a.21.21,0,1,1,0-.42h4.89a.21.21,0,0,1,.21.21A.21.21,0,0,1,30.49,11.88Z"/><path  d="M28.64,2.73h-.59a.08.08,0,0,0-.08.08v.59a.09.09,0,0,0,.08.08h.59a.08.08,0,0,0,.08-.08V2.82A.09.09,0,0,0,28.64,2.73Zm-.5.59V2.9h.42v.42Z"/><path  d="M30.54,2.73H30a.08.08,0,0,0-.08.08v.59a.09.09,0,0,0,.08.08h.59a.09.09,0,0,0,.08-.08V2.82A.09.09,0,0,0,30.54,2.73Zm-.5.59V2.9h.42v.42Z"/><path  d="M26.8,6.32a.84.84,0,1,0,.84.84A.84.84,0,0,0,26.8,6.32Zm0,1.34a.5.5,0,1,1,.5-.5A.5.5,0,0,1,26.8,7.66Z"/><path  d="M29.39,6.32a.84.84,0,1,0,.84.84A.84.84,0,0,0,29.39,6.32Zm0,1.34a.5.5,0,1,1,.5-.5A.5.5,0,0,1,29.39,7.66Z"/><path  d="M7.87,6,7.61,4.9a.25.25,0,0,0-.24-.19h-3a.25.25,0,0,0-.24.19L3.91,6V8.42a.24.24,0,0,0,.24.24H7.63a.24.24,0,0,0,.24-.24ZM7.37,5l.25,1.11H6V5Zm-3,0H5.77V6.07H4.16ZM4.17,8.42V6.2H7.62V8.41Z"/><path  d="M6.77,7.45V7.21H6.51A.61.61,0,0,0,6.43,7l.19-.19-.21-.21-.19.19A.62.62,0,0,0,6,6.72V6.46H5.78v.26a.62.62,0,0,0-.2.08l-.19-.19-.21.21L5.37,7a.62.62,0,0,0-.08.2H5v.25h.26a.62.62,0,0,0,.08.2l-.19.19L5.39,8l.19-.19a.62.62,0,0,0,.2.08V8.2H6V7.94a.62.62,0,0,0,.2-.08L6.41,8l.21-.21-.19-.19a.62.62,0,0,0,.08-.2h.26Zm-.87.12a.25.25,0,1,1,.25-.25A.25.25,0,0,1,5.9,7.58Z"/></svg></svg>
						</span>
						<span class="col-md-9 select-desc"><cv:msg key="desc.dockInstall" bundle="servers"/></span>
					</label>
				</div> <!-- end of selectInstall -->
				<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
				<div data-ng-switch-when="push">
					<div class="panel panel-default">
						<div data-ng-class="{'panel-body' : showPanel}">
							<div data-ng-if="(!isAuthenticated && !isResponse) || showUserCredentials">
								<!-- server name is not needed in the UI, host name is server name -->
								<div class="cv-modal-wrapper add-device-hostname select-mode" data-ng-class="{'interactive-install-link':selectInstallType}">
									<label class="cv-label" for="hostName"><cv:msg key="label.hostName" bundle="serversJs"/></label>
									<div ng-init="model.hostname=''" class="cv-inline-wrapper width-60-percentage host-name-input-wrapper">
										<input class="display-inline" ng-blur="addHostName(true)" type="text" name="hostName" id="hostName" data-ng-model="model.hostname"  
											autocompletetype="disable" autocomplete="off"  placeholder='<cv:msg key="label.enterHostName" bundle="serversJs"/>'>
										<span ng-disabled="!model.hostname">
											<span  class="k-icon k-i-plus cursor-pointer" id="add-host-name" title="Add" ng-click="addHostName()"></span>
										</span>
										<div class="cv-help-block"  data-ng-if="errors.hostname.emptyHostNames" ng-bind="'error.atLeastOneHostName' | cvLoc"></div>
										<div class="cv-help-block"  data-ng-if="errors.hostname.alreadyExist" ng-bind="'error.hostNameExist' | cvLoc"></div>
										<div class="cv-help-block"  data-ng-if="errors.hostname.validHostName" ng-bind="'error.validHostName' | cvLoc"></div>
										<div ng-repeat="hostname in model.hostNames" class="info-tag">
										   <div class="cv-flex">
												<span title="{{hostname}}" class="crop" ng-bind="hostname"></span>
												<span>
													<a class="close-icon k-icon k-i-close cursor-pointer" ng-click="removeHostName($index)"></a>
												</span>
										   </div>
										</div>
									</div>
								</div>
								<div class="cv-modal-wrapper">
									<label class="cv-label" for="fakeusernameremembered"><cv:msg key="label.userName" bundle="serversJs" /></label>
									<div class="cv-inline-wrapper width-60-percentage">
										<input type="text" name="fakeusernameremembered" id="fakeusernameremembered" data-ng-model="model.clientInfo.vsUserName" ng-required="!showUserCredentials || model.clientInfo.vsPassword || model.clientInfo.confirmPassword" autoCompleteType="disable" autocomplete="off" placeholder="{{usernameHelpText}}" />
										<span class="cv-help-block" data-ng-show="(!showUserCredentials || model.clientInfo.vsPassword || model.clientInfo.confirmPassword) &&  cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.fakeusernameremembered) || showError"><cv:msg key="error.userName" bundle="servers" /></span>
									</div>
								</div>
								<div data-ng-if="!model.usePassphrase" class="cv-modal-wrapper">
									<label class="cv-label" for="fakepasswordremembered"><cv:msg key="label.password" bundle="servers" /></label>
									<div class="cv-inline-wrapper width-60-percentage">
										<input type="password" name="fakepasswordremembered" id="fakepasswordremembered" data-ng-model="model.clientInfo.vsPassword"  ng-required="!showUserCredentials || model.clientInfo.vsUserName || model.clientInfo.confirmPassword" autoCompleteType="disable" autocomplete="off" />
										<span class="cv-help-block" data-ng-show="(!showUserCredentials || model.clientInfo.vsUserName || model.clientInfo.confirmPassword) && cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.fakepasswordremembered) || showError"><cv:msg key="error.password" bundle="servers" /></span>
									</div>
								</div>
								<div data-ng-if="!model.usePassphrase" class="cv-modal-wrapper">
									<label class="cv-label" for="confirmPasswordPushInstall"><cv:msg key="label.confirmPassword" bundle="servers" /></label>
									<div class="cv-inline-wrapper width-60-percentage">
										<input type="password" name="confirmPasswordPushInstall" id="confirmPasswordPushInstall" data-ng-model="model.clientInfo.confirmPassword" data-cv-equals-when="{{!!(model.clientInfo.vsPassword)}}" data-cv-equals="{{model.clientInfo.vsPassword}}"
											ng-required="!showUserCredentials || model.clientInfo.vsUserName || model.clientInfo.vsPassword" autoCompleteType="disable" autocomplete="off" />
										<span class="cv-help-block" data-ng-show="(!showUserCredentials || model.clientInfo.vsUserName || model.clientInfo.vsPassword) && pushInstallSoftwareForm.confirmPasswordPushInstall.$error.required && cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.confirmPasswordPushInstall)">
											<cv:msg key="error.confirmPassword" bundle="servers" /></span>
										<span class="cv-help-block"
											data-ng-if="!pushInstallSoftwareForm.confirmPasswordPushInstall.$error.required && !cv.pushInstallSoftwareForm.confirmPasswordPushInstall.$error.cvEquals && cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.confirmPasswordPushInstall)">
											<cv:msg key="error.mismatchedPassword" bundle="users" /></span>
									</div>
								</div>
							</div> <!-- end of !isAuthenticated & !isResponse -->
							<div class="cv-modal-wrapper" data-ng-if="useAgent === 'FS'">
								<label class="cv-label" for="planId">{{'tableHeader.plan' | cvLoc}}<span class="optional-text"><cv:msg key="label.optional" bundle="users" /></span></label>
								<div class="cv-inline-wrapper width-60-percentage" data-ng-disabled="noPlansToChoose">
									<!-- Hidden select used for form validation -->
									<select id="planId" name="planId" data-ng-hide="true" data-ng-options="plan.plan.planId as plan.plan.planName for plan in fsPlans" data-ng-model="model.planId" >
										<option value="">{{'label.selectAPlan' | cvLoc}}</option>
									</select>
									<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.planId) || showError"><cv:msg key="error.noPlan" bundle="serversJs" /></span>
									<div class="padding-right-20">
										<isteven-multi-select id="pushInstallDialog_isteven-multi-select_#6885" 
												input-model="fsPlans"
												button-label="label"
												item-label="label"
												selection-mode="single"
												search-property="label localizedSubtype"
												tick-property="checked"
												disable-property="disabled"
												group-property="subtypeGroup"
												class="isteven-multi-select user-group-select"
												helper-elements="filter"
												translation="localLang"
												on-item-click="selectOnePlan(data)">
										</isteven-multi-select>
									</div>
								</div>
							</div>
							<div class="cv-modal-wrapper" data-ng-if="useAgent==='SHAREPOINT' || useAgent==='ACTIVE_DIRECTORY'">
								<label class="cv-label" for="planId">{{'label.selectAPlan' | cvLoc}}</label>
								<div class="cv-inline-wrapper width-60-percentage" data-ng-disabled="noPlansToChoose">
									<label class="select-label">
										<select id="planId" name="planId" class="modal-select" data-ng-options="plan.plan.planId as plan.plan.planName for plan in fsPlans" data-ng-model="model.planId" required data-ng-class="{'has-error': cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.planId)}">
											<option value="">{{'label.selectAPlan' | cvLoc}}</option>
										</select>
									</label>
									<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.planId) || showError"><cv:msg key="error.noPlan" bundle="sharepoint" /></span>
								</div>
							</div>
			
							<div data-ng-if="!isAuthenticated && showOsType">
								<div class="cv-modal-wrapper">
									<label class="cv-label" for="osTypeWINDOWS"><cv:msg key="label.osType" bundle="serversJs"/></label>
									<div class="cv-inline-wrapper width-60-percentage">
										<label class="inline-label no-margin">
											<input type="radio" id="osTypeWINDOWS" class="no-float-auto" data-ng-model="model.osType" value="WINDOWS" name="osType" data-ng-change="updateAvailableAgents()" />
											<cv:msg key="label.osType.windows" bundle="serversJs" />
										</label>
										<label class="inline-label">
												<input type="radio" id="osTypeUNIX" class="no-float-auto" data-ng-model="model.osType" value="UNIX" name="osType" data-ng-change="updateAvailableAgents()" />
												<cv:msg key="label.osType.unixLinux" bundle="serversJs" />
										</label>
									</div>
								</div>
							</div>
							<div class="cv-modal-wrapper" data-ng-if="!useAgent">
								<label class="cv-label " data-ng-if="model.clientInfo.clientName" data-ng-class="{'word-wrap':!selectInstallType}"><cv:msg key="label.selectPackage" bundle="serversJs" /> {{model.clientInfo.clientName}}</label>
								<label class="cv-label width-auto" data-ng-if="!model.clientInfo.clientName" data-ng-class="{'word-wrap':!selectInstallType}"><cv:msg key="label.selectPackages" bundle="clients" /></label>
								<div class="cv-inline-wrapper width-60-percentage">
									<div class="padding-right-20">
										<isteven-multi-select
							   				  input-model="agents"
							   				  on-close="populatePlansDropdown()"
							  				  button-label="packageName"
							  				  item-label="packageName"
							   				  tick-property="checked"
							   				  disable-property="disabled"
											  hide-disabled-labels="true"
							   				  class="isteven-multi-select user-group-select"
							   				  id="agents"
							   				  name="agents"
							   				  helper-elements="all none reset filter"
											  max-labels="2"
											  on-item-click="selectSoftDependentPackages(data)"	 
							   				  translation="localLang">
										</isteven-multi-select>
									</div>
								</div>
							</div>
							<div class="cv-modal-wrapper" data-ng-if="cassandraExists">
								<label class="cv-label"><cv:msg key="label.cassVersion" bundle="bigData"/></label>
								<div class="cv-inline-wrapper width-60-percentage">
									<div class="padding-right-20">
										<isteven-multi-select
											input-model="cassVersions"
											output-model="model.cassVersion"
										   	button-label="label"
											item-label="label"
										   	selection-mode="single"
											tick-property="checked"
											disable-property="disabled"
											class="isteven-multi-select user-group-select"
											id="cassVersion"
											name="cassVersion"
											helper-elements="filter"
											translation="localLang">
										</isteven-multi-select>
									</div>
								</div>
							</div>
							<div class="cv-modal-wrapper" data-ng-if="selectInstallType && !hidePlanOption && !useAgent">
								<label class="cv-label word-wrap" ><cv:msg key="label.profile" bundle="profiles" /><span class="optional-text"><cv:msg key="label.optional" bundle="users" /></span></label>
								<div class="cv-inline-wrapper width-60-percentage">
									<div class="padding-right-20">
										<isteven-multi-select
							   				  input-model="planList"
							  				  button-label="planName"
											  item-label="planName"
							  				  selection-mode="single"
							   				  tick-property="checked"
							   				  disable-property="disabled"
							   				  class="isteven-multi-select user-group-select"
							   				  id="plans"
							   				  name="plans"
							   				  helper-elements="filter"
							   				  translation="localLang"
							   				  on-item-click="selectOnePlan(data)">
										</isteven-multi-select>
			
									</div>
								</div>
							</div>

							<div class="cv-modal-wrapper" data-ng-show="showUnixGroup">
								<label class="cv-label" for="unixGroup">
									<cv:msg key="label.unixGroup" bundle="oracle" />
									<span class="optional-text"><cv:msg key="label.optional" bundle="users" /></span>
									<cv-help-component help-text="<cv:msg key="help.unixGroup" bundle="oracle" />"></cv-help-component>
								</label>
								<div class="cv-inline-wrapper width-60-percentage">
									<input type="text" name="unixGroup" id="unixGroup" data-ng-model="model.clientInfo.uGroup" />
								</div>
							</div>
							<div class="cv-modal-wrapper" data-ng-if="model.isDB2Agent">
								<label class="cv-label" for="db2LogsText">
									<cv:msg key="label.db2LogPath" bundle="db2" />
								</label>
								<div class="cv-inline-wrapper width-60-percentage">
									<input type="text" name="db2LogsText" id="db2LogsText" data-ng-model="model.clientInfo.db2Logs" data-ng-required="true" />
									<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.db2LogsText) || showError"><cv:msg key="error.db2LogPath" bundle="db2" /></span>
								</div>
							</div>
							<div class="cv-modal-wrapper" data-ng-if="model.osType === 'UNIX'">
								<label class="cv-label" for="sshPortNumber"><cv:msg key="label.sshPortNumber" bundle="serversJs" /></label>
									<div class="cv-inline-wrapper width-60-percentage">
										<input type="number" min="1" name="sshPortNumber" id="sshPortNumber" data-ng-model="model.sshPortNumber" />
									</div>
							</div>
							<div data-ng-if="model.osType === 'UNIX'">
								<!-- START Push install using SSH key -->
									<label>
										<!-- didnot use cv-control becuase of click issue with it -->
										<toggle-control status="model.useSSHKey" data-ng-click="model.useSSHKey=!model.useSSHKey"></toggle-control>
										<span class="padding-left-10"><cv:msg key="label.useSSHKey" bundle="serversJs"/></span>
									</label>
									<div data-ng-if="model.useSSHKey" class="cv-modal-wrapper">
										<label class="cv-label"><cv:msg key="label.sshKeyPath" bundle="serversJs" /></label>
										<div class="cv-inline-wrapper width-60-percentage host-name-input-wrapper">
											<input id="{{ destLocation.local.id }}" class="display-inline" name="{{ destLocation.local.name }}" type="text" placeholder='<cv:msg key="label.enterSSHKey" bundle="serversJs"/>' data-ng-model="destLocation.local.path" data-ng-required="destLocation.local.required" data-ng-pattern="destLocation.local.pattern" autocomplete="off" />
											<span>
							            	<span data-ng-click="browse()" class="k-icon k-i-folder-more font-size-page-title"></span>
							            	<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm[destLocation.local.name]) || showError"><cv:msg key="error.path" bundle="profiles" /></span>
							            </span>
										</div>
							        </div>
									<label data-ng-if="model.useSSHKey">

										<toggle-control status="model.usePassphrase" data-ng-click="model.usePassphrase=!model.usePassphrase"></toggle-control>
										<span class="padding-left-10"><cv:msg key="label.usePassphrase" bundle="serversJs"/></span>
									</label>
									<div class="cv-modal-wrapper" data-ng-if="model.usePassphrase">
									<label class="cv-label" for="passphrase"><cv:msg key="label.passphrase" bundle="serversJs" /></label>
									<div class="cv-inline-wrapper width-60-percentage host-name-input-wrapper">
										<cv-password-preview value="model.sshPassphrase" form-name="pushInstallSoftwareForm" input-label="'label.enterPassphrase'" input-name="'sshPassphrase'" error="'error.passphrase'">
										</cv-password-preview>
										<!-- <input type="{{inputType}}" name="sshPassphrase" id="hostName" data-ng-model="model.sshPassphrase" required autoCompleteType="disable" autocomplete="off" placeholder='<cv:msg key="label.enterPassphrase" bundle="serversJs"/>' />
										<span data-ng-click="showHidePassphraseText()"><i class="k-icon k-i-eye"></i>
      									</span>
										<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.sshPassphrase) || showError"><cv:msg key="error.passphrase" bundle="serversJS" /></span> -->
									</div>
								</div>
							<!-- END -->
							</div>
							<div class="cv-modal-wrapper" ng-hide="clientId || clientGroupId">
                                <label class="cv-label" for="fakeinstalllocationremembered"><cv:msg key="label.installLocation" bundle="serversJs" />
                                     <span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span></label>
                                    <div class="cv-inline-wrapper width-60-percentage">
                                        <input type="text" name="fakeinstalllocationremembered" id="fakeinstalllocationremembered" data-ng-model="model.installDirectory"  autoCompleteType="disable" autocomplete="off" data-ng-change="validateInstallDirPath()" placeholder='<cv:msg key="label.enterInstallLocation" bundle="serversJs"/>' />
                                        <span class="cv-help-block" data-ng-show="errors.installDirectory.invalidPath"><cv:msg key="error.installLocation" bundle="serversJs" /></span>
                                    </div>
							</div>
							<div class="cv-modal-wrapper margin-top-15" data-ng-if="showWebServerOption">
								<div class="cv-help-block margin-left-10"  data-ng-if="errors.webserverEmpty && !selectedWebServer"><cv:msg key="error.needWebServer" bundle="messagesJs" /></div>
								<label class="col-sm-6 cv-label " data-ng-if="model.clientInfo.clientName" data-ng-class="{'word-wrap':!selectInstallType}"><cv:msg key="label.selectWebServer" bundle="messagesJs" />
									<span class="optional-text"><cv:msg key="label.required" bundle="messagesJs" /></span></label>
								</label>
								
								<div class="col-sm-6">
									<div class="padding-right-20">
										<isteven-multi-select
											input-model="webservers"
											button-label="clientName"
											item-label="clientName"
											tick-property="checked"
											selection-mode="single"
											disable-property="disabled"
											class="isteven-multi-select user-group-select"
											id="webserver"
											name="webserver"
											helper-elements="none"
											on-item-click="selectWebServer(data)"
											translation="localLang">
										</isteven-multi-select>
									</div>
								</div>
							</div>
							<div data-ng-if="!hideRebootOption">
								<label>
									<cv-toggle toggle-name="forceReboot" toggle-label="label.foreceReboot" value="model.forceReboot"></cv-toggle>
								</label>
								
							</div>
						</div>
					</div>
				</div> <!--  end of push install   -->
	 			<div data-ng-switch-when="dock">
					<div class="cv-modal-wrapper select-mode" data-ng-class="{'interactive-install-link':selectInstallType}">
						<label class="cv-label" for="clientName"><cv:msg key="label.clientName" bundle="serversJs" /></label>
						<div class="cv-inline-wrapper width-60-percentage">
						<input type="text" name="clientName"  id="clientName" data-ng-model="dockInfo.clientName" required data-ng-class="{'has-error': cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.clientName)}" />
						<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.clientName) || showError"><cv:msg key="error.clientName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label" for="hostName"><cv:msg key="label.hostName" bundle="serversJs"/></label>
						<div class="cv-inline-wrapper width-60-percentage">
							<input type="text" name="hostName"  id="hostName" data-ng-model="dockInfo.hostName" required data-ng-class="{'has-error': cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.hostName)}" />
							<span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm.hostName) || showError"><cv:msg key="error.hostName" bundle="serversJs" /></span>
						</div>
					</div>
				</div><!-- end of dock install --> 
				<div class="cv-modal-wrapper" data-ng-if="!disableInteractiveInstall && selectInstallType">
					<p class="info-text text-center interactive-install-link">
						<cv:msg key="info.interactiveInstallation" bundle="serversJs" />
						<a href="{{downloadLink}}" target="_blank"><cv:msg key="label.here" bundle="messagesJs" /></a>.
					</p>
				</div>
				
				<div ng-if="clientId || clientGroupId" class="padding-left-20">
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</div>

				<div class="button-container">
					<button id="pushInstallDialog_button_#3750" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="skipSetup()" data-ng-if="showSkip"><cv:msg key="action.skip" bundle="profiles" /></button> 
					<button id="pushInstallDialog_button_#9360" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
					<button id="pushInstallDialog_button_#2249" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-if="model.installType=='push'"  data-ng-disabled="(!useAgent && !((agents | filter: {checked:true}).length))  || (selectInstallType && !model.planId && !hidePlanOption)">
						<span data-ng-if="!skipForSetup"><cv:msg key="label.install" bundle="servers" /></span>
						<span data-ng-if="skipForSetup"><cv:msg key="Save" bundle="messages" /></span>
					</button>
					<button id="pushInstallDialog_button_#7782" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-if="model.installType=='dock'" > 
						<span data-ng-if="!skipForSetup"><cv:msg key="label.install" bundle="servers" /></span>
					</button>
				</div>
			</form>
			<div class="button-container" data-ng-show="formConfig.hide">
					<button id="pushInstallDialog_button_#8239" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="changeConfig()"><cv:msg key="label.addAnotherServer" bundle="servers" /></button> 
					<button id="pushInstallDialog_button_#4175" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skipSetup()"><cv:msg key="action.skip" bundle="profiles" /></button> 
					<button id="pushInstallDialog_button_#1012" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="saveAndContinue()"><cv:msg key="Continue" bundle="messages" /></button> 
			</div>
		</div>
		<div data-ng-if="isResponse">
			<p   data-ng-bind-html="responseContent" data-ng-if="!showJobProgress"></p>
			<push-install-job-progress data-ng-if="showJobProgress" job-id="{{installJobId}}" banner="{{responseContent}}"></push-install-job-progress>
			<div class="button-container">
				<button id="pushInstallDialog_button_#4180" type="submit" class="btn btn-primary" data-ng-disabled="" data-ng-click="close()"><cv:msg key="OK" /></button> 
			</div>
		</div>
	</div>
</div>
