<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<div data-ng-controller="pushInstallController">
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
        <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
        <cv:cvMessages bundle="localization.users"></cv:cvMessages>
        <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1 data-ng-if="!isAuthenticated">
			<span>{{dialogTitle}}<cv-help-component data-help-text="{{dialogTitleHelpText}}"></cv-help-component></span>
		</h1>
		<h1 data-ng-if="isAuthenticated">
			<cv:msg key="action.addSoftware" bundle="servers" />
			<cv-help-component data-help-text="<cv:msg key="label.addSoftwareHelpText" bundle="servers" />"></cv-help-component>
		</h1>
	</div>
	<div class="setup-content medium-width" data-ng-class="{'reduced-padding-top' : selectInstallType, 'epic-server': isEpicServer}">
		<div data-ng-if="!isResponse">
			<div>
				<p class="{{serverConfigMessage.type}} serverMessage">{{serverConfigMessage.message}}</p>
			</div>
			<div data-ng-show="formConfig.hide && showAssociations">
					<h5 data-ng-hide="showPushInstallJobInfo" class="text-left font-weight-bold"><cv:msg key="label.serverAlreadyAdded" bundle="servers"/></h5>
					<p class="text-left"><cv:msg key="label.processBelowStatus" bundle="servers"/></p>
					<cv-grid data-ng-if="gridOptions" cv-grid-options="gridOptions"></cv-grid>
			</div>
			<div class="margin-top-35-minus" data-ng-if="showPushInstallJobInfo">
				<p><cv:msg key="notification.pushInstall" bundle="serversJs" /></p>
				<a ng-href="#/jobs/{{installJobID}}"><cv:msg key="notification.jobDetails" bundle="serversJs" /></a>
			</div>
			<div class="list-group-item" data-ng-show="formConfig.hide && !showAssociations && !showPushInstallJobInfo">
					<h5 class="text-left font-weight-bold"><cv:msg key="label.serverAlreadyAdded" bundle="servers" /></h5>
					<p class="text-left" ng-if="serverPlanMap && serverPlanMap.length"><cv:msg key="label.serverPlanAssociaton" bundle="servers" params="{{serverPlanMap[0].clientInfo.client.clientEntity.clientName}},{{serverPlanMap[0].plan.planName}}" /></p>
			</div>
			<form name="pushInstallSoftwareForm" novalidate cv-submit="installSoftware()" autocomplete="off" data-ng-hide="formConfig.hide">
				<div data-ng-if="selectInstallType && !isEpicServer" class="select-icon-longDesc" data-ng-disabled="disableInstallSelect">
					<label class="row select-oneType" data-ng-class="{checked:(model.installType=='push')}">
						<input class="no-float-auto col-md-1" type="radio" data-ng-model="model.installType" value="push" data-ng-change="updateInstallType('push')">
						<span class="col-md-2"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 15.38" width="64" height="30"><path  d="M10.17,2.94H1a.53.53,0,0,0-.53.53V9.14A.53.53,0,0,0,1,9.67H4.45l-.17,1.56H2.53v.57H8.83v-.56H7.19L7,9.67h3.16a.53.53,0,0,0,.53-.53V3.47A.54.54,0,0,0,10.17,2.94Zm0,6.2H1V3.48h9.22Z"/><polygon  points="23.37 7.72 14.23 7.72 14.23 6.75 11.99 8.04 14.23 9.34 14.23 8.37 23.37 8.37 23.37 7.72"/><path  d="M31.45,13.46H25.08a.26.26,0,0,1-.26-.26V1.6a.26.26,0,0,1,.26-.26h6.37a.26.26,0,0,1,.26.26V13.2A.26.26,0,0,1,31.45,13.46Zm-6.11-.52h5.85V1.86H25.34Z"/><path  d="M30.65,4H25.9a.2.2,0,0,1,0-.41h4.75a.2.2,0,0,1,0,.41Z"/><path  d="M30.65,4.74H25.9a.2.2,0,0,1,0-.41h4.75a.2.2,0,0,1,0,.41Z"/><path  d="M30.68,10.53H25.93a.2.2,0,1,1,0-.41h4.75a.2.2,0,0,1,0,.41Z"/><path  d="M30.68,11.3H25.93a.2.2,0,1,1,0-.41h4.75a.2.2,0,0,1,.2.2A.2.2,0,0,1,30.68,11.3Z"/><path  d="M28.87,2.42h-.57a.08.08,0,0,0-.08.08v.57a.08.08,0,0,0,.08.08h.57A.08.08,0,0,0,29,3.08V2.51A.08.08,0,0,0,28.87,2.42ZM28.39,3V2.59h.41V3Z"/><path  d="M30.72,2.42h-.57a.08.08,0,0,0-.08.08v.57a.08.08,0,0,0,.08.08h.57a.08.08,0,0,0,.08-.08V2.51A.08.08,0,0,0,30.72,2.42ZM30.23,3V2.59h.41V3Z"/><path  d="M27.09,5.9a.82.82,0,1,0,.82.82A.82.82,0,0,0,27.09,5.9Zm0,1.31a.49.49,0,1,1,.49-.49A.49.49,0,0,1,27.09,7.21Z"/><path  d="M29.61,5.9a.82.82,0,1,0,.82.82A.82.82,0,0,0,29.61,5.9Zm0,1.31a.49.49,0,1,1,.49-.49A.49.49,0,0,1,29.61,7.21Z"/><path  d="M21,2.53,20.64.76a.38.38,0,0,0-.37-.3h0l-4.54,0a.38.38,0,0,0-.37.3L15,2.5V6.17a.37.37,0,0,0,.37.37h5.33A.37.37,0,0,0,21,6.17ZM20.26.85l.39,1.71H18.19V.85Zm-4.54,0h2.08V2.56H15.34v0Zm-.38,5.3V2.76h5.31l0,3.4Z"/><path  d="M19.27,4.68V4.32h-.38A.89.89,0,0,0,18.78,4l.27-.27-.3-.3-.27.27a.9.9,0,0,0-.29-.12V3.23h-.36v.38a.9.9,0,0,0-.29.12l-.27-.27-.3.3.27.27a.91.91,0,0,0-.12.29h-.38v.36h.38a.9.9,0,0,0,.12.29L17,5.25l.3.3.27-.27a.9.9,0,0,0,.29.12v.38h.36V5.39a.9.9,0,0,0,.29-.12l.27.27.3-.3L18.78,5a.9.9,0,0,0,.12-.29h.38ZM18,4.86a.36.36,0,1,1,.36-.36A.36.36,0,0,1,18,4.86Z"/></svg>
						</span>
						<span class="col-md-9 select-desc"><cv:msg key="desc.pullInstall" bundle="servers"/></span>
					</label>
					<label data-ng-if="!isEpicServer" class="row select-oneType"  data-ng-class="{checked:(model.installType=='existing')}">
						<input class="no-float-auto col-md-1"  type="radio" data-ng-model="model.installType" value="existing" data-ng-change="updateInstallType('existing')">
						<span class="col-md-2"><svg xmlns="http://www.w3.org/2000/svg" width="64" height="30"><path fill="none" d="M1.086 19.466h18.786l.103-11.595H1.086z"/><circle fill="none" cx="54.535" cy="14.509" r="1.004"/><path fill="none" d="M60.968 6.048h.84v.84h-.84z"/><circle fill="none" cx="59.698" cy="14.509" r="1.003"/><path fill="none" d="M50.95 27.251h11.984V4.552H50.95v22.699zm10.961-3.36l-.021.001h-9.73a.42.42 0 110-.84h9.73a.41.41 0 01.41.409.41.41 0 01-.389.43zm-.021-1.578h-9.73a.42.42 0 110-.84h9.73a.42.42 0 110 .84zm-9.035-7.804a1.68 1.68 0 113.36-.002 1.68 1.68 0 01-3.36.002zm5.163 0a1.68 1.68 0 113.36-.002 1.68 1.68 0 01-3.36.002zm2.623-8.646c0-.091.073-.164.163-.164h1.168l.021.001c.09.012.154.094.143.184V7.03a.163.163 0 01-.164.164h-1.168a.163.163 0 01-.163-.164V5.863zm-3.79 0c0-.091.073-.164.163-.164h1.168a.165.165 0 01.19-.035c.082.04.115.138.076.22v1.167a.163.163 0 01-.266.143h-1.168a.163.163 0 01-.163-.164V5.863zm-4.753 2.233h9.73a.42.42 0 110 .84h-9.73a.42.42 0 110-.84zm0 1.516h9.73a.42.42 0 110 .84h-9.73a.42.42 0 110-.84z"/><path fill="none" d="M57.198 6.048h.84v.84h-.84z"/><path d="M19.872 6.765H1.086C.486 6.765 0 7.251 0 7.851v11.615c0 .6.486 1.086 1.086 1.086h7.068l-.349 3.196H4.22v1.167h12.907v-1.146h-3.36l-.389-3.217h6.474c.6 0 1.086-.486 1.086-1.086V7.851a1.107 1.107 0 00-1.066-1.086zm0 12.701H1.086V7.871h18.889l-.103 11.595zM63.468 3.486h-13.05a.532.532 0 00-.533.533v23.765c0 .294.238.532.533.532h13.05a.532.532 0 00.532-.532V4.02a.533.533 0 00-.532-.534zm-.533 23.765H50.95V4.552h11.984v22.699z"/><path d="M52.098 8.936h9.73a.42.42 0 100-.84h-9.73a.42.42 0 100 .84zM52.098 10.452h9.73a.42.42 0 100-.84h-9.73a.42.42 0 100 .84zM61.89 21.474h-9.73a.42.42 0 100 .84h9.73a.42.42 0 100-.84zM61.89 23.052h-9.73a.42.42 0 100 .84h9.73l.021-.001a.41.41 0 00.389-.43.41.41 0 00-.41-.409zM57.014 7.194h1.168c.07.058.174.047.23-.023a.168.168 0 00.036-.12V5.884a.165.165 0 00-.076-.22.165.165 0 00-.19.035h-1.168a.163.163 0 00-.163.164V7.03c0 .091.073.164.163.164zm.184-1.146h.84v.84h-.84v-.84zM60.804 7.194h1.168a.163.163 0 00.164-.164V5.884a.165.165 0 00-.143-.184l-.021-.001h-1.168a.163.163 0 00-.163.164V7.03c0 .091.073.164.163.164zm.164-1.146h.84v.84h-.84v-.84zM56.215 14.509a1.68 1.68 0 10-3.36-.002 1.68 1.68 0 003.36.002zm-2.684 0a1.003 1.003 0 112.007-.001 1.003 1.003 0 01-2.007.001zM61.378 14.509a1.68 1.68 0 10-3.36-.002 1.68 1.68 0 003.36.002zm-2.684 0a1.003 1.003 0 112.006-.002 1.003 1.003 0 01-2.006.002zM29.75 14.059h10.919a.757.757 0 00.614-.758V5.844l-.737-3.627a.78.78 0 00-.758-.614h-9.301a.779.779 0 00-.758.614l-.737 3.565v7.519c0 .418.339.758.758.758zm5.776-11.658h4.241l.799 3.504h-5.04V2.401zm-5.059 0h4.261v3.504h-5.04l.779-3.504zm-.779 3.913h10.878v6.966l-10.878-.02V6.314z"/><path d="M37.76 10.31l-.021-.062v-.737h-.778a1.804 1.804 0 00-.226-.656l.554-.553-.615-.614-.553.552a1.87 1.87 0 00-.595-.246v-.717h-.737v.778c-.211.047-.412.13-.594.246l-.554-.553-.614.614.554.553a1.87 1.87 0 00-.246.595h-.778v.737h.778c.046.211.13.412.246.594l-.492.574.614.614.554-.553c.182.116.383.199.594.245v.779h.737v-.8c.211-.046.412-.129.595-.245l.553.553.614-.614-.614-.492c.116-.182.199-.383.246-.594h.778zm-2.622.307a.738.738 0 11.002-1.476.738.738 0 01-.002 1.476zM42.937 16.477H27.414v-1.989l-4.589 2.644 4.589 2.663v-1.987h15.523v1.987l4.588-2.643-4.588-2.664zM14.613 12.298l-.519-2.195a.5.5 0 00-.479-.379H7.631a.499.499 0 00-.479.379l-.439 2.195v4.828a.48.48 0 00.479.479h6.942a.48.48 0 00.479-.479v-4.828zm-.997-1.995l.499 2.214h-3.232v-2.214h2.733zm-5.985 0h2.793v2.135H7.212l.419-2.135zm-.399 6.823v-4.429h6.883v4.409l-6.883.02z"/><path d="M12.419 15.19v-.479H11.9a1.212 1.212 0 00-.159-.419l.379-.379-.419-.419-.379.379a1.24 1.24 0 00-.439-.14v-.519h-.439v.519c-.141.03-.276.083-.399.16l-.379-.379-.419.419.379.359c-.076.122-.13.258-.16.398h-.578v.499h.519c.029.142.083.276.16.399l-.379.379.479.319.379-.38c.123.076.258.131.399.16v.618h.439v-.519c.142-.029.276-.084.399-.159l.419.278.419-.419-.379-.379c.076-.122.13-.258.159-.398h.519v.102h-.001zm-1.735.24a.5.5 0 11.499-.499.5.5 0 01-.479.519l-.021.001v-.021z"/></svg>
						</span>
						<span class="col-md-9 select-desc"ng-bind="'label.install.existingServer' | cvLoc"></span>
                    </label>
				</div> <!-- end of selectInstall -->

				<!-- Epic selectInstall -->
					<div data-ng-if=" selectInstallType && isEpicServer" class="text-align-left padding-left-20">
						<cv-radio-group id="installType"  radio-model="model.installType" radio-obj="model.installTypeList"  ></cv-radio-group>
					</div>
				<!-- End of Epic selectInstall -->

				<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
				<div>
					<div class="panel panel-default">
						<div data-ng-class="{'panel-body' : showPanel}">
                            <div ng-if="!selectInstallType"  class="margin-bottom-15 margin-left-20">
                                <cv-radio-group   radio-model="model.installType" radio-obj="model.installTypeList"  ></cv-radio-group>
                            </div>

			                <cv-plain-accordion  data-ng-if="useAgent === 'FS'" accordion-label="label.serverConfiguration" disable-collapse={{serverInfoDisableCollapsed}} collapsed="status.serverInfoCollapsed">
                                <div data-ng-if="!isAuthenticated && !isResponse && model.installType == 'push'">
                                    <!-- server name is not needed in the UI, host name is server name -->
                                    <div class="cv-modal-wrapper add-device-hostname select-mode">
                                        <label class="cv-label" for="hostName"><cv:msg key="label.hostName" bundle="serversJs"/></label>
                                        <div ng-init="model.hostname=''" class="cv-inline-wrapper host-name-input-wrapper">
                                            <input class="display-inline" ng-blur="addHostName()" type="text" name="hostName" id="hostName" data-ng-model="model.hostname"
                                                autocompletetype="disable" autocomplete="off"  placeholder='<cv:msg key="label.enterHostName" bundle="serversJs"/>'>
                                            <span ng-disabled="!model.hostname">
                                                <span  class="k-icon k-i-plus cursor-pointer" id="add-host-name" title="Add" ng-click="addHostName()"></span>
                                            </span>
                                            <div class="cv-help-block"  data-ng-if="errors.hostname.emptyHostNames" ng-bind="'error.atLeastOneHostName' | cvLoc"></div>
                                            <div class="cv-help-block"  data-ng-if="errors.hostname.alreadyExist" ng-bind="'error.hostNameExist' | cvLoc"></div>
                                            <div class="cv-help-block"  data-ng-if="errors.hostname.validHostName" ng-bind="'error.validHostName' | cvLoc"></div>
                                            <div ng-repeat="hostname in model.hostNames" class="info-tag">
                                               <div class="cv-flex">
                                                    <span title="{{hostname}}" class="crop" ng-bind="hostname"></span>
                                                    <span>
                                                        <a class="close-icon k-icon k-i-close cursor-pointer" ng-click="removeHostName($index)"></a>
                                                    </span>
                                               </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="cv-modal-wrapper">
                                        <label class="cv-label" for="fakeusernameremembered"><cv:msg key="label.userName" bundle="serversJs" />
                                            <cv-help-component data-ng-if="!isEpicServer" help-text="{{usernameHelpText}}"></cv-help-component>
                                        </label>
                                        <div class="cv-inline-wrapper">
                                            <input type="text" name="fakeusernameremembered" id="fakeusernameremembered" data-ng-model="model.clientInfo.vsUserName"  autoCompleteType="disable" autocomplete="off" placeholder="{{usernameHelpText}}" />
                                            <span class="cv-help-block" data-ng-if="errors.userName"><cv:msg key="error.userName" bundle="servers" /></span>
                                        </div>
                                    </div>
                                    <div data-ng-if="!model.usePassphrase" class="cv-modal-wrapper">
                                        <label class="cv-label" for="fakepasswordremembered"><cv:msg key="label.password" bundle="servers" /></label>
                                        <div class="cv-inline-wrapper">
                                            <input type="password" name="fakepasswordremembered" id="fakepasswordremembered" data-ng-model="model.clientInfo.vsPassword"  autoCompleteType="disable" autocomplete="off" />
                                            <span class="cv-help-block"  data-ng-if="errors.password"><cv:msg key="error.password" bundle="servers" /></span>
                                        </div>
                                    </div>
                                    <div data-ng-if="!model.usePassphrase" class="cv-modal-wrapper">
                                        <label class="cv-label" for="confirmPasswordPushInstall"><cv:msg key="label.confirmPassword" bundle="servers" /></label>
                                        <div class="cv-inline-wrapper">
                                            <input type="password" name="confirmPasswordPushInstall" id="confirmPasswordPushInstall" data-ng-model="model.clientInfo.confirmPassword"
                                                 autoCompleteType="disable" autocomplete="off" />
                                            <span class="cv-help-block"  data-ng-if="errors.confirmPassword">
                                                <cv:msg key="error.confirmPassword" bundle="servers" /></span>
                                            <span class="cv-help-block"  data-ng-if="errors.passwordMismatch">
                                                <cv:msg key="error.mismatchedPassword" bundle="users" /></span>
                                        </div>
                                    </div>
                                </div> <!-- end of !isAuthenticated & !isResponse -->

                                <div data-ng-if="!isAuthenticated && showOsType">
                                    <div class="cv-modal-wrapper">
                                        <label class="cv-label" for="osTypeWINDOWS"><cv:msg key="label.osType" bundle="serversJs"/></label>
                                        <div class="cv-inline-wrapper">
                                            <label class="inline-label no-margin">
                                                <input type="radio" id="osTypeWINDOWS" class="no-float-auto" data-ng-model="model.osType" value="WINDOWS" name="osType" data-ng-change="updateAvailableAgents()" />
                                                <cv:msg key="label.osType.windows" bundle="serversJs" />
                                            </label>
                                            <label class="inline-label">
                                                    <input type="radio" id="osTypeUNIX" class="no-float-auto" data-ng-model="model.osType" value="UNIX" name="osType" data-ng-change="updateAvailableAgents()" />
                                                    <cv:msg key="label.osType.unixLinux" bundle="serversJs" />
                                            </label>
                                        </div>
                                    </div>
                                </div>


                                <div ng-if="model.installType == 'existing'" class="cv-modal-wrapper margin-bottom-10 margin-top-10" >
                                        <label class="cv-label" ng-bind="'label.servers' | cvLoc"></label>
                                        <div class="cv-inline-wrapper">
                                            <div ng-if="model.osType === 'WINDOWS'" class="padding-right-20">
                                                <isteven-multi-select id="fsPushInstallDialog_isteven-multi-select_#685585"
                                                    ng-if="windowsServersLoaded && windowsServers.length"
                                                    input-model="windowsServers"
                                                    output-model="model.windowsServersSelected"
                                                    button-label="name"
                                                    item-label="name"
                                                    search-property="name"
                                                    tick-property="selected"
                                                    class="isteven-multi-select user-group-select"
                                                    helper-elements="all none filter"
                                                    translation="localLang">
                                                </isteven-multi-select>
                                                <div ng-if="!windowsServersLoaded" class="margin-top-10 margin-left-25"><img src="${pageContext.request.contextPath}/img/loading.gif"></div>
                                                <div ng-if="windowsEligibleServerLoadingError" class="cv-help-block margin-top-10 margin-bottom-0" ng-bind="'error.loadWindowsServer' | cvLoc"></div>
                                                <div ng-if="windowsServers && !windowsServers.length" class="cv-help-block margin-top-10 margin-bottom-0" ng-bind="'error.eligibleWindowsServer' | cvLoc"></div>
                                                <div ng-if="errors.windowsServerSelected" class="cv-help-block margin-top-5" ng-bind="'error.select.server' | cvLoc"></div>
                                            </div>
                                            <div ng-if=" model.osType === 'UNIX'" class="padding-right-20">
                                                <isteven-multi-select id="fsPushInstallDialog_isteven-multi-select_#685585567"
                                                    ng-if="unixServersLoaded && unixServers.length"
                                                    input-model="unixServers"
                                                    output-model="model.unixServersSelected"
                                                    button-label="name"
                                                    item-label="name"
                                                    search-property="name"
                                                    tick-property="selected"
                                                    class="isteven-multi-select user-group-select"
                                                    helper-elements="all none filter"
                                                    translation="localLang">
                                                </isteven-multi-select>
                                                <div ng-if="!unixServersLoaded" class="margin-top-10 margin-left-25"><img src="${pageContext.request.contextPath}/img/loading.gif"></div>
                                                <div ng-if="unixServers && !unixServers.length" class="cv-help-block margin-top-10 margin-bottom-0" ng-bind="'error.eligibleUnixServer' | cvLoc"></div>
                                                <div ng-if="unixEligibleServerLoadingError" class="cv-help-block margin-top-10 margin-bottom-0" ng-bind="'error.loadUnixServer' | cvLoc"></div>
                                                <div ng-if="errors.unixServerSelected" class="cv-help-block margin-top-5" ng-bind="'error.select.server' | cvLoc"></div>
                                            </div>

                                        </div>
                                    </div>

                                <label data-ng-if="(model.osType === 'UNIX' && model.installType == 'push')">
                                    <cv-toggle toggle-name="enableSSHPort" toggle-label="label.userSSHPortNumber" value="model.enableSSHPort"></cv-toggle>
                                </label>
                                <div class="cv-modal-wrapper" data-ng-if="model.osType === 'UNIX' && model.enableSSHPort">
                                    <label class="cv-label" for="sshPortNumber"><cv:msg key="label.sshPortNumber" bundle="serversJs" /></label>
                                        <div class="cv-inline-wrapper">
                                            <input type="number" min="1" name="sshPortNumber" id="sshPortNumber" data-ng-model="model.sshPortNumber" />
                                        </div>
                                </div>
                                 <label data-ng-if="model.osType === 'UNIX' && !(isEpicServer && model.installType=='existing')">
                                        <toggle-control status="model.useSSHKey" data-ng-click="model.useSSHKey=!model.useSSHKey"></toggle-control>
                                        <span class="padding-left-10"><cv:msg key="label.useSSHKey" bundle="serversJs"/></span>
                                    </label>
                                <div data-ng-if="model.osType === 'UNIX'">
                              		  <!-- START Push install using SSH key -->
                                    <div data-ng-if="model.useSSHKey" class="cv-modal-wrapper">
                                        <label class="cv-label"><cv:msg key="label.sshKeyPath" bundle="serversJs" /></label>
                                        <div class="cv-inline-wrapper width-60-percentage host-name-input-wrapper">
                                            <input id="{{ destLocation.local.id }}" class="display-inline" name="{{ destLocation.local.name }}" type="text" placeholder='<cv:msg key="label.enterSSHKey" bundle="serversJs"/>' data-ng-model="destLocation.local.path" data-ng-required="destLocation.local.required" data-ng-pattern="destLocation.local.pattern" autocomplete="off" />
                                            <span>
                                            <span data-ng-click="browse()" class="k-icon k-i-folder-more font-size-page-title"></span>
                                            <span class="cv-help-block" data-ng-show="cv.pushInstallSoftwareForm.needsAttention(pushInstallSoftwareForm[destLocation.local.name]) || showError"><cv:msg key="error.path" bundle="profiles" /></span>
                                        </span>
                                        </div>
                                    </div>
                                    <label data-ng-if="model.useSSHKey">
                                        <toggle-control status="model.usePassphrase" data-ng-click="model.usePassphrase=!model.usePassphrase"></toggle-control>
                                        <span class="padding-left-10"><cv:msg key="label.usePassphrase" bundle="serversJs"/></span>
                                    </label>
                                    <div class="cv-modal-wrapper" data-ng-if="model.usePassphrase">
                                    <label class="cv-label" for="passphrase"><cv:msg key="label.passphrase" bundle="serversJs" /></label>
                                    <div class="cv-inline-wrapper width-60-percentage host-name-input-wrapper">
                                        <cv-password-preview value="model.sshPassphrase" form-name="pushInstallSoftwareForm" input-label="'label.enterPassphrase'" input-name="'sshPassphrase'" error="'error.passphrase'">
                                        </cv-password-preview>
                                    </div>
                                </div>
                            <!-- END -->
                            </div>
                                <div class="cv-modal-wrapper" data-ng-if="!(isEpicServer && model.installType=='existing')">
                                    <label class="cv-label" for="fakeinstalllocationremembered"><cv:msg key="label.installLocation" bundle="serversJs" />
                                        <span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span></label>
                                        <div class="cv-inline-wrapper">
                                            <input type="text" name="fakeinstalllocationremembered" id="fakeinstalllocationremembered" data-ng-model="model.installDirectory"  autoCompleteType="disable" autocomplete="off" data-ng-change="validateInstallDirPath()" placeholder='<cv:msg key="label.enterInstallLocation" bundle="serversJs"/>' />
                                            <span class="cv-help-block" data-ng-show="errors.installDirectory.invalidPath"><cv:msg key="error.installLocation" bundle="serversJs" /></span>
                                        </div>
                                </div>
                                <div data-ng-if="!hideRebootOption && !(isEpicServer && model.installType=='existing')">
                                    <label>
                                        <cv-toggle toggle-name="forceReboot" toggle-label="label.foreceReboot" value="model.forceReboot"></cv-toggle>
                                    </label>
                                </div>
                                <div class="cv-modal-wrapper" data-ng-if="!disableInteractiveInstall && selectInstallType && model.installType =='push'">
                                    <p class="info-text text-center interactive-install-link">
                                        <cv:msg key="info.interactiveInstallation" bundle="serversJs" />
                                        <a href="{{downloadLink}}" target="_blank"><cv:msg key="label.here" bundle="messagesJs" /></a>.
                                    </p>
                                </div>

							 </cv-plain-accordion>

                            <cv-plain-accordion accordion-label="header.backupConfiguration" collapsed="status.backupConfigurationCollapsed">
                                <div class="cv-modal-wrapper" data-ng-if="!(isEpicServer && model.installType=='existing')">
                                    <label class="cv-label" for="planId">{{'tableHeader.plan' | cvLoc}}<span data-ng-if="!isEpicServer" class="optional-text"><cv:msg key="label.optional" bundle="users" /></span></label>
                                    <div class="cv-inline-wrapper">
                                        <div class="padding-right-20">
                                            <cv-plan-summary-dropdown
                                                ng-if="fsPlanLoaded"
                                                input-model="fsPlans"
                                                disable-property="'disabled'"
                                                search-property="'label'"
                                                item-label="'label'"
                                                button-label="'label'"
                                                tick-property="'checked'"
                                                max-labels="1"
                                                helper-elements="'filter'"
                                                group-property="'subtypeGroup'"
                                                selection-mode="'single'"
                                                directive-id="'add-fs-server-plan-select'"
                                                on-item-clicked="selectOnePlan(selectedPlan)"
                                                class="isteven-multi-select user-group-select">
                                        </cv-plan-summary-dropdown>
                                        <span data-ng-if="isEpicServer" class="cv-help-block" data-ng-show="errors.planEmpty"><cv:msg key="error.selectPlan" bundle="servers" /></span>
                                        <div ng-if="!fsPlanLoaded" class="margin-top-10 margin-left-25"><img src="${pageContext.request.contextPath}/img/loading.gif"></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="cv-modal-wrapper margin-top-10" ng-if="model.planId > 0  && useAgent === 'FS'">
                                    <div  class="margin-top-10">
                                        <label ng-if="planPreviewEntity.isPlanHaveBackupContent" class="margin-left-10" ng-bind="'label.backupContentPlan' | cvLoc">
                                        </label>
                                        <plan-content-preview custom-class="margin-left-10 margin-bottom-20" plan-preview-entity="planPreviewEntity"></plan-content-preview>
                                    </div>
                                    <div ng-if="planPreviewEntity.isPlanHaveBackupContent"  class="margin-left-10">
                                        <toggle-control status="model.overrideBackupContent ? 'enabled-activity' : 'disabled-activity'"
                                            data-ng-click="toggleOverrideBackupContent()">
                                        </toggle-control>
                                        <cv-help-text data-ng-click="toggleOverrideBackupContent()" class="margin-left-10" help-label="{{'label.defineContent' | cvLoc}}"
                                            help-text="'label.overrideBackupContent.helpText' | cvLoc" help-direction="top">
                                        </cv-help-text>
                                    </div>

                                    <div ng-if="contentOptions && contentEntities" class="margin-top-10">
                                        <div ng-show="model.overrideBackupContent || !planPreviewEntity.isPlanHaveBackupContent" class="modal-list bootstrap-wrapper padding-bottom-10 margin-left-10">
                                            <div> <span class="cv-help-block" data-ng-if="errors.emptyContent">
                                                <cv:msg key="error.addContent" bundle="fs" /></span></div>
                                            <cv-content-selection  data-options="contentOptions"
                                                data-content-entities="contentEntities">
                                            </cv-content-selection>
                                        </div>
                                    </div>
                                </div>
                            </cv-plain-accordion>
						</div>
					</div>
				</div> <!-- end of push install -->

				<div class="button-container">
					<button id="fsPushInstallDialog_button_#5063" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="skipSetup()" data-ng-if="showSkip"><cv:msg key="action.skip" bundle="profiles" /></button>
					<button id="fsPushInstallDialog_button_#8207" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" /></button>
                    <button id="fsPushInstallDialog_button_#3644" type="submit" class="btn btn-primary cvBusyOnAjax"  data-ng-disabled="isDisabled()">
						<span data-ng-if="!skipForSetup"><cv:msg key="label.install" bundle="servers" /></span>
						<span data-ng-if="skipForSetup"><cv:msg key="Save" bundle="messages" /></span>
					</button>
				</div>
			</form>
			<div class="button-container" data-ng-show="formConfig.hide">
					<button id="fsPushInstallDialog_button_#4735" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="changeConfig()"><cv:msg key="label.addAnotherServer" bundle="servers" /></button>
					<button id="fsPushInstallDialog_button_#8438" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skipSetup()"><cv:msg key="action.skip" bundle="profiles" /></button>
					<button id="fsPushInstallDialog_button_#9722" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="saveAndContinue()"><cv:msg key="Continue" bundle="messages" /></button>
			</div>
		</div>
	</div>
</div>