<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.job"></cv:cvMessages>
		<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
		
	</script>
	<div class="setup-title">
		<h1>
			<div data-ng-if="model.showCopySoftware"><cv:msg key="label.manageSoftware" bundle="settings" /></div>
			<div data-ng-if="!model.showCopySoftware"><cv:msg key="label.downloadSoftware" bundle="navJs" /></div>
			<cv-help-component data-help-text="<cv:msg key="label.downloadSoftwareHelpText" bundle="servers" />"></cv-help-component>
		</h1>
	</div>
	<div class="bootstrap-wrapper">
	   <div data-ng-if="!isResponse"> 
		<form  class="form-horizontal" name="downloadSoftwareForm" data-ng-submit="downloadSoftware()" autocomplete="off" >
			<div class="panel panel-default no-border">
				<div class="panel-body">
					<p data-ng-if="serverMessage.message" class="{{serverMessage.type}} serverMessage text-center">{{serverMessage.message}}</p>

					<div class="form-group" data-ng-if="model.showCopySoftware">
						<label class="margin-top-15 col-xs-12 col-sm-4"><cv:msg key="label.downloadSoftwareUsing" bundle="settings"/></label>
						<div class="col-xs-12 col-sm-8">
							<div class="multiple-radio-group">
								<label><input name="internet" data-ng-value="true" class="" id="downloadUsingInternet" type="radio" data-ng-model="model.downloadUsingInternet"/>
								<span class="block-indent"><cv:msg key="label.internet" bundle="settings"/></span></label>
							</div>
							<div class="multiple-radio-group">
								<label><input name="localCopy" data-ng-value="false" class="" id="downloadUsingCopy" type="radio" data-ng-model="model.downloadUsingInternet"/>
								<span class="block-indent"><cv:msg key="label.localCopy" bundle="settings"/></span></label>
							</div>
						</div>
					</div>

					
					<div data-ng-if="model.downloadUsingInternet || !model.showCopySoftware">
						<h4 class="margin-bottom-0 margin-top-20">
							<cv:msg key="label.downloadInstallationMedia" bundle="serversJs" />
							<cv-help-component data-ng-if="!model.clientInfo.isSchedule" data-help-text="<cv:msg key="label.downloadInstallationMediaHelp" bundle="serversJs" />"></cv-help-component>
						</h4>
						
						<div class="form-group">
							<div class="col-xs-12" data-ng-disabled="model.majorSP == model.installedSP && !model.clientInfo.isSchedule">
								<label for="servicePack">
									<input type="radio" data-ng-model="model.downloadOption" 
										data-ng-value="0" id="servicePack" name="servicePackChoice" />
									<span class="block-indent" data-ng-bind="model.latestServicePack">
									</span>		
								</label>
							</div>
						
							<div class="col-xs-12">
								<label for="hotFixes">
								<input type="radio" data-ng-model="model.downloadOption" 
									data-ng-value="1" id="hotFixes" name="servicePackChoice" />
								<span class="block-indent" data-ng-bind="model.latestHotfixes">	
								</span>
								</label>
							</div>
						
							<div ng-if="!hotfixPackDownload">
								<div class="col-xs-6 col-md-6 col-lg-6" data-ng-disabled="((model.majorSP == model.installedSP && !model.clientInfo.isSchedule) || (!model.selectedServicePack))">
									<label for="servicePackAndHotfixes">
									<input type="radio" data-ng-model="model.downloadOption"  
										data-ng-value="2" id="servicePackAndHotfixes" name="servicePackChoice" />
									<span class="block-indent">	
										<cv:msg key="label.latestServicePackAndHotfixes" bundle="serversJs" />
									</span>	
									</label>
								</div>
								<div class="col-xs-6 col-md-6 col-lg-6" data-ng-disabled="model.downloadOption != 2">
									<select id="servicePackValue" name="servicePackValue" data-ng-model="model.selectedServicePack" 
										data-ng-options="sp as sp for sp in model.servicePackList" ></select>
									<span class="help-block" data-ng-show="servicePackAndHotfixErrorMessage && model.downloadOption == 2 && !model.selectedServicePack">
										<cv:msg key="error.selectServicePackAndHotfixes" bundle="serversJs" />
									</span>
								</div>
							</div>

							<div data-ng-if="hotfixPackDownload">
								<div class="col-xs-6 col-md-6 col-lg-6" data-ng-disabled="!model.hotfixPackList.length">
									<label for="servicePackAndHotfixes">
										<input type="radio" data-ng-model="model.downloadOption"  
										data-ng-value="2" id="servicePackAndHotfixes" name="servicePackChoice" />
										<span class="block-indent">	
											<cv:msg key="label.latestServicePackAndHotfixes" bundle="serversJs" />
										</span>	
									</label>
								</div>
								<div class="col-xs-6 col-md-6 col-lg-6" data-ng-disabled="model.downloadOption != 2">
									<isteven-multi-select
										id="hotfixPackSelection"
										directive-id="hotfixPackSelection"
										input-model="model.hotfixPackList"
										output-model="model.selectedHotfixPack"
										button-label="name"
										item-label="name"
										search-property="name"
										group-property="msGroup"
										selection-mode="single"
										tick-property="selected"
										helper-elements="filter"
										translation="localLang"
										prevent-sort="true"
									></isteven-multi-select>
									<span class="help-block" data-ng-show="servicePackAndHotfixErrorMessage && model.downloadOption == 2 && !model.selectedServicePack">
										<cv:msg key="error.selectServicePackAndHotfixes" bundle="serversJs" />
									</span>
								</div>
							</div>
						</div>
						
		 			    <!-- schedule -->
		 			    <div data-ng-if="model.clientInfo.isSchedule"> 
						    <h4 class="margin-bottom-0 margin-top-20"><cv:msg key="label.schedule" bundle="settings"/></h4>
							<div class="form-group">
								<div data-ng-if="model.configuredSchedules.length">
									<div class="col-xs-10">
										<toggle-control id="disableSchedule" class="{{disableScheduleStatus}} toggle-less-width" status="disableScheduleStatus" data-ng-click="toggleTaskFlag()" title="Enable/Disable <cv:msg key="label.schedule" bundle="settings"/>"></toggle-control>
										<label for="disableSchedule"><span data-ng-class="{disabled:model.taskInfo.task.taskFlags.disabled}" class="padding-left-10">{{model.scheduleName}}</span></label>
									</div>
									<div class="col-xs-1" data-ng-if="!model.taskInfo.task.taskFlags.disabled">
										<label for="disableScheduleEdit"><a data-ng-class="{disabled:model.taskInfo.task.taskFlags.disabled}" data-ng-click="editSchedule()" class="padding-left-10"><cv:msg key="label.actionEdit" bundle="messagesJs"/></a></label>
									</div>
								</div> 
								<div class="col-xs-12" data-ng-if="!model.configuredSchedules.length">
										<cv:msg key="error.noScheduleAdded" bundle="schedule"/>
								</div>
								<!-- <ul class="col-xs-12 list-style__row group" data-ng-if="model.configuredSchedules.length != 0">
									<li class="ellipsis-parent ellipsis-content ">
										<toggle-control id="disableSchedule" class="{{disableScheduleStatus}} toggle-less-width" status="disableScheduleStatus" data-ng-click="toggleTaskFlag()" title="Enable/Disable <cv:msg key="label.schedule" bundle="settings"/>"></toggle-control>
										<label for="disableSchedule"><a data-ng-class="{disabled:model.taskInfo.task.taskFlags.disabled}" data-ng-click="editSchedule()" class="padding-left-10">{{model.scheduleName}}</a></label>
									</li>
								</ul>
								<ul class="list-style__row group" data-ng-if="model.configuredSchedules.length==0">
									<li class="ellipsis-parent ellipsis-content "><cv:msg key="error.noScheduleAdded" bundle="schedule"/> </li>
								</ul> -->
						  	</div>
						</div>
						<div class="form-group"></div>			
						<h4 class="text-left margin-bottom-0 margin-top-20"><cv:msg key="label.OperatingSystemsOptions" bundle="serversJs"/></h4>
						<div class="from-group row">
							<div class="col-xs-12 col-sm-4">
								<input id="windowsCheck" type="checkbox" data-ng-click="autoSelectWindowsPackage()" data-ng-model="model.isWindows"/>
								<label for="windowsCheck" class="checkbox-label"><cv:msg key="label.osType.windows" bundle="serversJs" /></label>
							</div>
							<div data-ng-disabled="!model.isWindows" class="col-xs-12 col-sm-8">
								<isteven-multi-select
									id="windowsCheckBoxes"
									directive-id="windowsCheckBoxes"
									input-model="model.windowsDownloadPackages"
									output-model="model.selectedWindowsDownloadPackages"
									button-label="label"
									item-label="label"
									search-property="label"
									selection-mode="multiple"
									tick-property="selected"
								></isteven-multi-select>
							</div>
						</div>
						<div class="from-group row">
							<div class="col-xs-12 col-sm-4">
								<input id="unixCheck" type="checkbox" data-ng-click="autoSelectUnixPackage()" data-ng-model="model.isUnix"/>
								<label for="unixCheck" class="checkbox-label"><cv:msg key="label.unix" bundle="serversJs" /></label>
							</div>
							<div data-ng-disabled="!model.isUnix" class="col-xs-12 col-sm-8">
								<isteven-multi-select
									id="unixCheckBoxes"
									directive-id="unixCheckBoxes"
									input-model="model.unixDownloadPackages"
									output-model="model.selectedUnixDownloadPackages"
									button-label="label"
									item-label="label"
									search-property="label"
									selection-mode="multiple"
									tick-property="selected"
								></isteven-multi-select>
							</div>
						</div>
						<div data-ng-show="model.showCopySoftware && showRemoteCaches">
							<h4 class="text-left margin-bottom-0 margin-top-20"><cv:msg key="label.remoteCaches" bundle="settings"/></h4>
							<cv-advanced-tree cvparams="model.cvParamsInternet" class="advanced-tree"></cv-advanced-tree>
						</div>         
						<div data-ng-if="!model.clientInfo.isSchedule" class="padding-top-30">
							<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
						</div>
					</div>
					<div data-ng-if="!model.downloadUsingInternet && model.showCopySoftware">
						<div class="form-group row">
							<label class="col-xs-12 col-sm-4" for="updateCachePath"><cv:msg key="label.updateCachePath" bundle="settings"/></label>
							<div class="col-xs-12 col-sm-8">
								<div class="input-group">
									<input type="text" name="updateCachePath" id="updateCachePath" data-ng-model="model.updateCachePath" data-ng-change="cachePathChanged()">
									<span class="input-group-btn">
										<button id="dowloadSoftwareBrowseButton" type="button" class="icon-style cv-material-button browse" data-ng-click="browse()">
											<div class="cv-material-button-icon">
												<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
											</div>
											<div class="cv-material-button-tooltip"><cv:msg key="action.browse" bundle="bigData"/></div>
										</button>
									</span>
								</div>
								<span class="help-block" data-ng-if="model.inputAlertFlags.updateCachePath"><cv:msg key="error.invalidPath" bundle="clients" /></span>
							</div>
						</div>
						<cv-toggle-accordion accordion-label="label.impersonateUser" collapsed="model.impersonateUser">
							<cv-credential-directive 
								credentials="model.credentials"
								form-name="downloadSoftwareForm"
								password-complexity="1"
								need-confirm="true"
								is-optional="!model.impersonateUser"
								is-edit="false"
								row-class="true">
							</cv-credential-directive>
						</cv-toggle-accordion>
						<div data-ng-if="!model.clientInfo.isSchedule" class="multiple-checkbox-group padding-top-30">
							<input id="copy-software-notify" type="checkbox" ng-model="model.notifyUserOnJobCompletion" />
							<label class="margin-left-0 overwriteLabel" for="copy-software-notify">
								<cv-help-text help-label="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"
									help-text="label.enableAlertHelpText" />
							</label>
						</div>
						<div data-ng-if="model.clientInfo.isSchedule"> 
							<h4 class="margin-bottom-0 margin-top-20"><cv:msg key="label.schedule" bundle="settings"/></h4>
							<div class="form-group">
								<div class="col-xs-10">
									<toggle-control data-ng-if="model.copySchedule.name" id="disableCopySchedule" status="model.copySchedule.enabled?'enabled-activity':'disabled-activity'" data-ng-class="{'enabled-activity': model.copySchedule.enabled, 'disabled-activity': !model.copySchedule.enabled}" class="toggle-less-width" data-ng-click="copyScheduleToggle()" title="Enable/Disable <cv:msg key="label.schedule" bundle="settings"/>"></toggle-control>
									<label data-ng-if="model.copySchedule.name" for="disableCopySchedule"><span data-ng-class="{disabled: !model.copySchedule.enabled}" class="padding-left-10">{{model.copySchedule.name}}</span></label>
									<label data-ng-if="!model.copySchedule.name" for="disableCopySchedule"><span data-ng-class="{disabled: !model.copySchedule.enabled}"><cv:msg key="error.noScheduleAdded" bundle="schedule"/>. <a href="" data-ng-click="copyScheduleToggle()"><cv:msg key="label.clickToAdd" bundle="settings"/></a></span></label>
									<span class="help-block" data-ng-if="model.inputAlertFlags.copySchedule"><cv:msg key="error.addSchedule" bundle="settings" /></span>
								</div>
								<div class="col-xs-1" data-ng-if="model.copySchedule.enabled && model.copySchedule.name">
									<label for="editCopySchedule"><a data-ng-class="{disabled:!model.copySchedule.enabled}" data-ng-click="editCopySchedule()" class="padding-left-10"><cv:msg key="label.actionEdit" bundle="messagesJs"/></a></label>
								</div>
							</div>
						</div>	
						<div data-ng-show="showRemoteCaches">
							<h4 class="text-left margin-top-20 margin-bottom-0"><cv:msg key="label.remoteCaches" bundle="settings"/></h4>
							<cv-advanced-tree cvparams="model.cvParams" class="advanced-tree"></cv-advanced-tree>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button id="downloadSoftwareDialog_button_#8043" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"> 
					<cv:msg key="Cancel" />
				</button>
				<button id="downloadSoftwareDialog_button_#2037" type="submit" class="btn btn-primary cvBusyOnAjax"> 
					<span data-ng-if="!model.clientInfo.isSchedule"><cv:msg key="label.download" bundle="servers" /></span>
					<span data-ng-if="model.clientInfo.isSchedule"><cv:msg key="action.save" bundle="profiles" /></span> 
				</button>
			</div>
		</form>
	</div>
	  <div data-ng-if="isResponse">
		    <p>&nbsp;</p>
			<p class="text-center" data-ng-bind-html="responseContent"></p>
			 <div class="modal-footer">
				 <button id="downloadSoftwareDialog_button_#4307" type="submit" class="btn btn-primary" data-ng-disabled="" data-ng-click="close()"><cv:msg key="OK" /></button> 
	         </div>
	  </div>
    </div>
  </div>
