<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%> 
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.servers">
	<h1 class="page-title">
		<fmt:message key="pageHeader.servers" />
	</h1>
	
	<div ng-controller="fsClientListController">
	<!-- FS clients -->
	<ul class="servers-list group list-style__header">
		<li><fmt:message key="header.name" /></li>
		<li><fmt:message key="header.type" /></li>
		<%-- <li><fmt:message key="header.backupsEnabled" /></li>
		<li><fmt:message key="header.restoresEnabled" /></li> --%>
		<li>&nbsp;</li>
	</ul>
	<ul class="servers-list list-style__row group" data-ng-repeat="server in clients">
		<li>
			<a href="fsa.jsp#servers/{{server.clientId}}/fs/{{server.fsProperties.entity.applicationId}}">{{server.name}}</a>
		</li>
		<li>
			{{ (server.fsProperties.type | i18n) }}
		</li>
		<li>
			<a href="#jobs?serverId={{server.clientId}}&serverName={{server.name}}"><fmt:message key="action.jobs" /></a>
		</li>
	</ul>
		<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
	</div>
	<div ng-controller="serverListController">
	<!-- VSA servers -->
	<a class="page-action-item" href="" data-ng-click="showAddServerDialog()"><fmt:message key="pageHeader.addServer" /></a>
	<ul class="servers-list group list-style__header">
		<li><fmt:message key="header.name" /></li>
		<li><fmt:message key="header.type" /></li>
		<%-- <li><fmt:message key="header.backupsEnabled" /></li>
		<li><fmt:message key="header.restoresEnabled" /></li> --%>
		<li>&nbsp;</li>
	</ul>
	<ul class="servers-list list-style__row group" data-ng-repeat="server in servers">
		<li>
			<a href="index.jsp#servers/{{server.clientId}}">{{server.name}}</a>
		</li>
		<li>
			{{ (server.type == 'VMW') ? ('vendor.vmware' | i18n) : (server.type=='MICROSOFT' ? ('vendor.ms' | i18n) : '?') }}
		</li>
		<!-- <li>
			{{ ('enabled.'+server.backupsEnabled) | i18n }}
		</li>
		<li>
			{{ ('enabled.'+server.restoresEnabled) | i18n }}
		</li> -->
		<li>
			<a href="#jobs?serverId={{server.clientId}}&serverName={{server.name}}"><fmt:message key="action.jobs" /></a>
		</li>
	</ul>
		<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
	</div>
</fmt:bundle>