<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.storages" bundle="profiles"/></h1>
</div>
<div class="setup-content addServerModal">
	<div class="{{editStoragePoolMessage.type}} serverMessage">{{editStoragePoolMessage.message}}</div>
	<form name="editStoragePoolForm" data-cv-submit="saveStoragePool()" novalidate autocomplete="off">
		<div class="global-options remove-border-padding">
			<label for="primaryStorage" class="select-label"><span class="long-label-span"><cv:msg key="label.primaryStorage" bundle="profiles" /></span>
				<select id="primaryStorage" name="primaryStorage" data-ng-model="sp1.storagePoolId"
						data-ng-options="storagePool.storagePoolEntity.storagePoolId as storagePool.storagePoolEntity.storagePoolName for storagePool in storagePools | orderBy : 'storagePoolEntity.storagePoolName'" required
						data-ng-class="{'has-error': cv.editStoragePoolForm.needsAttention(editStoragePoolForm.primaryStorage)}"
						data-ng-change="changeSecondaryStorageList(sp1.storagePoolId)" disabled>
					<option value=""><cv:msg key="placeholder.selectStorage" bundle="profiles"/></option>
				</select>
			</label>
		</div>
		<div class="global-options remove-border-padding" data-ng-if="planSubType != 'Snap'">
			<label data-ng-if="planSubType == 'Laptop'" for="retention" class="storage-retention-label longer-title"><cv:msg key="label.retentionPeriod" bundle="collections"/> </label>
			<label data-ng-if="planSubType != 'Laptop'" for="retention" class="storage-retention-label longer-title"><cv:msg key="label.retentionDays" bundle="collections"/> </label>
			<input id="retention" name="retention" min="0" type="number" data-ng-model="sp1.retentionInDays" class="storage-retention-input less-margin" /><span><cv:msg key="label.days" bundle="collectionsJs"/></span>
		</div>
		<div data-ng-if="planSubType == 'Snap'"  class="global-options remove-border-padding" >
			<label for="snapRecoveryPoints" class="storage-retention-label longer-title"><cv:msg key="label.snapRecoveryPoints" bundle="profiles"/> </label>
			<input id="snapRecoveryPoints" min="0" name="snapRecoveryPoints" type="number" data-ng-model="model.snapRecoveryPoints" class="storage-retention-input snap-less-margin" />
		</div>
		<div data-ng-if="planSubType == 'Snap'" class="global-options remove-border-padding" style="margin-top: 20px">
			<label for="backupCopyRetention" class="storage-retention-label longer-title"><cv:msg key="label.backupCopyRetention" bundle="profiles"/> </label>
			<input id="backupCopyRetention" min="0" name="backupCopyRetention" type="number" data-ng-model="sp1.retentionInDays" class="storage-retention-input less-margin" /><span><cv:msg key="label.days" bundle="collectionsJs"/></span>
		</div>
		<div data-ng-if="sp2" class="global-options remove-border-padding" style="margin-top: 15px">
			<label for="secondaryStorage" class="select-label"><cv:msg key="label.secondaryStorage" bundle="profiles"/>
				<select id="secondaryStorage" name="secondaryStorage" data-ng-model="sp2.storagePoolId"
						data-ng-options="storagePool.storagePoolEntity.storagePoolId as storagePool.storagePoolEntity.storagePoolName for storagePool in secondaryStoragePools | orderBy : 'storagePoolEntity.storagePoolName'" required
						data-ng-class="{'has-error': cv.editStoragePoolForm.needsAttention(editStoragePoolForm.secondaryStorage)}" disabled>
					<option value=""><cv:msg key="placeholder.selectSecondaryStorage" bundle="profiles"/></option>
				</select>
			</label>
			<label data-ng-if="planSubType == 'Laptop'" for="retention" class="storage-retention-label longer-title"><cv:msg key="label.retentionPeriod" bundle="collections"/> </label>
			<label data-ng-if="planSubType != 'Laptop'" for="retention" class="storage-retention-label longer-title"><cv:msg key="label.retentionDays" bundle="collections"/> </label>
				<input id="secondaryRetentionDays" name="secondaryRetentionDays" type="number" data-ng-model="sp2.retentionInDays" class="storage-retention-input less-margin" /><span><cv:msg key="label.days" bundle="collectionsJs"/></span>
				<span class="help-block" data-ng-show="cv.editStoragePoolForm.needsAttention(editStoragePoolForm.secondaryRetentionDays)"><cv:msg key="error.retentionPeriod" bundle="collections"/></span>
		</div>
		<div class="button-container">
			<button id="editStoragePool_button_#0122" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="editStoragePool_button_#9600" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>
