<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.editPlan" bundle="profiles"/></h1>
</div>
<div class="setup-content">
	<div data-ng-class="editPlanServerMessage.type" class="serverMessage" data-ng-bind="editPlanServerMessage.message"></div>
	<form id="editPlanForm" name="editPlanForm" data-cv-submit="savePlanForBackupset()" novalidate autocomplete="off">
		<div class="cv-modal-wrapper" data-ng-show="planList && planList.length">
			<label class="cv-label"><cv:msg key="label.profile" bundle="profiles" /></label>
			<div class="cv-inline-wrapper">
				<div class="padding-right-20">
					<cv-plan-summary-dropdown
						input-model="planList"
						output-model="selectedPlanList"
						item-label="'planName'"
						button-label="'planName'"
						tick-property="'selected'"
						max-labels="1"
						group-property="'msGroup'"
						selection-mode="'single'"
						directive-id="'plans'"
						show-none="showNone"
						search-property="'planName'"
       					helper-elements="'filter'"
						on-close="parseIStevenOutput()">
					</cv-plan-summary-dropdown>
				</div>
			</div>
		</div>
		<cv-archiving-rules cv-disk-cleanup-rules="diskCleanupRules" cv-output-model="archivingInfo.savedDiskCleanupRules" cv-enable-toggle-override-archiving-rules="'true'" cv-enable-preview-mode="'true'" ng-if="diskCleanupRules"></cv-archiving-rules>
       <div ng-if="showPlanContentOverrideOptions" class="margin-top-20">
		   <div class="form-group row margin-left-5 margin-bottom-0">
			   <div class="col-xs-12">
				   <div ng-if="planPreviewEntity.planId">
					   <label ng-if="planPreviewEntity.isPlanHaveBackupContent"  class="margin-0" ng-bind="'label.backupContentPlan'| cvLoc"></label>
					   <plan-content-preview plan-preview-entity="planPreviewEntity" custom-class="margin-left-0">
					   </plan-content-preview>
					   <label ng-if="planPreviewEntity.isPlanHaveBackupContent" class="text-left margin-0">
						   <cv-toggle value="model.overrideBackupContent" toggle-label="label.defineContent" help-text="'label.overrideBackupContent.helpText'" help-direction="top">
						   </cv-toggle>
       				   </label>
       			    </div>
       			</div>
       		</div>

       		<div data-ng-show="model.overrideBackupContent || !planPreviewEntity.isPlanHaveBackupContent" class="row modal-list bootstrap-wrapper">
       			<cv-content-selection ng-if="contentOptions && contentEntities" class="form-group" data-options="contentOptions" data-content-entities="contentEntities">
       			</cv-content-selection>
       		</div>
	   </div>
	   <div ng-if="showTrackAccessTime">
			<div class="form-group margin-bottom-10">
				<label class="col-lg-4"><cv-help-text help-label="prompt.trackAccessTime" help-text="trackAccessTimeInfo" /></label>
				<div class="col-lg-3 padding-left-0">
					<input id="rebootLater" type="radio" ng-model="trackAccessTimeMode" value="rebootLater" >
					<label for="rebootLater" class="inline-block margin-left-0 margin-right-0" style="clear:both"><cv:msg key="prompt.rebootLater" bundle="profiles" /></label>
				</div>
				<div class="col-lg-4">
					<input id="rebootNow" type="radio" ng-model="trackAccessTimeMode" value="rebootNow">
					<label for="rebootNow" class="inline-block margin-left-0 margin-right-0" style="clear:both"><cv:msg key="prompt.rebootNow" bundle="profiles" /></label>
				</div>
			</div>
	   </div>
		<div class="button-container">
			<button id="editPlanBackupset_button_#7901" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button ng-if="!showPlanContentOverrideOptions" id="editPlanBackupset_button_#2850" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!selectedPlanList.length || planId==selectedPlan"><cv:msg key="action.save" bundle="profiles"/></button> 
			<button ng-if="showPlanContentOverrideOptions" id="editPlanBackupset_button_#285056" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!isLoaded"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>