<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.deleteView" bundle="messagesJs" /></h1>
	</div>
	<div class="setup-content">
		<form name="deleteViewform" novalidate data-cv-submit="deleteView()" autocomplete="off" class="generate-package-form">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<label for="deleteViewName" class="select-label" data-ng-if="model.views.length">
				<cv:msg key="label.viewName" bundle="messagesJs" />
				<select name="deleteViewName" id="deleteViewName" data-ng-model="model.selectedViewId" required 
						data-ng-options="viewObj.id as viewObj.name for viewObj in model.views" 
						data-ng-class="{'has-error': cv.deleteViewform.needsAttention(deleteViewform.deleteViewName)}">
				</select>
				<span class="help-block" data-ng-show="cv.deleteViewform.needsAttention(deleteViewform.deleteViewName)"><cv:msg key="error.name" bundle="messagesJs" /></span>
			</label>
			<p data-ng-if="!model.views.length">No views eligible for deletion.</p>
			<div class="button-container">
				<button id="deleteView_button_#5431" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel"/></button> 
				<button id="deleteView_button_#3361" type="submit" data-ng-disabled="!model.selectedViewId" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Delete" /></button> 
			</div>
		</form>
	</div>
</div>