<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div data-ng-if="cvGridOptions" class="clearfix page-details-list" data-ng-class="{ 'page-details-list' : !cvGridOptions.cvIsPageTitle }">
	<div class="row cv-grid-header" data-ng-if="!cvGridOptions.cvHideHeader">
		<div class="col-md-12 min-height-40 no-wrap">
			<span data-ng-if="cvGridOptions.cvIsSearchable && showGrid" class="search-widget-wrapper search-filter">
				<input type="search" class="search-field" placeholder="{{cvGridOptions.cvSearchPlaceholder}}" title="<cv:msg key='label.search' bundle='navJs' />" id="search-field" data-ng-model="model.searchText" data-ng-change="cvGridOptions.searchTextChange()" />
				<span data-ng-click="model.searchText='';cvGridOptions.searchTextChange();"
						class="form-control-clear glyphicon glyphicon-remove form-control-feedback"
						title="<cv:msg key='label.clear' bundle='navJs' />"></span>
			</span>

			<span ng-if="cvGridOptions.cvIsAdvSearch">
				<cv-search-box query="cvGridOptions.cvAdvSearchOptions.query" on-search="cvGridOptions.cvAdvSearchOptions.onSearch(query, fields)" custom-class="cvGridOptions.cvAdvSearchOptions.customClass" field-defs="cvGridOptions.cvAdvSearchOptions.fieldDefs"></cv-search-box>
			</span>

			<div class="inline-block float-right">
			<span data-ng-repeat="dropdown in cvGridOptions.cvDropdowns">
				<label class="page-action-item cv-page-dropdown">{{dropdown.label}}
					<span class="uib-dropdown page-action-item-right-margin" data-uib-dropdown>
						<a href="" class="uib-dropdown-toggle" data-uib-dropdown-toggle> {{dropdown.model}}
							<span class="dropdownArrow"></span>
						</a>
						<ul uib-dropdown-menu class="dropdown-menu">
							<li ng-repeat="option in dropdown.options">
								<a href="" class="crop" ng-click="dropdown.model = option.name;dropdown.changeHandler(option.value);" title="{{option.name}}">{{option.name}}</a>
							</li>
						</ul>
					</span>
				</label>
			</span>
			</div>

			<span data-cv-page-links class="ui-grid-page-action-item-wrapper">
				<span data-cv-page-link data-ng-repeat="item in cvGridOptions.cvPageLinks track by $index" class="page-action-item" data-ng-class="[item.customClass, { 'spacing-right' : item, 'action-left': item.type === 'button' }]" data-ng-disabled="item.disableItem"  data-ng-show="item.showItem">
					<span data-ng-if="!item.subLinks">
						<a data-ng-attr-id="{{item.id}}" data-ng-attr-href="{{item.href}}" data-ng-click="!item.disableItem && item.onclick()" data-ng-class="{'btn btn-primary': item.type === 'button', 'disabled-page-action-item': item.disableItem}" data-ng-disabled="item.disableItem">{{item.label}}</a>
					</span>
					<span data-ng-if="item.subLinks && item.subLinks.length > 0">
						<span data-uib-dropdown class="uib-dropdown">
							<a href class="uib-dropdown-toggle" data-uib-dropdown-toggle>
								<span class="right" ng-if="item.icon" ng-class="[item.icon]"></span>
								<span class="right" ng-if="item.svg" data-ng-bind-html="item.svg"></span>
				      			<span ng-if="!item.icon && !item.svg" class="dropdownArrow right margin-left-5"></span><span data-ng-bind="item.label"></span>
				      		</a>
				      		<ul data-uib-dropdown-menu class="dropdown-menu {{item.class}}">
				      			<li data-ng-repeat="subLinks in item.subLinks track by $index" data-ng-show="subLinks.showItem" data-ng-disabled="subLinks.disableItem">
									<a data-ng-attr-id="{{item.id}}" data-ng-attr-href="{{subLinks.href}}" data-ng-click="!subLinks.disableItem && subLinks.onclick()" data-ng-disabled="subLinks.disableItem">
									<span data-ng-bind-html="subLinks.label"></span>
									</a>
								</li>
				      		</ul>
						</span>
					</span>
				</span>
			</span>

			<span data-ng-if="cvGridOptions.cvShowSelectedOption && showGrid" class="show-selection-wrapper">
				<input type="checkbox" name="showSelected" id="showSelected" data-ng-model="model.isDisplaySelection" data-ng-change="toggleShowSelectedRows()"/>
				<label class="checkbox-label" for="showSelected"><cv:msg key="label.showSelected" /></label>
			</span>
			<div class="cv-grid-title-search-wrapper">
				<h1 class="margin-top-10" data-ng-if="cvGridOptions.cvHasTitle" data-ng-class="{ 'page-title' : cvGridOptions.cvIsPageTitle, 'name' : !cvGridOptions.cvIsPageTitle }">{{cvGridOptions.cvGridTitle}}</h1>
				<span data-ng-if="cvGridOptions.cvInfoText && cvGridOptions.cvInfoText !== undefined" data-uib-tooltip="{{cvGridOptions.cvInfoText}}" data-tooltip-placement="right" class="glyphicon glyphicon-info-sign tile-tooltip">
				</span>
				<!-- viewNames length will always be 1. (Default) -->
				<span data-ng-if="cvGridOptions.cvHasViews && model.selectedViewId && model.totalViews > 1 && getView(model.selectedViewId).name" uib-dropdown class="uib-dropdown view-selection">
					<a href class="uib-dropdown-toggle" data-uib-dropdown-toggle>
						<span class="dropdownArrow right"></span><span>{{getView(model.selectedViewId).name | decodeURIComponent}}</span>
					</a>
					<ul data-uib-dropdown-menu class="dropdown-menu-right">
						<li data-ng-repeat="view in model.views" data-ng-if="!view.hidden">
							<a href data-ng-class="{ 'selected-view' : view.id === model.selectedViewId }" data-ng-click="view.id === model.selectedViewId || applyView(view.id)">
								<span data-ng-class="{ 'user-views' : view.canBeDeleted }">{{view.name | decodeURIComponent}}</span>
							</a>
						</li>
						<li><!-- to simulate a seperator --></li>
						<li>
							<a data-ng-click="openReorderModal($event)">
								<span class="glyphicon glyphicon-cog view-menu-settings-icon"></span>
								<cv:msg key="action.reorder" bundle="servers" />
							</a>
						</li>
					</ul>
				</span>
			        <span  data-ng-show="cvGridOptions.cvHasViews && model.selectedViewId && model.totalViews > 1 && getView(model.selectedViewId).advancedFilters && getView(model.selectedViewId).advancedFilters.showAnomalous" data-uib-tooltip='<cv:msg key="info.anomalousJobs" bundle="messagesJs" />' tooltip-class="showTooltip" class=" anomalous-jobs-tooltip glyphicon glyphicon-info-sign tile-tooltip " ></span>
				<span data-ng-if="cvGridOptions.cvShowSelectedCount && showGrid" data-ng-show="itemsSelected > 0" class="selected-items-count-text">
					{{itemsSelected}} <cv:msg key="label.showItemsSelectedCount" />
				</span>
				<span data-ng-show="isDataLoading || isDefaultViewLoading || (!isDataUnavailable && !columnsFitted)" class="grid-data-spinner">
					<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
				</span>
			</div>
		</div>
	</div>
	<div class="cv-server-filter-type"></div>
	<span data-ng-hide="isDataLoading" class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
	<div data-ng-if="cvGridOptions.cvCompanyDropdown">
		<cv-company-dropdown></cv-company-dropdown>
	</div>
	<div data-cv-breadcrumb data-ng-model="cvGridOptions.cvBreadcrumbs.model" item-template="cvGridOptions.cvBreadcrumbs.itemTemplate" ng-if="cvGridOptions.cvBreadcrumbs"></div>
	<div data-ng-class="{'enable-column-filter-empty-message' : cvGridOptions.cvHasColumnFilter && isDataUnavailable, 'show-column-filter' : cvGridOptions.cvHasColumnFilter, 'grid-hidden' : !columnsFitted}">
		<div data-ng-show="!isDefaultViewLoading && (showGrid || showGridEmptyMessage)" data-ui-grid="cvGridOptions.gridOptions" class="grid-style cv-grid-style bottom-grid-fix"
				data-ng-class="cvGridOptions.cvGridCssClass"
				data-ui-grid-save-state data-cv-ui-grid-resize data-ui-grid-auto-resize data-ui-grid-resize-columns data-ui-grid-selection data-ui-grid-tree-view
				data-ng-attr-cv-page-height="{{cvGridOptions.cvGridDirectives.cvPageHeight ? '' : undefined}}"
				data-ng-attr-ui-grid-pagination="{{cvGridOptions.cvGridDirectives.uiGridPagination ? '' : undefined}}">
			<p data-ng-if="isDataUnavailable" class="grid-no-data-message" data-ng-class="{'enable-column-filter-empty-message' : cvGridOptions.cvHasColumnFilter}">
				<span data-ng-show="!showGrid && showGridEmptyMessage">{{cvGridOptions.cvOnGridEmpty.message}}</span>
				<span data-ng-show="showGrid"><cv:msg key="label.noResultsFound" bundle="messagesJs" /></span>
			</p>
		</div>
	</div>
	<div data-ng-show="showGrid === false && !isDataLoading && cvGridOptions.cvOnGridEmpty.message && !showGridEmptyMessage">
		<div class="horz-center">
			<span data-svg-placeholder></span>
			<div>
				<h3 class="no-margin">{{cvGridOptions.cvOnGridEmpty.message}}</h4>
			</div>
			<div data-ng-if="cvGridOptions.cvOnGridEmpty.links && cvGridOptions.cvOnGridEmpty.links.length > 0">
				<ul class="list-inline">
					<li data-ng-repeat="link in cvGridOptions.cvOnGridEmpty.links track by $index">
						<span data-ng-if="link.template" data-ng-bind-html="link.template"></span>
						<a data-ng-if="!link.template" data-ng-attr-id="{{link.id}}" data-ng-attr-href="{{link.href}}" data-ng-click="link.onclick()"><span>{{link.label}}</span></a>
					</li>
				</ul>
			</div>
		</div>
	</div>
</div>