<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.jsonPayload" bundle="messages" />
	</h1>
</div>
<div class="bootstrap-wrapper">
	<form name="jsonPayloadForm" class="form-horizontal" novalidate>
		<div class="panel-body">
			<div data-ng-if="jsonScript" class="margin-10">
				<div class="margin-bottom-5">{{jsonScript.method}} {{jsonScript.api}}</div>
				<div class="position-relative">
					<span class="position-absolute icon-wrapper" data-ng-if="jsonScript && jsonScript.payload">
						<a cv-copy-to-clipboard data-copy-container-css-selector=".copy-clipboard-content" class="margin-right-10"
							data-help-text='<cv:msg key="label.copytoClipboard" bundle="activeDirectory" />'></a>
						<a cv-download-as-file data-download-content="{{downloadScript}}" 
							data-help-text='<cv:msg key="label.globalSearch.download" bundle="messages" />' data-download-filename="Response_payload.json"></a>
					</span>
					<pre data-ng-if="jsonScript.payload" class="pre-scrollable copy-clipboard-content">{{jsonScript.payload}}</pre>
					<pre data-ng-if="!jsonScript || !jsonScript.payload"><cv:msg key="label.noPayload" bundle="messages" /></pre>
				</div>
			</div>
			<div class="modal-footer">
				<div class="float-left">
					<a target="_blank" href="{{docLink}}" title='<cv:msg key="label.help" bundle="messages" />'>
						<span class="k-icon k-i-help font-size-26 color-link"></span>
					</a>
				</div>
				<button type="button" 
					class="btn btn-default setup-btn--hidden"
					data-ng-click="close()">
					<cv:msg key="label.close" bundle="messagesJs" />
				</button>
			</div>
		</div>
	</form>
</div>