<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.search"></cv:cvMessages>
</script>
<span uib-dropdown auto-close="outsideClick" class="cv-add-tag">
    <a href uib-dropdown-toggle>
        <span class="vertical-align-text-bottom" ng-bind="'label.addTag' | cvLoc"></span>
        <span class="caret vertical-align-super"></span>
    </a>
    <ul class="dropdown-menu cv-dropdown-style-2 margin-0 padding-0" uib-dropdown-menu role="menu">
        <!-- //Search for tags// -->
        <li ng-if="ctrl.tags.length > 5" class="text-center">
            <span class="cv-tag-search-container margin-top-5 padding-left-5">
                <span class="glyphicon glyphicon-search"></span>
                <input type="text" class="cv-tag-search margin-0 padding-0" autofocus autocomplete="false" ng-model="ctrl.search" placeholder='<cv:msg key="label.search" bundle="search" />' />
            </span>
        </li>
        <!-- //Top 5 tags // -->
        <li ng-repeat="tag in ctrl.tags | filter: {'name': ctrl.search} | limitTo: 5" ng-if="ctrl.tags" role="menuitem"><a ng-bind="tag.name" title="{{tag.description}}" ng-click="ctrl.applyTag(tag)"></a></li>
        <!-- //Create new tag -->
        <li class="divider margin-0 padding-0" ng-if="ctrl.tags"></li>
        <li role="menuitem" class="cv-create-new-tag"><a ng-click="ctrl.createNewTag()" ng-bind="'label.createNew' | cvLoc"></a></li>
    </ul>
</span>