<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<script data-grid-empty-svg type="text/html"></script>
<script id="grid-empty-template" type="text/x-kendo-template">
    <div class="cv-k-grid-empty-content page-details-list">
        <div>
            <div class="horz-center">
                # if (gridEmptySvg) { #
                    <span>#= gridEmptySvg #</span>
                # } #
                <div>
                    # if (useClassicToolbar) { #
                        <h3 class="no-margin">#= gridEmptyMessage #</h3>
                    # } else { #
                        <h3>#= gridEmptyMessage #</h3>
                    # } #
                </div>
                <div id="grid-empty-menu-container" class="toolbar-menu-container">
                    <ul id="grid-empty-menu"></ul>
                </div>
            </div>
        </div>
    </div>
</script>
<script id="toolbar-template" type="text/x-kendo-template">
# if (useClassicToolbar) { #
    <div class="cv-k-grid-toolbar cv-k-grid-toolbar-classic">
        <div class="cv-k-grid-header">
            <div class="cv-k-grid-title">
                <h2 id="grid-title-text" class="hidden"></h2>
                <span class="uib-dropdown view-selection dropdown cv-k-header-dropdown">
                    <span class="cv-k-header-dropdown-label"><cv:msg key="label.view" bundle="messagesJs" /></span>
                    <a href class="uib-dropdown-toggle dropdown-toggle">
                        <span class="dropdownArrow right"></span>
                        <span class="cv-k-view-dropdown-label"></span>
                    </a>
                </span>
				<div class="left-toolbar">
           	 		#= html #
        		</div>
            </div>
        </div>

        <div class="toolbar">
            <div id="batch-action-menu-container" class="toolbar-menu-container batch-action-menu-container invisible-on-grid-empty">
                <ul id="batch-action-menu"></ul>
            </div>
            <div id="search-input-container" class="toolbar-menu-container toolbar-search-container hidden-on-grid-empty">
                <input type="search" id="searchInput" class="cv-k-grid-search-input" placeholder='<cv:msg key="label.search" bundle="messages" />'/>
                <span class="k-icon k-i-zoom k-i-search"></span>
                <span class="k-icon k-i-close k-i-x" title='<cv:msg key="label.clear" bundle="messages" />'></span>
            </div>
            <div id="toolbar-menu-container" class="toolbar-menu-container">
                <ul id="toolbar-menu"></ul>
            </div>
            <div id="grid-context-menu-container" class="menuContainer">
                <div class="refreshBtnContainer">
                    <a class="k-pager-refresh k-link">
                        <span class="k-icon k-i-gear">
                            <ul id="gridContextMenu">
                                <li id="clearFilter"><cv:msg key="gridMenu.clearAllFilters" bundle="messagesJs" /></li>
                                <li id="editView"><cv:msg key="label.editView" bundle="messagesJs" /></li>
                                <li id="createView"><cv:msg key="label.createView" bundle="messagesJs" /></li>
                                <li id="deleteView"><cv:msg key="label.deleteView" bundle="messagesJs" /></li>
                            </ul>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    </div>
# } else if (usePageToolbar) { #
    <div class="cv-k-grid-toolbar cv-k-grid-toolbar-classic">
        <div class="cv-k-grid-header">
            <div class="cv-k-grid-title">
                <h2 id="grid-title-text" class="hidden"></h2>
                <span class="uib-dropdown view-selection dropdown cv-k-header-dropdown">
                    <span class="cv-k-header-dropdown-label"><cv:msg key="label.view" bundle="messagesJs" /></span>
                    <a href class="uib-dropdown-toggle dropdown-toggle">
                        <span class="dropdownArrow right"></span>
                        <span class="cv-k-view-dropdown-label"></span>
                    </a>
                </span>
				<div class="left-toolbar">
            		#= html #
        		</div>
            </div>
        </div>

        <div class="toolbar">
            <div id="toolbar-menu-container" class="toolbar-menu-container">
                <ul id="toolbar-menu"></ul>
            </div>
        </div>
    </div>
    <div class="cv-k-grid-toolbar cv-k-grid-toolbar-primary">
        <div class="toolbar">
            <div id="batch-action-menu-container" class="toolbar-menu-container batch-action-menu-container invisible-on-grid-empty">
                <ul id="batch-action-menu"></ul>
            </div>
            <div id="search-input-container" class="toolbar-menu-container toolbar-search-container hidden-on-grid-empty">
                <label>
                    <input type="search" id="searchInput" class="cv-k-grid-search-input" placeholder='<cv:msg key="label.search" bundle="messages" />'/>
                    <span class="k-icon k-i-zoom k-i-search"></span>
                    <span class="k-icon k-i-close k-i-x" title='<cv:msg key="label.clear" bundle="messages" />'></span>
                </label>
            </div>
            <div id="toolbar-menu-container" class="toolbar-menu-container">
                <ul id="toolbar-menu"></ul>
            </div>
            <div id="grid-context-menu-container" class="menuContainer">
                <div class="refreshBtnContainer">
                    <a class="k-pager-refresh k-link">
                        <span class="k-icon k-i-gear">
                            <ul id="gridContextMenu">
                                <li id="clearFilter"><cv:msg key="gridMenu.clearAllFilters" bundle="messagesJs" /></li>
                                <li id="editView"><cv:msg key="label.editView" bundle="messagesJs" /></li>
                                <li id="createView"><cv:msg key="label.createView" bundle="messagesJs" /></li>
                                <li id="deleteView"><cv:msg key="label.deleteView" bundle="messagesJs" /></li>
                            </ul>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    </div>
# } else { #
    <div class="cv-k-grid-toolbar cv-k-grid-toolbar-primary">
        <div class="cv-k-grid-header">
            <div class="cv-k-grid-title">
                <h2 id="grid-title-text" class="hidden"></h2>
                <span class="uib-dropdown view-selection dropdown cv-k-header-dropdown">
                    <span class="cv-k-header-dropdown-label"><cv:msg key="label.view" bundle="messagesJs" /></span>
                    <a href class="uib-dropdown-toggle dropdown-toggle">
                        <span class="dropdownArrow right"></span>
                        <span class="cv-k-view-dropdown-label"></span>
                    </a>
                </span>
				<div class="left-toolbar">
            		#= html #
        		</div>
            </div>
        </div>

        <div class="toolbar">
            <div id="batch-action-menu-container" class="toolbar-menu-container batch-action-menu-container invisible-on-grid-empty">
                <ul id="batch-action-menu"></ul>
            </div>
            <div id="search-input-container" class="toolbar-menu-container toolbar-search-container hidden-on-grid-empty">
                <label>
                    <input type="search" id="searchInput" class="cv-k-grid-search-input" placeholder='<cv:msg key="label.search" bundle="messages" />'/>
                    <span class="k-icon k-i-zoom k-i-search"></span>
                    <span class="k-icon k-i-close k-i-x" title='<cv:msg key="label.clear" bundle="messages" />'></span>
                </label>
            </div>
            <div id="toolbar-menu-container" class="toolbar-menu-container">
                <ul id="toolbar-menu"></ul>
            </div>
            <div id="grid-context-menu-container" class="menuContainer">
                <div class="refreshBtnContainer">
                    <a class="k-pager-refresh k-link">
                        <span class="k-icon k-i-gear">
                            <ul id="gridContextMenu">
                                <li id="clearFilter"><cv:msg key="gridMenu.clearAllFilters" bundle="messagesJs" /></li>
                                <li id="editView"><cv:msg key="label.editView" bundle="messagesJs" /></li>
                                <li id="createView"><cv:msg key="label.createView" bundle="messagesJs" /></li>
                                <li id="deleteView"><cv:msg key="label.deleteView" bundle="messagesJs" /></li>
                            </ul>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    </div>
# } #
</script>
<%--
    If the grid has loaded with no data, then the grid is hidden and the svg and gridEmptyMessage are
    displayed. Otherwise, display the grid. When the rows are removed or filtered, the grid will stay
    visible but will display "No results found"
--%>
<div cv-kendo-grid-container="" class="cv-kendo-grid grid-style"></div>