<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.settings"></cv:cvMessages>
    <cv:cvMessages bundle="localization.setup"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="cv-credential-directive">
    <div class="form-group" data-ng-class="{row: rowClass}">
        <label data-ng-class="{'{{labelClass}}': labelClass, 'col-xs-12 col-sm-4 ': !labelClass}" for="uname">
        	<span ng-if="userNameInfo && userNameInfo.label">{{userNameInfo.label}}</span> <!-- customized label-->
        	<span ng-if="!(userNameInfo && userNameInfo.label)"><cv:msg key="label.userName"  bundle="settings"/></span> <!-- default -->
        </label>
        <div data-ng-class="{'{{inputClass}}' : inputClass, 'col-xs-12 col-sm-8' : !inputClass}">
            <input type="text" name="{{inputName[0]}}" id="uname" class="full-width" data-ng-model="credentials[inputName[0]]" data-ng-required="!isOptional" data-ng-pattern="emailPattern" />
			<!-- required error -->
            <span class="help-block text-left" data-ng-if="(formName.$submitted || (formName[inputName[0]].$dirty && !validateOnBlur) || (formName[inputName[0]].$touched && validateOnBlur)) && formName[inputName[0]].$error.required">
                <span ng-if="userNameInfo && userNameInfo.requiredError">{{userNameInfo.requiredError}}</span> <!-- customized -->
                <span ng-if="!(userNameInfo && userNameInfo.requiredError)"><cv:msg key="error.userName" bundle="settings" /></span> <!-- default -->
            </span>
            <!-- email pattern error -->
            <span class="help-block text-left" data-ng-if="(userNameInfo && userNameInfo.type === 'Email') && (formName.$submitted || (formName[inputName[0]].$dirty && !validateOnBlur) || (formName[inputName[0]].$touched && validateOnBlur)) && formName[inputName[0]].$error.pattern ">
            	<cv:msg key="error.validEmailAddress" bundle="setup" />
            </span>
        </div>
    </div>
    <div class="form-group" data-ng-class="{row: rowClass}">

        <label data-ng-class="{'{{labelClass}}': labelClass, 'col-xs-12 col-sm-4 ': !labelClass}" for="pass">
        	<span ng-if="userNameInfo && userNameInfo.passwordLabel">{{userNameInfo.passwordLabel}}</span> <!-- customized password label-->
        	<span ng-if="!(userNameInfo && userNameInfo.passwordLabel)"><cv:msg key="label.password" bundle="users" /></span> <!-- default -->
        </label>
        <div data-ng-class="{'{{inputClass}}' : inputClass, 'col-xs-12 col-sm-8' : !inputClass}">
            <input type="password" id="pass" name="{{inputName[1]}}" class="full-width" data-ng-model="credentials[inputName[1]]" data-ng-change="passwordsChanged()" placeholder="{{passwordKeep}}" data-ng-required="isPasswordRequired" data-ng-pattern="passwordPattern" />
            <!-- required error -->
            <span class="help-block text-left" data-ng-if="(formName.$submitted || (formName[inputName[1]].$dirty && !validateOnBlur) || (formName[inputName[1]].$touched && validateOnBlur)) && formName[inputName[1]].$error.required">
            	<cv:msg key="error.password" bundle="settings"/>
            </span>
            <!-- password complexity error (pattern check) -->
            <span class="help-block text-left" data-ng-if="(formName.$submitted || (formName[inputName[1]].$dirty && !validateOnBlur) || (formName[inputName[1]].$touched && validateOnBlur)) && formName[inputName[1]].$error.pattern ">
            	{{passwordPatternError}}
            </span>
        </div>
    </div>
    <div class="form-group" data-ng-class="{row: rowClass}" data-ng-if="needConfirm">
        <label data-ng-class="{'{{labelClass}}': labelClass, 'col-xs-12 col-sm-4 ': !labelClass}" for="confirm"><cv:msg key="label.confirmPassword" bundle="users" /></label>
        <div data-ng-class="{'{{inputClass}}' : inputClass, 'col-xs-12 col-sm-8' : !inputClass}">
            
			<input type="password" name="{{inputName[2]}}" id="confirm" class="full-width" data-ng-model="credentials[inputName[2]]" placeholder="{{passwordKeep}}" data-ng-change="passwordsChanged()"
            cv-compare-to="credentials[inputName[1]]" data-ng-required="isPasswordRequired">

            <span data-ng-if="formName.$submitted || (formName[inputName[1]].$dirty && !validateOnBlur) || (formName[inputName[1]].$touched && validateOnBlur) || (formName[inputName[2]].$dirty && !validateOnBlur) || (formName[inputName[2]].$touched && validateOnBlur)">
                <span class="help-block text-left" data-ng-show="formName[inputName[2]].$valid == false || formName[inputName[1]].$error.required"><cv:msg key="error.confirmPassword" bundle="settings" /></span>
            </span>
        </div>
    </div>
</div>