import ColumnFilter from '../newGrid/columnFilter';

export default class NumericTextBox extends ColumnFilter {
	get textInput() {
		return this.isBuilt() ? this.numericTextBox._text : null;
	}

	get wrapper() {
		return this.isBuilt() ? this.numericTextBox.wrapper : null;
	}

	build(element, initialFilterData) {
		super.build(element);
		element.kendoNumericTextBox({
			decimal: 0,
			format: '#',
			change: this.onFilterInputChange.bind(this),
		});
		this.numericTextBox = element.getKendoNumericTextBox();

		// Update the input tooltip on input:
		const onTextInputChange = _.debounce(this.refreshInputTooltip.bind(this), 150);
		this.textInput.on('input', onTextInputChange);
		this.textInput.on('change', onTextInputChange);
	}

	setInputValue(val) {
		if (this.isBuilt()) {
			this.numericTextBox.value(val);
			this.refreshInputTooltip();
		}
	}

	getInputValue() {
		if (this.isBuilt()) {
			return this.numericTextBox.element.val();
		}
		return null;
	}

	destroy() {
		super.destroy();
		if (this.isBuilt()) {
			this.numericTextBox.destroy();
		}
	}
}
