const cvCommon = angular.module('cvCommon');

class TagsService {
    constructor($http) {
        this.$http = $http;
    }

    getTagsForUser() {
		return this.$http.post(
			'proxy/getTagsForUser',
			JSON.stringify({ entityType: 9504, userGuid: cv.userGUID }),
			httpHeader.jsonDefaultHeader
		);
	}

	createTag(payload) {
		return this.$http.post('proxy/ContainerItems', JSON.stringify(payload), httpHeader.jsonDefaultHeader);
	}

	createTagSet(payload) {
		return this.$http.post('proxy/PerformContainerOperation', JSON.stringify(payload), httpHeader.jsonDefaultHeader);
	}

	applyTagForItem(payload) {
		return this.$http.post('proxy/updatemetadata', JSON.stringify(payload), httpHeader.jsonDefaultHeader);
	}

	getTagsForEntity(entity) {
		return this.$http.get('proxy/Tags/'+ entity.entityType + '/' + entity.entityId);
	}

	addTagsToEntity(payload) {
		return this.$http.post('proxy/Tags', JSON.stringify(payload),httpHeader.jsonDefaultHeader);
	}

	editTagsForEntity(payload) {
		return this.$http.put('proxy/Tags', JSON.stringify(payload),httpHeader.jsonDefaultHeader);
	}

	deleteTagsFromEntity(payload) {
		return this.$http({
			method: 'DELETE',
			url: cv.contextPath + '/proxy/Tags',
			data: JSON.stringify(payload),
			headers: {
				'Content-Type': 'application/json',
				'Accept': 'application/json'
			}
		});
	}

}

TagsService.$inject = ['$http'];
cvCommon.service('tagsService', TagsService);