import 'common/js/tags/tags.svc.js';

export default class TagUtility {
	constructor(injector) {
		this.injector = injector;
		this.cvLoc = injector.get('cvLoc');
		this.$dialogs = injector.get('$dialogs');
		this.$http = injector.get('$http');
		this.modal = injector.get('$uibModal');
		this.cvToaster = injector.get('cvToaster');
		this.tagsService = injector.get('tagsService');
	}

	async createTag(createTagset, tagset, container) {
		if (createTagset) {
			const containerPayload = {
				entityType: 9504,
				operationType: 1,
				userGuid: cv.userGUID,
				fromSite: 2,
				container: {
					containerType: 9504,
					containerName: tagset,
					containerOwnerType: 1,
					comment: ''
				}
			};
			let data;
			try {
				data = await this.tagsService.createTagSet(containerPayload);
				if (data && data.data) {
					container = data.data.container;
				}
			} catch (err) {}
		}
		return this.openCreateTagDialog(container);
	}

	async applyTag(tag, items, appId) {
		const payload = {
			appId: {
				subclientId: appId
			},
			indexItems: _.map(items, item => {
				return {
					guid: item.id,
					customProperties: {
						nameValues: _.isArray(tag)
							? _.map(tag, t => {
									return {
										name: 'TAGGUID_s',
										value: t.id
									};
							  })
							: [
									{
										name: 'TAGGUID_s',
										value: tag.id
									},
									{
										name: 'ContentIndexingStatus',
										value: '0'
									}
							  ]
					}
				};
			})
		};
		return this.tagsService.applyTagForItem(payload).then(
			res => res,
			err => err
		);
	}

	openCreateTagDialog(container) {
		const self = this;
		const _modalInstance = self.modal.open({
			backdrop: 'static',
			windowClass: 'small-size',
			templateUrl: appUtil.appRoot + 'common/partials/addTag.jsp',
			controller: [
				'$scope',
				'$uibModalInstance',
				'cvUtil',
				function ($scope, $uibModalInstance, cvUtil) {
					$scope.__modal = $uibModalInstance;
					$scope.serverMessage = undefined;
					$scope.addTag = () => {
						const reqObj = {
							container,
							userInfo: {
								userGuid: cv.userGUID
							},
							orgContainer: container,
							tagModifyRequest: {
								domainName: '',
								operationType: 2,
								userName: '',
								userGuid: ''
							},
							filter: {
								groupByPagingData: {
									startIndex: 0,
									fetchEmails: true,
									requestFired: '',
									pageSize: 0,
									fetchFiles: true,
									orderByClause: ''
								},
								ignoreGroupingResults: true,
								ignoreResultItems: false,
								groupByColumn: ''
							},
							tag: {
								entityDetail: {},
								attribute: {
									all: false,
									hideEndUser: false,
									system: false,
									hidden: false,
									disabled: false,
									defaultAttr: false
								},
								tagOwnerType: 1,
								name: $scope.tagName,
								flags: 0,
								fullName: '',
								tagId: 0,
								description: $scope.tagDescription,
								id: ''
							},
							searchRequest: '',
							queryId: '',
							jobId: 0,
							operationType: 1,
							isCompliancePolicy: false,
							operationOn: 0
						};
						self.tagsService.createTag(reqObj).then(
							res => {
								const err = _.get(res, 'data.errList[0].errLogMessage');
								if (err) {
									$scope.serverMessage = cvUtil.errMsg(err);
								} else {
									$scope.serverMessage = undefined;
									$uibModalInstance.close(res);
								}
							},
							err => {}
						);
					};
					$scope.closeDialog = () => {
						$uibModalInstance.dismiss();
					};
				}
			]
		});

		return _modalInstance;
	}

	getTags(tagset) {
		return this.tagsService.getTagsForUser().then(
			res => {
				let tags = [];
				let container;
				if (res && res.data) {
					_.each(res.data.listOftagSetList, item => {
						_.each(item.tagSetsAndItems, tagSet => {
							if (tagSet.container.containerName === tagset) {
								container = tagSet.container;
								tags = tagSet.tags;
								tags.container = container;
							}
						});
					});
				}

				return tags;
			},
			err => err
		);
	}

	showJobNotification(oParams, context) {
		context.$apply(() => {
			const jobId = _.get(oParams.response, 'jobId');
			if (jobId)
				this.cvToaster.showSuccessMessage({
					ttl: '7000',
					message:
						this.cvLoc('notification.worflow.started') +
						' ' +
						jobId +
						' <br><a href=#/jobs/' +
						jobId +
						'>' +
						this.cvLoc('notification.jobDetails') +
						'</a>'
				});
		});
	}

	openTrainDialog(tagset, plan, caseId, context) {
		const self = this;
		const _modalInstance = self.modal.open({
			backdrop: 'static',
			templateUrl: appUtil.appRoot + 'common/partials/trainClassifier.jsp',
			controller: [
				'$scope',
				'$uibModalInstance',
				'cvUtil',
				function ($scope, $uibModalInstance, cvUtil) {
					$scope.__modal = $uibModalInstance;
					$scope.serverMessage = undefined;
					$scope.localLang = cvUtil.getIStevenLocLabels();
					$scope.dataLoading = true;
					$scope.tc = {};
					let tags = [];
					let entities = [];
					$scope.closeDialog = () => {
						$uibModalInstance.dismiss();
					};
					$scope.startTraining = () => {
						openForm({
							workflowName: 'automate Mail download from a Case in Case-Manager',
							success: (sParams, oParams) => {
								self.showJobNotification.call(self, oParams, context);
							},
							inputs: {
								tag: JSON.stringify(_.find(tags, { tagId: $scope.tc.selectedTag[0].tagId })),
								entity: JSON.stringify(_.find(entities, { entityId: $scope.tc.selectedEntity[0].entityId })),
								caseId: caseId
							},
							_submit: true,
							showWarningMessage: false
						});
						$scope.closeDialog();
					};

					$scope.selectTag = () => {
						$scope.tc.selectTag = _.get($scope, 'tc.selectedTag[0]');
					};

					$scope.selectEntity = () => {
						$scope.tc.selectEntity = _.get($scope, 'tc.selectedEntity[0]');
					};

					const init = async () => {
						const data = await self.getTags(tagset);
						_.forEach(_.get(plan, 'eePolicy.detail.eePolicy.extractionPolicy.extractionPolicyList'), list => {
							_.forEach(list.tags, tag => {
								if (tag.entityDetail.entityType === 'ML_MODEL') {
									entities.push(tag.entityDetail);
								}
							});
						});
						tags = data || [];
						$scope.tags =
							_.map(_.cloneDeep(tags), tag => {
								return {
									...tag,
									label: tag.name
								};
							}) || [];
						$scope.entities = _.map(_.cloneDeep(entities), entity => {
							return {
								...entity,
								label: entity.displayName
							};
						});
						$scope.dataLoading = false;
					};
					init();
				}
			]
		});

		return _modalInstance;
	}

	startClassification(subclientId, planId, context) {
		const self = this;
		if (subclientId && planId) {
			openForm({
				workflowName: 'case manager entity classification',
				success: (sParams, oParams) => {
					self.showJobNotification.call(self, oParams, context);
				},
				inputs: {
					subclientId,
					planId
				},
				_submit: true,
				showWarningMessage: false
			});
		}
	}
}
