import 'common/js/tags/tags.svc.js';
import TagUtility from 'common/js/tags/tag.util.js';

export class CVAddTagController {
	constructor($scope, $injector, tagsService) {
		this.$scope = $scope;
		this.tagsService = tagsService;
		this.tagUtil = new TagUtility($injector);
	}

	$onInit() {
		this.loadTags();
	}

	createNewTag() {
		const self = this;
		const data = self.tagUtil.createTag(self.tags && !self.tags.length, self.tagset, _.get(self.tags, 'container'));
		if (data) {
			data.then(res => {
				if (res.result) {
					res.result.then(res => {
						self.loadTags();
					});
				}
			});
		}
	}

	async applyTag(tag) {
		const data = await this.tagUtil.applyTag(tag, this.tagItems, this.entity.id);
		if (data) {
			if (this.onTagApply) {
				this.tagItems = [];
				this.onTagApply(tag);
			}
		}
	}

	async loadTags() {
		let data;
		try {
			data = await this.tagUtil.getTags(this.tagset);
			this.tags = data || [];
		} catch (err) {}
	}
}

CVAddTagController.$inject = ['$scope', '$injector', 'tagsService'];
