import { cvCommonModule } from './modules';

export class ReorderService {
	static $inject = ['$uibModal'];
	constructor($modal) {
		this.$modal = $modal;
	}

	/**
	 * @param {Object} options 
	 * @param {string} [options.title]
	 * @param {Object[]} options.list
	 * @param {string} options.list[].label
	 * @param {string} options.list[].cssClass
	 * @param {string} options.list[].hidden
	 * @param {string} [options.labelProperty=label]
	 * @param {string} [options.cssClassProperty=cssClass]
	 * @param {string} [options.hiddenProperty=hidden]
	 */
	openModal(options) {
		const modalInstance = this.$modal.open({
			templateUrl: `${appUtil.appRoot}common/partials/reorderModal.jsp`,
			backdrop: 'static',
			windowClass: 'reorder-view-modal',
			controllerAs: 'ctrl',
			bindToController: true,
			controller: [
				'$uibModalInstance',
				'cvLoc',
				'options',
				function($modalInstance, cvLoc, options) {
					if (!('title' in options)) {
						this.title = cvLoc('label.reorder');
					} else {
						this.title = options.title;
					}
					this.list = options.list.slice();
					this.hiddenProperty = options.hiddenProperty || 'hidden';
					this.labelProperty = options.labelProperty || 'label';
					this.cssClassProperty = options.cssClassProperty || 'cssClass';

					this.saveOrder = () => {
						$modalInstance.close(this.list);
					};

					this.cancel = () => {
						$modalInstance.dismiss();
					};
				}
			],
			resolve: {
				options: () => options,
			},
		});

		return modalInstance.result;
	}
};

cvCommonModule.service('reorderService', ReorderService)
