/**
 * @author isabel maria 
 * // This is to isolate the kendo global variable. 
 * // We can now inject a kendoTest variable for testing
 */


export default class Tree{
	constructor(options, treeElement, _kendo, angularLibs) {
		this.kendo = _kendo;
		this.options = options;
		this.treeElement = treeElement;
		this.angularLibs = angularLibs;
		this.treeName = options.treeName;
		this.checkedUid = "";
		this.checkedParentUid = "";
		this._setOptions();
		if(!_.isUndefined(options.headNodeDetails)){
			this.headNodeDetails = options.headNodeDetails;
			this.headNodeDetails.headNodeLabel = this.headNodeDetails[this.options.dataTextField];
			this.headNodeDetails[options.hasChildren]= true;
			this.headNodeDetails.expanded = this.headNodeDetails.expanded || false;
			this.headNodeDetails[options.children] = [];
			this.headNodeDetails.headNode = true;
		}
		this.treeElement.attr('id', this.treeName);
		let height = $(window).height() - 250;
		this.treeElement.css('height', this.options.height ? this.options.height : height);
		this.treeElement.css('max-height', this.height ? this.height : height );
		
		this._setupEventListeners(this.options);
	}

	_setOptions(){
		this.options.enableCheckbox = this.options.enableCheckbox || false;
		this.options.serverFiltering = this.options.serverFiltering || false;
		this.options.enableTreeSearch = this.options.enableTreeSearch || this.options.serverFiltering;
		this.options.enablePaging = this.options.enablePaging || false;
		this.options.enableSingleSelect = this.options.enableSingleSelect || false;
		this.options.enableMultiLevelSelect = !_.isUndefined(this.options.enableMultiLevelSelect)? this.options.enableMultiLevelSelect
							: !this.options.enableSingleSelect; // selecting child across  different sibling nodes
		this.options.disableHierarchyCheckboxSelection = this.options.disableHierarchyCheckboxSelection || false; // to prevent parent node from being selected if all child is selected or vice-versa

		this.options.expandNode = this.options.url;
		if(_.isUndefined(this.options.select)){
			this.options.select = this.options.expandNode;
		}
		if(!_.isUndefined(this.options.headNodeDetails)){
			this.options.url = this._fetchData.bind(this);
		}

		if(_.isUndefined(this.options.dataTextField) && _.isUndefined(this.options.nodeTemplate)){
			this.options.dataTextField = "label";
		}
		if(_.isUndefined(this.options.children)){
			this.options.children = 'childData';
		}
		if(_.isUndefined(this.options.hasChildren)){
			this.options.hasChildren = 'hasChild';
		}
		if(_.isUndefined(this.options.dataPageSize)){
			this.options.dataPageSize = 10;
		}
		if(_.isUndefined(this.options.tooltipField)){
			this.options.toolTipField = "label";
		}
        this.options.currentPage = 0;
		this.searchValue = "";
	}

	buildDataSourceOptions(options) {
		var config = {};
		this._configureSchema(config, options);
		this._configureTransport(config, options);
		config.serverFiltering = options.serverFiltering || false;
		return config;
	}

	_configureSchema(config, options) {
		config.schema = {};
		config.schema.model = {};
		config.schema.model.id = options.idField || '';
		config.schema.model.hasChildren = options.hasChildren || false;
		config.schema.model.fields = options.fields;
	}

	_configureTransport(config, options) {
		if (options.url) {
			config.transport = {};
			config.transport.read = options.url;
		} else {
			config.data = options.data;
		}
	}

	registerCallbacks(key, fnCallback) {
		this.callbacks[key] = fnCallback || function() {};
	}

	_setupEventListeners(options) {
		this.callbacks = {};
		this.registerCallbacks('dataBound', options.dataBound);
		this.registerCallbacks('onTreeSelectionChange', options.onTreeSelectionChange);
		this.registerCallbacks('beforeTreeInitialize', options.beforeTreeInitialize);
		this.registerCallbacks('afterTreeInitialize', options.afterTreeInitialize);
	}

	_checkboxSelected(e){

		//to integrate, if mutli-level select disabled, if callback requested 
		//do it before clearing currently selected nodes
		
		let oldChecked = "";
		var dataItem = this.treeview.dataItem(e.node);
		var parent = this.treeview.dataItem(this.treeview.parent(e.node));
		let currentParentUID = parent.uid;
		const newSelectedNodeUID = dataItem.uid;
		if(_.isUndefined(currentParentUID )){
			currentParentUID = dataItem.uid;
		}
		if(this.options.enableSingleSelect) {
			if(dataItem.checked) {
				if(dataItem.checked && this.checkedUid != "") {
					oldChecked = e.sender.findByUid(this.checkedUid);
					e.sender.dataItem(oldChecked).set("checked", false);
				}
			} else {
				this.checkedUid = "";
				this.checkedParentUid = "";
			}
		} else if(!this.options.enableMultiLevelSelect) { //Single level select
			if(dataItem.checked) {
				//if current node and previous node has same parent
				//if its the parent of previous node being selected
				//if not, then de-select the previous ones
				if(this.checkedParentUid !== "" || this.checkedUid !== ""){
					if(!(this.checkedParentUid === currentParentUID || this.checkedUid === currentParentUID)){
						
						if(this.checkedParentUid !== ""){
							oldChecked = e.sender.findByUid(this.checkedParentUid);
							if(this.options.disableHierarchyCheckboxSelection){
								this.clearAllTreeSelections(); // Clearing all nodes, as which all nodes marked is not available
								let currentChecked = e.sender.findByUid(newSelectedNodeUID);
								e.sender.dataItem(currentChecked).set("checked", true); 
							} else {
								e.sender.dataItem(oldChecked).set("checked", true); //if old parent is half checked(indeterminate state)
								setTimeout(() => {
									e.sender.dataItem(oldChecked).set("checked", false);
									//if root node uid  = this.checkedParentUid, then the new node checked is also unchecked.
									//To revert this, check the current active node again
									let currentChecked = e.sender.findByUid(newSelectedNodeUID);
									e.sender.dataItem(currentChecked).set("checked", true); 
								});
							}
						} else if(this.checkedUid !== ""){
							oldChecked = e.sender.findByUid(this.checkedUid);
							e.sender.dataItem(oldChecked).set("checked", false);
						}  
					}
				}
			} else if (this.getCheckedItemsCount() === 0){
				this.checkedUid = "";
				this.checkedParentUid = "";
			} else {
				this.checkedUid = "";
			}
		} 
		if(dataItem.checked){
			this.checkedUid = dataItem.uid;
			this.checkedParentUid = parent.uid;
			if(_.isUndefined(this.checkedParentUid )){
				this.checkedParentUid = this.checkedUid;
			}
		}

		// if(item.checked){
		// 	this.treeview.findByUid(item.uid).addClass('node-selected');
		// } else {
		// 	this.treeview.findByUid(item.uid).addClass('node-selected');
		// }

		if(this.options.checkboxSelected){
			this.options.checkboxSelected(dataItem, parent);
		} 
	}

	_nodeSelected(event){
		if(this.options.nodeSelected){
			this.options.nodeSelected(event);
		} 
	}

	_nodeCollapsed(e){
		var item = this.treeview.dataItem(e.node);
		var parent = this.treeview.dataItem(this.treeview.parent(e.node));
		if(this.options.nodeCollapsed){
			this.options.nodeCollapsed(item, parent);
		} 
	}

	_onDragStart(e){
		var item = this.treeview.dataItem(e.node);
		var parent = this.treeview.dataItem(this.treeview.parent(e.node));
		if(this.options.onDragStart){
			this.options.onDragStart(item, parent);
		} 
	}

	_onDrag(e){
		var item = this.treeview.dataItem(e.node);
		var parent = this.treeview.dataItem(this.treeview.parent(e.node));
		if(this.options.onDrag){
			this.options.onDrag(item, parent);
		} 
	}

	_onDrop(e){
		var item = this.treeview.dataItem(e.node);
		var parent = this.treeview.dataItem(this.treeview.parent(e.node));
		if(this.options.onDrop){
			this.options.onDrop(item, parent);
		} 
	}

	_onDragEnd(e){
		var item = this.treeview.dataItem(e.node);
		var parent = this.treeview.dataItem(this.treeview.parent(e.node));
		if(this.options.onDragEnd){
			this.options.onDragEnd(item, parent);
		} 
	}

	_onNavigatebyKey(e){
		var item = this.treeview.dataItem(e.node);
		var parent = this.treeview.dataItem(this.treeview.parent(e.node));
		if(this.options._onNavigatebyKey){
			this.options._onNavigatebyKey(item, parent);
		} 
	}
	
	_addCoustomClassToNodeUID(uid, className){
		this.treeview.findByUid(uid).addClass(className);
	}

	_getSelectedNodeDetailsUID(uid){
		var node = this.treeview.findByUid(uid);
		var selectedItem = this.treeview.dataItem(node);
		return selectedItem;
    }
    
    _selectTree(e){
        let currentSelectedItem = this.treeview.dataItem(e.node);
		let parent = this.treeview.dataItem(this.treeview.parent(e.node));
		if(_.isUndefined( parent )){
			parent = currentSelectedItem;
        }

        var expandOptions = {
            currentNode : currentSelectedItem,
            success : this._success.bind(this, currentSelectedItem)
        };
	
		if(currentSelectedItem.isMoreNode === true && this.options.enablePaging === true){
			this.selectedMoreID =  currentSelectedItem.id;
			currentSelectedItem = parent;
            expandOptions.loadMoreInfo = {
                moreData: true,
                pageNumber: this.options.currentPage,
                pageSize: this.options.dataPageSize
            };
            this.options.select(expandOptions, currentSelectedItem, parent);
		} else {
			if(this.options.select){
				this.options.select(expandOptions, currentSelectedItem, parent);
		   } else {
			   this.treeview.expand(e.node);
		   }
		}
	}

	_expandNode(e){
        let currentSelectedItem = this.treeview.dataItem(e.node);
        var parent = this.treeview.dataItem(this.treeview.parent(e.node));
        if(_.isUndefined(parent)){
			parent = currentSelectedItem;
        }
        if(_.get(currentSelectedItem, 'dirtyFields.expanded', false)){
			//already expanded node, don't place API call
			//just expand the node
			return;
		}
        var expandOptions = {
            currentNode : currentSelectedItem,
            success : this._success.bind(this, currentSelectedItem)
        };
	
	    if(currentSelectedItem.isMoreNode === true && this.options.enablePaging === true){
			this.selectedMoreID =  currentSelectedItem.id;
			currentSelectedItem = parent;
            expandOptions.loadMoreInfo = {
                moreData: true,
                pageNumber: this.options.currentPage,
                pageSize: this.options.dataPageSize
            };
            this.options.select(expandOptions, currentSelectedItem, parent);
	    } else {
		    this.selectNode(currentSelectedItem.id);
		    if(this.options.expandNode){
		    	this.options.expandNode(expandOptions, currentSelectedItem, parent);
		    }
	    }
    }
    
    _success(selectedItem, treeData, noMoreChildNodes){
        noMoreChildNodes = noMoreChildNodes || false;
        this.addTreeNodes(treeData, _.get(selectedItem, this.options.idField, _.get(this.headNodeDetails, this.options.idField, '')), noMoreChildNodes);
	}
	
	_getCheckedNodes(nodes, getSelectedNodeHierarchy){
		var node, childCheckedNodes;
		var checkedNodes = [];
		for (var i = 0; i < nodes.length; i++) {
			node = nodes[i];
			if (node.checked) {
				checkedNodes.push(node);
			}
			if (node.hasChildren) {
				childCheckedNodes = this._getCheckedNodes(node.children.view());
				if (childCheckedNodes.length > 0){
					if(getSelectedNodeHierarchy && !node.checked){
						checkedNodes.push(node);
					}
					checkedNodes = checkedNodes.concat(childCheckedNodes);
				}
			}
		}
		return checkedNodes;
	}

	_unmarkAllNodes(nodes){
		if(!_.isUndefined(nodes)){
			for (let i = 0; i < nodes.length; i++) {
				let node = nodes[i];
				if (node.hasChildren && !node.checked) {
					this._unmarkAllNodes(node.children.view());
			    }
				if (node.checked) {
					this._getSelectedNodeDetailsUID(node.uid).set("checked", false);
				}
			}
		}
	}

    _checkPaging(treeData, noMoreChildNodes, nodeID){
        let currentSelectedItem = this.getSelectedNodeDetails(nodeID);
		if(this.options.currentPage === 0 && noMoreChildNodes === false){
			if( !this.hasChildNodesPresent(nodeID)){
				if(this.options.dataPageSize * this.options.currentPage + this.options.dataPageSize < currentSelectedItem.childCount){
					treeData.push({
                        hasChild : false,
                        isMoreNode : true
					});
					_.set(treeData[treeData.length -1], this.options.dataTextField, "More");
					_.set(treeData[treeData.length -1], this.options.idField, Math.floor(Math.random() * 10000000));
					_.set(treeData[treeData.length -1], this.options.pathParent, nodeID);
					this.pushData(treeData, nodeID);
				} else {
					this.pushData(treeData, nodeID);
				}
			}
		} else if(this.options.dataPageSize * this.options.currentPage + this.options.dataPageSize >= currentSelectedItem.childCount || noMoreChildNodes === true){
			if(this.options.currentPage !== 0 ){
				this.getMoreNodeID(nodeID);
				this.removeNode(this.selectedMoreID);
			}
			this.pushData(treeData, nodeID);
		} else {
			this.getMoreNodeID(nodeID);
			this.insertBefore(treeData, this.selectedMoreID);
		}
		this.selectNode(nodeID);
		delete this.selectedMoreID;
	}
	
	getMoreNodeID(nodeID){
		const childNodeList = this.getSelectedNodeDetails(nodeID).children.view();
		if(childNodeList.length > 0 && childNodeList[childNodeList.length - 1].isMoreNode){
			this.selectedMoreID = childNodeList[childNodeList.length - 1].id;
		}
	}

	destroy() {
		this.destroyed = true;
	}

}
